/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.bsl.context;

import com.example.vibe.bsl.context.BslContext;
import com.example.vibe.bsl.context.IBslContextProvider;
import com.example.vibe.core.logging.VibeLogger;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class BslContextProvider
implements IBslContextProvider {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(BslContextProvider.class);
    private static final int MAX_CONTEXT_LINES = 50;
    private static final int MAX_SURROUNDING_CHARS = 2000;

    /*
     * WARNING - void declaration
     */
    @Override
    public BslContext getContext(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IDocument document = this.getDocument(editor);
        if (document == null) {
            return null;
        }
        ISelectionProvider selectionProvider = this.getSelectionProvider(editor);
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        ISelection iSelection = selection;
        if (iSelection instanceof ITextSelection) {
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            int offset = textSelection.getOffset();
            return this.getContextAtOffset(editor, offset);
        }
        return null;
    }

    @Override
    public BslContext getContextAtOffset(IEditorPart editor, int offset) {
        LOG.debug("getContextAtOffset: editor=%s, offset=%d", new Object[]{editor != null ? editor.getClass().getName() : "null", offset});
        if (editor == null || offset < 0) {
            LOG.debug("getContextAtOffset: editor null or offset < 0");
            return null;
        }
        IDocument document = this.getDocument(editor);
        if (document == null) {
            LOG.debug("getContextAtOffset: document is null");
            return null;
        }
        LOG.debug("getContextAtOffset: got document, length=%d", new Object[]{document.getLength()});
        try {
            return this.buildContext(editor, document, offset);
        }
        catch (BadLocationException e) {
            LOG.error("getContextAtOffset: BadLocationException", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private IDocument getDocument(IEditorPart editor) {
        IDocument doc;
        IEditorInput input;
        IDocumentProvider provider;
        IEditorPart iEditorPart;
        IAdaptable provider2;
        LOG.debug("getDocument: trying to get document from %s", new Object[]{editor.getClass().getName()});
        IEditorPart iEditorPart2 = editor;
        if (iEditorPart2 instanceof ITextEditor) {
            IDocument doc2;
            void textEditor;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart2;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart2;
            LOG.debug("getDocument: editor is ITextEditor directly");
            provider2 = textEditor.getDocumentProvider();
            IEditorInput input2 = textEditor.getEditorInput();
            if (provider2 != null && input2 != null && (doc2 = provider2.getDocument((Object)input2)) != null) {
                LOG.debug("getDocument: got via ITextEditor.getDocumentProvider()");
                return doc2;
            }
        }
        if ((iEditorPart = editor) instanceof IAdaptable) {
            void adaptable;
            provider2 = (IAdaptable)iEditorPart;
            IAdaptable cfr_ignored_1 = (IAdaptable)iEditorPart;
            ITextEditor textEditor = (ITextEditor)adaptable.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                IDocument doc3;
                LOG.debug("getDocument: got ITextEditor via adapter");
                provider = textEditor.getDocumentProvider();
                input = textEditor.getEditorInput();
                if (provider != null && input != null && (doc3 = provider.getDocument((Object)input)) != null) {
                    LOG.debug("getDocument: got via adapted ITextEditor.getDocumentProvider()");
                    return doc3;
                }
            }
        }
        if ((doc = (IDocument)editor.getAdapter(IDocument.class)) != null) {
            LOG.debug("getDocument: got via IDocument adapter");
            return doc;
        }
        doc = this.invokeMethod(editor, "getDocument", IDocument.class);
        if (doc != null) {
            LOG.debug("getDocument: got via getDocument() reflection");
            return doc;
        }
        provider = this.invokeMethod(editor, "getDocumentProvider", IDocumentProvider.class);
        if (provider != null) {
            LOG.debug("getDocument: got DocumentProvider via reflection");
            input = editor.getEditorInput();
            if (input != null && (doc = provider.getDocument((Object)input)) != null) {
                LOG.debug("getDocument: got via getDocumentProvider().getDocument()");
                return doc;
            }
        }
        LOG.debug("getDocument: could not get document");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private ISelectionProvider getSelectionProvider(IEditorPart editor) {
        ISelectionProvider sp = editor.getSite().getSelectionProvider();
        if (sp != null) {
            return sp;
        }
        IEditorPart iEditorPart = editor;
        if (iEditorPart instanceof ITextEditor) {
            void textEditor;
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
            return textEditor.getSelectionProvider();
        }
        sp = (ISelectionProvider)editor.getAdapter(ISelectionProvider.class);
        if (sp != null) {
            return sp;
        }
        return this.invokeMethod(editor, "getSelectionProvider", ISelectionProvider.class);
    }

    private <T> T invokeMethod(Object target, String methodName, Class<T> returnType) {
        try {
            Class<?> clazz = target.getClass();
            while (clazz != null) {
                try {
                    Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    Object result = method.invoke(target, new Object[0]);
                    if (returnType.isInstance(result)) {
                        return (T)result;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private BslContext buildContext(IEditorPart editor, IDocument document, int offset) throws BadLocationException {
        ISelection selection;
        ISelection iSelection;
        String text = document.get();
        int length = document.getLength();
        offset = Math.min(offset, length);
        offset = Math.max(offset, 0);
        String prefix = text.substring(0, offset);
        String suffix = text.substring(offset);
        int line = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(line);
        int column = offset - lineOffset;
        String selectedCode = "";
        ISelectionProvider selectionProvider = this.getSelectionProvider(editor);
        if (selectionProvider != null && (iSelection = (selection = selectionProvider.getSelection())) instanceof ITextSelection) {
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            if (textSelection.getLength() > 0) {
                selectedCode = textSelection.getText();
            }
        }
        String surroundingCode = this.getSurroundingCode(document, offset, line);
        String moduleName = "";
        String moduleType = "";
        String metadataObjectPath = "";
        IEditorInput input = editor.getEditorInput();
        IEditorInput iEditorInput = input;
        if (iEditorInput instanceof IFileEditorInput) {
            void fileInput;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFileEditorInput cfr_ignored_1 = (IFileEditorInput)iEditorInput;
            String path = fileInput.getFile().getFullPath().toString();
            moduleName = this.extractModuleName(path);
            moduleType = this.extractModuleType(path);
            metadataObjectPath = this.extractMetadataPath(path);
        }
        String currentMethod = this.findCurrentMethod(prefix);
        return BslContext.builder().prefix(prefix).suffix(suffix).cursorOffset(offset).cursorLine(line).cursorColumn(column).selectedCode(selectedCode).surroundingCode(surroundingCode).moduleName(moduleName).moduleType(moduleType).currentMethod(currentMethod).metadataObjectPath(metadataObjectPath).build();
    }

    private String getSurroundingCode(IDocument document, int offset, int currentLine) throws BadLocationException {
        int startLine = Math.max(0, currentLine - 25);
        int endLine = Math.min(document.getNumberOfLines() - 1, currentLine + 25);
        int startOffset = document.getLineOffset(startLine);
        int endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
        if (endOffset - startOffset > 2000) {
            int midPoint = (startOffset + endOffset) / 2;
            startOffset = Math.max(0, midPoint - 1000);
            endOffset = Math.min(document.getLength(), midPoint + 1000);
        }
        return document.get(startOffset, endOffset - startOffset);
    }

    private String extractModuleName(String path) {
        int prevSlash;
        if (path == null) {
            return "";
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash > 0 && (prevSlash = path.lastIndexOf(47, lastSlash - 1)) >= 0) {
            return path.substring(prevSlash + 1, lastSlash);
        }
        return "";
    }

    private String extractModuleType(String path) {
        if (path == null) {
            return "";
        }
        if ((path = path.toLowerCase()).contains("/forms/")) {
            return "FormModule";
        }
        if (path.contains("/commands/")) {
            return "CommandModule";
        }
        if (path.contains("/commonmodules/")) {
            return "CommonModule";
        }
        if (path.contains("/objectmodule.bsl")) {
            return "ObjectModule";
        }
        if (path.contains("/managermodule.bsl")) {
            return "ManagerModule";
        }
        if (path.contains("/recordsetmodule.bsl")) {
            return "RecordSetModule";
        }
        if (path.contains("/sessionmodule.bsl")) {
            return "SessionModule";
        }
        if (path.contains("/externalconnectionmodule.bsl")) {
            return "ExternalConnectionModule";
        }
        if (path.contains("/applicationmodule.bsl") || path.contains("/managedapplicationmodule.bsl")) {
            return "ApplicationModule";
        }
        return "Module";
    }

    private String extractMetadataPath(String path) {
        if (path == null) {
            return "";
        }
        int srcIdx = path.indexOf("/src/");
        if (srcIdx < 0) {
            return "";
        }
        String metaPath = path.substring(srcIdx + 5);
        int lastSlash = metaPath.lastIndexOf(47);
        if (lastSlash > 0) {
            metaPath = metaPath.substring(0, lastSlash);
        }
        return metaPath.replace("/", ".");
    }

    private String findCurrentMethod(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return "";
        }
        String[] lines = prefix.split("\n");
        int i = lines.length - 1;
        while (i >= 0) {
            String line = lines[i].trim().toLowerCase();
            if (line.startsWith("\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 ") || line.startsWith("procedure ")) {
                return this.extractMethodName(lines[i], "\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430", "procedure");
            }
            if (line.startsWith("\u0444\u0443\u043d\u043a\u0446\u0438\u044f ") || line.startsWith("function ")) {
                return this.extractMethodName(lines[i], "\u0444\u0443\u043d\u043a\u0446\u0438\u044f", "function");
            }
            if (line.startsWith("\u043a\u043e\u043d\u0435\u0446\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b") || line.startsWith("endprocedure") || line.startsWith("\u043a\u043e\u043d\u0435\u0446\u0444\u0443\u043d\u043a\u0446\u0438\u0438") || line.startsWith("endfunction")) {
                return "";
            }
            --i;
        }
        return "";
    }

    private String extractMethodName(String line, String ... keywords) {
        String trimmed = line.trim();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            int idx = trimmed.toLowerCase().indexOf(keyword);
            if (idx >= 0) {
                String afterKeyword = trimmed.substring(idx + keyword.length()).trim();
                StringBuilder name = new StringBuilder();
                char[] cArray = afterKeyword.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c = cArray[n4];
                    if (c == '(' || Character.isWhitespace(c)) break;
                    name.append(c);
                    ++n4;
                }
                return name.toString();
            }
            ++n2;
        }
        return "";
    }

    @Override
    public String formatForPrompt(BslContext context) {
        if (context == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!context.getModuleType().isEmpty()) {
            sb.append("Module Type: ").append(context.getModuleType()).append("\n");
        }
        if (!context.getModuleName().isEmpty()) {
            sb.append("Module Name: ").append(context.getModuleName()).append("\n");
        }
        if (!context.getMetadataObjectPath().isEmpty()) {
            sb.append("Metadata Path: ").append(context.getMetadataObjectPath()).append("\n");
        }
        if (!context.getCurrentMethod().isEmpty()) {
            sb.append("Current Method: ").append(context.getCurrentMethod()).append("\n");
        }
        sb.append("Cursor Position: Line ").append(context.getCursorLine() + 1).append(", Column ").append(context.getCursorColumn() + 1).append("\n");
        if (!context.getAvailableVariables().isEmpty()) {
            sb.append("Available Variables: ").append(String.join((CharSequence)", ", context.getAvailableVariables())).append("\n");
        }
        if (!context.getAvailableMethods().isEmpty()) {
            sb.append("Available Methods: ").append(String.join((CharSequence)", ", context.getAvailableMethods())).append("\n");
        }
        sb.append("\n");
        if (context.hasSelection()) {
            sb.append("Selected Code:\n```bsl\n").append(context.getSelectedCode()).append("\n```\n\n");
        }
        sb.append("Surrounding Code:\n```bsl\n").append(context.getSurroundingCode()).append("\n```\n");
        return sb.toString();
    }
}

