/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AgentConfig {
    public static final int DEFAULT_MAX_STEPS = 25;
    public static final long DEFAULT_TIMEOUT_MS = 300000L;
    public static final int DEFAULT_MAX_TOOL_OUTPUT_SIZE = 102400;
    private final int maxSteps;
    private final long timeoutMs;
    private final int maxToolOutputSize;
    private final Set<String> enabledTools;
    private final Set<String> disabledTools;
    private final boolean streamingEnabled;
    private final String systemPromptAddition;
    private final String profileName;

    private AgentConfig(Builder builder) {
        this.maxSteps = builder.maxSteps;
        this.timeoutMs = builder.timeoutMs;
        this.maxToolOutputSize = builder.maxToolOutputSize;
        this.enabledTools = Collections.unmodifiableSet(new HashSet<String>(builder.enabledTools));
        this.disabledTools = Collections.unmodifiableSet(new HashSet<String>(builder.disabledTools));
        this.streamingEnabled = builder.streamingEnabled;
        this.systemPromptAddition = builder.systemPromptAddition;
        this.profileName = builder.profileName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AgentConfig defaults() {
        return AgentConfig.builder().build();
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getMaxToolOutputSize() {
        return this.maxToolOutputSize;
    }

    public Set<String> getEnabledTools() {
        return this.enabledTools;
    }

    public Set<String> getDisabledTools() {
        return this.disabledTools;
    }

    public boolean isStreamingEnabled() {
        return this.streamingEnabled;
    }

    public String getSystemPromptAddition() {
        return this.systemPromptAddition;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean isToolAllowed(String toolName) {
        if (this.disabledTools.contains(toolName)) {
            return false;
        }
        if (this.enabledTools.isEmpty()) {
            return true;
        }
        return this.enabledTools.contains(toolName);
    }

    public String toString() {
        return "AgentConfig{maxSteps=" + this.maxSteps + ", timeoutMs=" + this.timeoutMs + ", streaming=" + this.streamingEnabled + ", profile=" + this.profileName + "}";
    }

    public static class Builder {
        private int maxSteps = 25;
        private long timeoutMs = 300000L;
        private int maxToolOutputSize = 102400;
        private Set<String> enabledTools = new HashSet<String>();
        private Set<String> disabledTools = new HashSet<String>();
        private boolean streamingEnabled = true;
        private String systemPromptAddition;
        private String profileName;

        private Builder() {
        }

        public Builder from(AgentConfig config) {
            if (config != null) {
                this.maxSteps = config.maxSteps;
                this.timeoutMs = config.timeoutMs;
                this.maxToolOutputSize = config.maxToolOutputSize;
                this.enabledTools = new HashSet<String>(config.enabledTools);
                this.disabledTools = new HashSet<String>(config.disabledTools);
                this.streamingEnabled = config.streamingEnabled;
                this.systemPromptAddition = config.systemPromptAddition;
                this.profileName = config.profileName;
            }
            return this;
        }

        public Builder enableTool(String toolName) {
            if (toolName != null && !toolName.isEmpty()) {
                this.enabledTools.add(toolName);
            }
            return this;
        }

        public Builder disableTool(String toolName) {
            if (toolName != null && !toolName.isEmpty()) {
                this.disabledTools.add(toolName);
            }
            return this;
        }

        public Builder maxSteps(int maxSteps) {
            if (maxSteps <= 0) {
                throw new IllegalArgumentException("maxSteps must be positive: " + maxSteps);
            }
            this.maxSteps = maxSteps;
            return this;
        }

        public Builder timeoutMs(long timeoutMs) {
            if (timeoutMs <= 0L) {
                throw new IllegalArgumentException("timeoutMs must be positive: " + timeoutMs);
            }
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Builder maxToolOutputSize(int maxToolOutputSize) {
            if (maxToolOutputSize <= 0) {
                throw new IllegalArgumentException("maxToolOutputSize must be positive");
            }
            this.maxToolOutputSize = maxToolOutputSize;
            return this;
        }

        public Builder enabledTools(Set<String> tools) {
            this.enabledTools = new HashSet<String>((Collection)Objects.requireNonNull(tools));
            return this;
        }

        public Builder disabledTools(Set<String> tools) {
            this.disabledTools = new HashSet<String>((Collection)Objects.requireNonNull(tools));
            return this;
        }

        public Builder streamingEnabled(boolean enabled) {
            this.streamingEnabled = enabled;
            return this;
        }

        public Builder systemPromptAddition(String addition) {
            this.systemPromptAddition = addition;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public AgentConfig build() {
            return new AgentConfig(this);
        }
    }
}

