/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.model.LlmMessage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AgentResult {
    private final AgentState finalState;
    private final String finalResponse;
    private final List<LlmMessage> conversationHistory;
    private final int stepsExecuted;
    private final int toolCallsExecuted;
    private final long executionTimeMs;
    private final String errorMessage;
    private final Throwable error;

    private AgentResult(Builder builder) {
        this.finalState = Objects.requireNonNull(builder.finalState);
        this.finalResponse = builder.finalResponse;
        this.conversationHistory = builder.conversationHistory != null ? Collections.unmodifiableList(builder.conversationHistory) : Collections.emptyList();
        this.stepsExecuted = builder.stepsExecuted;
        this.toolCallsExecuted = builder.toolCallsExecuted;
        this.executionTimeMs = builder.executionTimeMs;
        this.errorMessage = builder.errorMessage;
        this.error = builder.error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AgentResult success(String response, List<LlmMessage> history, int steps, int toolCalls, long timeMs) {
        return AgentResult.builder().finalState(AgentState.COMPLETED).finalResponse(response).conversationHistory(history).stepsExecuted(steps).toolCallsExecuted(toolCalls).executionTimeMs(timeMs).build();
    }

    public static AgentResult error(Throwable error, List<LlmMessage> history, int steps, long timeMs) {
        return AgentResult.builder().finalState(AgentState.ERROR).error(error).errorMessage(error.getMessage()).conversationHistory(history).stepsExecuted(steps).executionTimeMs(timeMs).build();
    }

    public static AgentResult cancelled(List<LlmMessage> history, int steps, long timeMs) {
        return AgentResult.builder().finalState(AgentState.CANCELLED).errorMessage("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c").conversationHistory(history).stepsExecuted(steps).executionTimeMs(timeMs).build();
    }

    public AgentState getFinalState() {
        return this.finalState;
    }

    public String getFinalResponse() {
        return this.finalResponse;
    }

    public List<LlmMessage> getConversationHistory() {
        return this.conversationHistory;
    }

    public int getStepsExecuted() {
        return this.stepsExecuted;
    }

    public int getToolCallsExecuted() {
        return this.toolCallsExecuted;
    }

    public long getExecutionTimeMs() {
        return this.executionTimeMs;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return this.finalState == AgentState.COMPLETED;
    }

    public boolean isCancelled() {
        return this.finalState == AgentState.CANCELLED;
    }

    public boolean isError() {
        return this.finalState == AgentState.ERROR;
    }

    public String toString() {
        return "AgentResult{state=" + String.valueOf((Object)this.finalState) + ", steps=" + this.stepsExecuted + ", toolCalls=" + this.toolCallsExecuted + ", timeMs=" + this.executionTimeMs + (String)(this.errorMessage != null ? ", error=" + this.errorMessage : "") + "}";
    }

    public static class Builder {
        private AgentState finalState;
        private String finalResponse;
        private List<LlmMessage> conversationHistory;
        private int stepsExecuted;
        private int toolCallsExecuted;
        private long executionTimeMs;
        private String errorMessage;
        private Throwable error;

        private Builder() {
        }

        public Builder finalState(AgentState state) {
            this.finalState = state;
            return this;
        }

        public Builder finalResponse(String response) {
            this.finalResponse = response;
            return this;
        }

        public Builder conversationHistory(List<LlmMessage> history) {
            this.conversationHistory = history;
            return this;
        }

        public Builder stepsExecuted(int steps) {
            this.stepsExecuted = steps;
            return this;
        }

        public Builder toolCallsExecuted(int toolCalls) {
            this.toolCallsExecuted = toolCalls;
            return this;
        }

        public Builder executionTimeMs(long timeMs) {
            this.executionTimeMs = timeMs;
            return this;
        }

        public Builder errorMessage(String message) {
            this.errorMessage = message;
            return this;
        }

        public Builder error(Throwable error) {
            this.error = error;
            return this;
        }

        public AgentResult build() {
            return new AgentResult(this);
        }
    }
}

