/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent;

import com.example.vibe.core.agent.AgentConfig;
import com.example.vibe.core.agent.AgentResult;
import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.IAgentRunner;
import com.example.vibe.core.agent.events.AgentCompletedEvent;
import com.example.vibe.core.agent.events.AgentEvent;
import com.example.vibe.core.agent.events.AgentStartedEvent;
import com.example.vibe.core.agent.events.AgentStepEvent;
import com.example.vibe.core.agent.events.ConfirmationRequiredEvent;
import com.example.vibe.core.agent.events.IAgentEventListener;
import com.example.vibe.core.agent.events.StreamChunkEvent;
import com.example.vibe.core.agent.events.ToolCallEvent;
import com.example.vibe.core.agent.events.ToolResultEvent;
import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.model.LlmRequest;
import com.example.vibe.core.model.LlmResponse;
import com.example.vibe.core.model.LlmStreamChunk;
import com.example.vibe.core.model.ToolCall;
import com.example.vibe.core.model.ToolDefinition;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolLogger;
import com.example.vibe.core.tools.ToolRegistry;
import com.example.vibe.core.tools.ToolResult;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class AgentRunner
implements IAgentRunner {
    private static final String PLUGIN_ID = "com.example.vibe.core";
    private static final ILog LOG = Platform.getLog(AgentRunner.class);
    private final ILlmProvider provider;
    private final ToolRegistry toolRegistry;
    private final String systemPrompt;
    private final List<IAgentEventListener> listeners = new CopyOnWriteArrayList<IAgentEventListener>();
    private final AtomicReference<AgentState> state = new AtomicReference<AgentState>(AgentState.IDLE);
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private final AtomicInteger currentStep = new AtomicInteger(0);
    private final AtomicLong startTimeMs = new AtomicLong(0L);
    private final AtomicInteger toolCallsCount = new AtomicInteger(0);
    private final AtomicReference<CompletableFuture<LlmResponse>> currentStreamingFuture = new AtomicReference();
    private final AtomicReference<ConfirmationRequiredEvent> pendingConfirmation = new AtomicReference();
    private final Object historyLock = new Object();
    private List<LlmMessage> conversationHistory = new ArrayList<LlmMessage>();

    public AgentRunner(ILlmProvider provider, ToolRegistry toolRegistry, String systemPrompt) {
        this.provider = Objects.requireNonNull(provider, "provider");
        this.toolRegistry = Objects.requireNonNull(toolRegistry, "toolRegistry");
        this.systemPrompt = systemPrompt != null ? systemPrompt : "";
    }

    public AgentRunner(ILlmProvider provider, ToolRegistry toolRegistry) {
        this(provider, toolRegistry, null);
    }

    @Override
    public CompletableFuture<AgentResult> run(String prompt, AgentConfig config) {
        return this.run(prompt, new ArrayList<LlmMessage>(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AgentResult> run(String prompt, List<LlmMessage> history, AgentConfig config) {
        Objects.requireNonNull(prompt, "prompt");
        Objects.requireNonNull(config, "config");
        if (!this.state.compareAndSet(AgentState.IDLE, AgentState.RUNNING)) {
            return CompletableFuture.failedFuture(new IllegalStateException("\u0410\u0433\u0435\u043d\u0442 \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f"));
        }
        this.resetState();
        Object object = this.historyLock;
        synchronized (object) {
            String fullSystemPrompt;
            this.conversationHistory = new ArrayList<LlmMessage>();
            if (history != null && !history.isEmpty()) {
                this.conversationHistory.addAll(history);
            }
            if (!(!this.conversationHistory.isEmpty() && this.isSystemMessage(this.conversationHistory.get(0)) || (fullSystemPrompt = this.buildSystemPrompt(config)).isEmpty())) {
                this.conversationHistory.add(0, LlmMessage.system(fullSystemPrompt));
            }
            this.conversationHistory.add(LlmMessage.user(prompt));
        }
        this.emit(new AgentStartedEvent(prompt, config));
        CompletionStage<AgentResult> result = this.executeLoop(config);
        if (config.getTimeoutMs() > 0L) {
            result = result.orTimeout(config.getTimeoutMs(), TimeUnit.MILLISECONDS).exceptionally(error -> {
                if (error instanceof TimeoutException || error.getCause() instanceof TimeoutException) {
                    return this.createTimeoutResult(config);
                }
                throw error instanceof RuntimeException ? (RuntimeException)error : new RuntimeException((Throwable)error);
            });
        }
        return result.whenComplete((res, err) -> {
            this.currentStreamingFuture.set(null);
            this.pendingConfirmation.set(null);
            if (res != null) {
                this.emit(new AgentCompletedEvent((AgentResult)res));
            }
            this.state.set(AgentState.IDLE);
        });
    }

    private void resetState() {
        this.cancelRequested.set(false);
        this.currentStep.set(0);
        this.toolCallsCount.set(0);
        this.startTimeMs.set(System.currentTimeMillis());
        this.currentStreamingFuture.set(null);
        this.pendingConfirmation.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentResult createTimeoutResult(AgentConfig config) {
        ArrayList<LlmMessage> historyCopy;
        long executionTime = System.currentTimeMillis() - this.startTimeMs.get();
        Object object = this.historyLock;
        synchronized (object) {
            historyCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        return AgentResult.builder().finalState(AgentState.ERROR).errorMessage("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: " + config.getTimeoutMs() + " \u043c\u0441").conversationHistory(historyCopy).stepsExecuted(this.currentStep.get()).toolCallsExecuted(this.toolCallsCount.get()).executionTimeMs(executionTime).build();
    }

    private CompletableFuture<AgentResult> executeLoop(AgentConfig config) {
        CompletableFuture<LlmResponse> responseFuture;
        if (this.cancelRequested.get()) {
            return this.completeCancelled();
        }
        int step = this.currentStep.incrementAndGet();
        if (step > config.getMaxSteps()) {
            return this.completeMaxStepsReached(config);
        }
        this.emit(new AgentStepEvent(step, config.getMaxSteps(), "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a LLM"));
        this.state.set(AgentState.RUNNING);
        LlmRequest request = this.buildRequest(config);
        try {
            responseFuture = config.isStreamingEnabled() && this.provider.supportsStreaming() ? this.executeStreaming(request, step) : this.provider.complete(request);
        }
        catch (Exception e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430", e);
            return CompletableFuture.completedFuture(this.createErrorResult(e));
        }
        return ((CompletableFuture)responseFuture.thenCompose(response -> this.handleResponse((LlmResponse)response, config))).exceptionally(error -> {
            Throwable cause = this.unwrapException((Throwable)error);
            if (this.cancelRequested.get() || cause instanceof CancellationException) {
                return this.createCancelledResult();
            }
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0446\u0438\u043a\u043b\u0435 \u0430\u0433\u0435\u043d\u0442\u0430", cause);
            return this.createErrorResult(cause);
        });
    }

    private CompletableFuture<LlmResponse> executeStreaming(LlmRequest request, int step) {
        CompletableFuture<LlmResponse> future = new CompletableFuture<LlmResponse>();
        this.currentStreamingFuture.set(future);
        StringBuilder contentBuilder = new StringBuilder();
        ArrayList toolCalls = new ArrayList();
        Consumer<LlmStreamChunk> chunkHandler = chunk -> {
            if (this.cancelRequested.get()) {
                if (!future.isDone()) {
                    future.completeExceptionally(new CancellationException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"));
                }
                return;
            }
            if (chunk.getContent() != null && !chunk.getContent().isEmpty()) {
                contentBuilder.append(chunk.getContent());
                this.emit(StreamChunkEvent.partial(step, chunk.getContent()));
            }
            if (chunk.getToolCalls() != null) {
                toolCalls.addAll(chunk.getToolCalls());
            }
            if (chunk.isComplete()) {
                this.emit(StreamChunkEvent.complete(step, chunk.getFinishReason()));
                LlmResponse response = LlmResponse.builder().content(contentBuilder.toString()).toolCalls(toolCalls).finishReason(chunk.getFinishReason()).build();
                future.complete(response);
            }
            if (chunk.getErrorMessage() != null) {
                future.completeExceptionally(new RuntimeException(chunk.getErrorMessage()));
            }
        };
        try {
            this.provider.streamComplete(request, chunkHandler);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<AgentResult> handleResponse(LlmResponse response, AgentConfig config) {
        if (this.cancelRequested.get()) {
            return this.completeCancelled();
        }
        Object object = this.historyLock;
        synchronized (object) {
            if (response.hasToolCalls()) {
                this.conversationHistory.add(LlmMessage.assistantWithToolCalls(response.getContent(), response.getToolCalls()));
            } else {
                this.conversationHistory.add(LlmMessage.assistant(response.getContent()));
            }
        }
        if (response.isToolUse() && response.hasToolCalls()) {
            return this.executeToolCalls(response.getToolCalls(), config);
        }
        return this.completeSuccess(response.getContent());
    }

    private CompletableFuture<AgentResult> executeToolCalls(List<ToolCall> toolCalls, AgentConfig config) {
        this.state.set(AgentState.WAITING_TOOL);
        String sessionId = String.valueOf(System.identityHashCode(this));
        ToolLogger.getInstance().setAgentContext(sessionId, this.currentStep.get());
        CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
        for (ToolCall call : toolCalls) {
            chain = chain.thenCompose(v -> {
                if (this.cancelRequested.get()) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.executeSingleToolCall(call, config);
            });
        }
        return chain.thenCompose(v -> {
            if (this.cancelRequested.get()) {
                return this.completeCancelled();
            }
            return this.executeLoop(config);
        });
    }

    private CompletableFuture<Void> executeSingleToolCall(ToolCall call, AgentConfig config) {
        String toolName = call.getName();
        ITool tool = this.toolRegistry.getTool(toolName);
        int step = this.currentStep.get();
        if (tool == null) {
            ToolResult errorResult = ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442: " + toolName);
            this.addToolResult(call.getId(), errorResult);
            this.emit(new ToolResultEvent(step, toolName, call.getId(), errorResult, 0L));
            return CompletableFuture.completedFuture(null);
        }
        if (!config.isToolAllowed(toolName)) {
            ToolResult disabledResult = ToolResult.failure("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d: " + toolName);
            this.addToolResult(call.getId(), disabledResult);
            this.emit(new ToolResultEvent(step, toolName, call.getId(), disabledResult, 0L));
            return CompletableFuture.completedFuture(null);
        }
        Map<String, Object> args = this.parseArguments(call.getArguments());
        this.emit(new ToolCallEvent(step, call, args, tool.requiresConfirmation()));
        if (tool.requiresConfirmation()) {
            return this.requestConfirmation(call, tool, args, config);
        }
        return this.executeToolAndAddResult(call, args);
    }

    private CompletableFuture<Void> requestConfirmation(ToolCall call, ITool tool, Map<String, Object> args, AgentConfig config) {
        this.state.set(AgentState.WAITING_CONFIRMATION);
        int step = this.currentStep.get();
        ConfirmationRequiredEvent event = new ConfirmationRequiredEvent(step, call, tool.getDescription(), args, tool.isDestructive());
        this.pendingConfirmation.set(event);
        this.emit(event);
        return ((CompletableFuture)event.getResultFuture().thenCompose(result -> {
            this.pendingConfirmation.set(null);
            this.state.set(AgentState.RUNNING);
            switch (result) {
                case CONFIRMED: {
                    return this.executeToolAndAddResult(call, args);
                }
                case SKIPPED: {
                    ToolResult toolResult = ToolResult.success("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c", ToolResult.ToolResultType.CONFIRMATION);
                    this.addToolResult(call.getId(), toolResult);
                    this.emit(new ToolResultEvent(step, call.getName(), call.getId(), toolResult, 0L));
                    return CompletableFuture.completedFuture(null);
                }
            }
            ToolResult toolResult = ToolResult.failure("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
            this.addToolResult(call.getId(), toolResult);
            this.emit(new ToolResultEvent(step, call.getName(), call.getId(), toolResult, 0L));
            return CompletableFuture.completedFuture(null);
        })).exceptionally(error -> {
            this.pendingConfirmation.set(null);
            if (error instanceof CancellationException || error.getCause() instanceof CancellationException) {
                ToolResult cancelResult = ToolResult.failure("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430");
                this.addToolResult(call.getId(), cancelResult);
                this.emit(new ToolResultEvent(step, call.getName(), call.getId(), cancelResult, 0L));
            }
            return null;
        });
    }

    private CompletableFuture<Void> executeToolAndAddResult(ToolCall call, Map<String, Object> args) {
        long toolStartTime = System.currentTimeMillis();
        int step = this.currentStep.get();
        return this.toolRegistry.execute(call).handle((result, error) -> {
            long executionTime = System.currentTimeMillis() - toolStartTime;
            this.toolCallsCount.incrementAndGet();
            ToolResult toolResult = error != null ? ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + error.getMessage()) : result;
            this.addToolResult(call.getId(), toolResult);
            this.emit(new ToolResultEvent(step, call.getName(), call.getId(), toolResult, executionTime));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToolResult(String callId, ToolResult result) {
        Object content = result.isSuccess() ? result.getContent() : "\u041e\u0448\u0438\u0431\u043a\u0430: " + result.getErrorMessage();
        Object object = this.historyLock;
        synchronized (object) {
            this.conversationHistory.add(LlmMessage.toolResult(callId, (String)content));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LlmRequest buildRequest(AgentConfig config) {
        ArrayList<LlmMessage> messagesCopy;
        ArrayList<ToolDefinition> tools = new ArrayList<ToolDefinition>();
        for (ITool tool : this.toolRegistry.getAllTools()) {
            if (!config.isToolAllowed(tool.getName())) continue;
            tools.add(ToolDefinition.builder().name(tool.getName()).description(tool.getDescription()).parametersSchema(tool.getParameterSchema()).build());
        }
        Object object = this.historyLock;
        synchronized (object) {
            messagesCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        return LlmRequest.builder().messages(messagesCopy).tools(tools).toolChoice(LlmRequest.ToolChoice.AUTO).stream(config.isStreamingEnabled()).build();
    }

    private String buildSystemPrompt(AgentConfig config) {
        StringBuilder sb = new StringBuilder();
        if (!this.systemPrompt.isEmpty()) {
            sb.append(this.systemPrompt);
        }
        if (config.getSystemPromptAddition() != null) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(config.getSystemPromptAddition());
        }
        return sb.toString();
    }

    private Map<String, Object> parseArguments(String json) {
        if (json == null || json.isEmpty() || "{}".equals(json)) {
            return new HashMap<String, Object>();
        }
        try {
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map result = (Map)gson.fromJson(json, mapType);
            return result != null ? result : new HashMap();
        }
        catch (Exception e) {
            this.logWarning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430: " + json, e);
            return new HashMap<String, Object>();
        }
    }

    private boolean isSystemMessage(LlmMessage message) {
        return message != null && message.getRole() == LlmMessage.Role.SYSTEM;
    }

    private Throwable unwrapException(Throwable error) {
        if (error instanceof CompletionException && error.getCause() != null) {
            return error.getCause();
        }
        return error;
    }

    private CompletableFuture<AgentResult> completeSuccess(String response) {
        return CompletableFuture.completedFuture(this.createSuccessResult(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentResult createSuccessResult(String response) {
        ArrayList<LlmMessage> historyCopy;
        long executionTime = System.currentTimeMillis() - this.startTimeMs.get();
        Object object = this.historyLock;
        synchronized (object) {
            historyCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        AgentResult result = AgentResult.success(response, historyCopy, this.currentStep.get(), this.toolCallsCount.get(), executionTime);
        this.state.set(AgentState.COMPLETED);
        return result;
    }

    private CompletableFuture<AgentResult> completeCancelled() {
        return CompletableFuture.completedFuture(this.createCancelledResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentResult createCancelledResult() {
        ArrayList<LlmMessage> historyCopy;
        long executionTime = System.currentTimeMillis() - this.startTimeMs.get();
        Object object = this.historyLock;
        synchronized (object) {
            historyCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        AgentResult result = AgentResult.cancelled(historyCopy, this.currentStep.get(), executionTime);
        this.state.set(AgentState.CANCELLED);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentResult createErrorResult(Throwable error) {
        ArrayList<LlmMessage> historyCopy;
        long executionTime = System.currentTimeMillis() - this.startTimeMs.get();
        Object object = this.historyLock;
        synchronized (object) {
            historyCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        return AgentResult.error(error, historyCopy, this.currentStep.get(), executionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<AgentResult> completeMaxStepsReached(AgentConfig config) {
        ArrayList<LlmMessage> historyCopy;
        long executionTime = System.currentTimeMillis() - this.startTimeMs.get();
        Object object = this.historyLock;
        synchronized (object) {
            historyCopy = new ArrayList<LlmMessage>(this.conversationHistory);
        }
        AgentResult result = AgentResult.builder().finalState(AgentState.COMPLETED).errorMessage("\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0448\u0430\u0433\u043e\u0432: " + config.getMaxSteps()).conversationHistory(historyCopy).stepsExecuted(this.currentStep.get()).toolCallsExecuted(this.toolCallsCount.get()).executionTimeMs(executionTime).build();
        this.state.set(AgentState.COMPLETED);
        return CompletableFuture.completedFuture(result);
    }

    private void logError(String message, Throwable error) {
        LOG.log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }

    private void logWarning(String message, Throwable error) {
        LOG.log((IStatus)new Status(2, PLUGIN_ID, message, error));
    }

    @Override
    public void cancel() {
        ConfirmationRequiredEvent confirmation;
        this.cancelRequested.set(true);
        this.state.set(AgentState.CANCELLED);
        try {
            this.provider.cancel();
        }
        catch (Exception e) {
            this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043c\u0435\u043d\u0435 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430", e);
        }
        CompletableFuture streamFuture = this.currentStreamingFuture.getAndSet(null);
        if (streamFuture != null && !streamFuture.isDone()) {
            streamFuture.completeExceptionally(new CancellationException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"));
        }
        if ((confirmation = (ConfirmationRequiredEvent)this.pendingConfirmation.getAndSet(null)) != null) {
            confirmation.getResultFuture().completeExceptionally(new CancellationException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"));
        }
    }

    @Override
    public AgentState getState() {
        return this.state.get();
    }

    @Override
    public int getCurrentStep() {
        return this.currentStep.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LlmMessage> getConversationHistory() {
        Object object = this.historyLock;
        synchronized (object) {
            return new ArrayList<LlmMessage>(this.conversationHistory);
        }
    }

    @Override
    public void addListener(IAgentEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IAgentEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.cancel();
        this.listeners.clear();
        Object object = this.historyLock;
        synchronized (object) {
            this.conversationHistory.clear();
        }
    }

    private void emit(AgentEvent event) {
        for (IAgentEventListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                this.logWarning("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f: " + String.valueOf((Object)event.getType()), e);
            }
        }
    }
}

