/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import java.time.Instant;
import java.util.Objects;

public abstract class AgentEvent {
    private final Instant timestamp = Instant.now();
    private final AgentState state;
    private final int step;

    protected AgentEvent(AgentState state, int step) {
        this.state = Objects.requireNonNull(state);
        this.step = step;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public AgentState getState() {
        return this.state;
    }

    public int getStep() {
        return this.step;
    }

    public abstract EventType getType();

    public static enum EventType {
        STARTED,
        STEP,
        TOOL_CALL,
        TOOL_RESULT,
        STREAM_CHUNK,
        CONFIRMATION_REQUIRED,
        COMPLETED;

    }
}

