/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentEvent;

public class AgentStepEvent
extends AgentEvent {
    private final int maxSteps;
    private final String description;

    public AgentStepEvent(int step, int maxSteps, String description) {
        super(AgentState.RUNNING, step);
        this.maxSteps = maxSteps;
        this.description = description;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public String getDescription() {
        return this.description;
    }

    public double getProgress() {
        return (double)this.getStep() / (double)this.maxSteps;
    }

    @Override
    public AgentEvent.EventType getType() {
        return AgentEvent.EventType.STEP;
    }

    public String toString() {
        return "AgentStepEvent{step=" + this.getStep() + "/" + this.maxSteps + ", desc='" + this.description + "'}";
    }
}

