/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentEvent;
import com.example.vibe.core.model.ToolCall;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ConfirmationRequiredEvent
extends AgentEvent {
    private final ToolCall toolCall;
    private final String toolDescription;
    private final Map<String, Object> arguments;
    private final boolean isDestructive;
    private final CompletableFuture<ConfirmationResult> resultFuture;

    public ConfirmationRequiredEvent(int step, ToolCall toolCall, String toolDescription, Map<String, Object> arguments, boolean isDestructive) {
        super(AgentState.WAITING_CONFIRMATION, step);
        this.toolCall = toolCall;
        this.toolDescription = toolDescription;
        this.arguments = arguments;
        this.isDestructive = isDestructive;
        this.resultFuture = new CompletableFuture();
    }

    public ToolCall getToolCall() {
        return this.toolCall;
    }

    public String getToolName() {
        return this.toolCall.getName();
    }

    public String getToolDescription() {
        return this.toolDescription;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public boolean isDestructive() {
        return this.isDestructive;
    }

    public void confirm() {
        this.resultFuture.complete(ConfirmationResult.CONFIRMED);
    }

    public void deny() {
        this.resultFuture.complete(ConfirmationResult.DENIED);
    }

    public void skip() {
        this.resultFuture.complete(ConfirmationResult.SKIPPED);
    }

    public CompletableFuture<ConfirmationResult> getResultFuture() {
        return this.resultFuture;
    }

    @Override
    public AgentEvent.EventType getType() {
        return AgentEvent.EventType.CONFIRMATION_REQUIRED;
    }

    public String toString() {
        return "ConfirmationRequiredEvent{tool='" + this.getToolName() + "', destructive=" + this.isDestructive + "}";
    }

    public static enum ConfirmationResult {
        CONFIRMED,
        DENIED,
        SKIPPED;

    }
}

