/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentEvent;

public class StreamChunkEvent
extends AgentEvent {
    private final String content;
    private final boolean isComplete;
    private final String finishReason;

    public StreamChunkEvent(int step, String content, boolean isComplete, String finishReason) {
        super(AgentState.RUNNING, step);
        this.content = content;
        this.isComplete = isComplete;
        this.finishReason = finishReason;
    }

    public static StreamChunkEvent partial(int step, String content) {
        return new StreamChunkEvent(step, content, false, null);
    }

    public static StreamChunkEvent complete(int step, String finishReason) {
        return new StreamChunkEvent(step, "", true, finishReason);
    }

    public String getContent() {
        return this.content;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public String getFinishReason() {
        return this.finishReason;
    }

    public boolean hasToolCalls() {
        return "tool_use".equals(this.finishReason) || "tool_calls".equals(this.finishReason);
    }

    @Override
    public AgentEvent.EventType getType() {
        return AgentEvent.EventType.STREAM_CHUNK;
    }

    public String toString() {
        if (this.isComplete) {
            return "StreamChunkEvent{complete, reason='" + this.finishReason + "'}";
        }
        return "StreamChunkEvent{content='" + this.content.substring(0, Math.min(30, this.content.length())) + "...'}";
    }
}

