/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentEvent;
import com.example.vibe.core.model.ToolCall;
import java.util.Map;

public class ToolCallEvent
extends AgentEvent {
    private final ToolCall toolCall;
    private final Map<String, Object> parsedArguments;
    private final boolean requiresConfirmation;

    public ToolCallEvent(int step, ToolCall toolCall, Map<String, Object> parsedArguments, boolean requiresConfirmation) {
        super(AgentState.WAITING_TOOL, step);
        this.toolCall = toolCall;
        this.parsedArguments = parsedArguments;
        this.requiresConfirmation = requiresConfirmation;
    }

    public ToolCall getToolCall() {
        return this.toolCall;
    }

    public String getToolName() {
        return this.toolCall.getName();
    }

    public String getCallId() {
        return this.toolCall.getId();
    }

    public Map<String, Object> getParsedArguments() {
        return this.parsedArguments;
    }

    public boolean isRequiresConfirmation() {
        return this.requiresConfirmation;
    }

    @Override
    public AgentEvent.EventType getType() {
        return AgentEvent.EventType.TOOL_CALL;
    }

    public String toString() {
        return "ToolCallEvent{tool='" + this.getToolName() + "', confirmation=" + this.requiresConfirmation + "}";
    }
}

