/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.events;

import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentEvent;
import com.example.vibe.core.tools.ToolResult;

public class ToolResultEvent
extends AgentEvent {
    private final String toolName;
    private final String callId;
    private final ToolResult result;
    private final long executionTimeMs;

    public ToolResultEvent(int step, String toolName, String callId, ToolResult result, long executionTimeMs) {
        super(AgentState.RUNNING, step);
        this.toolName = toolName;
        this.callId = callId;
        this.result = result;
        this.executionTimeMs = executionTimeMs;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getCallId() {
        return this.callId;
    }

    public ToolResult getResult() {
        return this.result;
    }

    public boolean isSuccess() {
        return this.result.isSuccess();
    }

    public long getExecutionTimeMs() {
        return this.executionTimeMs;
    }

    @Override
    public AgentEvent.EventType getType() {
        return AgentEvent.EventType.TOOL_RESULT;
    }

    public String toString() {
        return "ToolResultEvent{tool='" + this.toolName + "', success=" + this.isSuccess() + ", timeMs=" + this.executionTimeMs + "}";
    }
}

