/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.context7;

import com.example.vibe.core.context7.QueryClassifier;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolRegistry;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Context7DocumentationService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(Context7DocumentationService.class);
    private static Context7DocumentationService instance;
    public static final String LIBRARY_1C_DN = "/websites/1c-dn_library";
    public static final String LIBRARY_BSL_LSP = "/1c-syntax/bsl-language-server";
    public static final String LIBRARY_SSL = "/1c-syntax/ssl_3_1";
    public static final List<LibraryInfo> ALL_LIBRARIES;
    private static final String TOOL_QUERY_DOCS = "mcp_context_7_query-docs";
    private static final int TOKENS_PER_LIBRARY = 3000;
    private static final int MAX_PARALLEL_LIBRARIES = 2;
    private static final long CACHE_TTL_MS = 600000L;
    private static final int MAX_CACHE_SIZE = 100;
    private final Map<String, CacheEntry> documentationCache = new ConcurrentHashMap<String, CacheEntry>();
    private volatile boolean initialized = false;
    private final QueryClassifier queryClassifier = QueryClassifier.getInstance();
    private static final int CLASSIFICATION_TIMEOUT_SECONDS = 20;

    static {
        ALL_LIBRARIES = List.of(new LibraryInfo(LIBRARY_1C_DN, "1C-DN", "\u0411\u0430\u0437\u0430 \u0437\u043d\u0430\u043d\u0438\u0439 1\u0421:\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435"), new LibraryInfo(LIBRARY_BSL_LSP, "BSL-LSP", "\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 BSL"), new LibraryInfo(LIBRARY_SSL, "\u0411\u0421\u041f 3.1", "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0445 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c"));
    }

    private Context7DocumentationService() {
    }

    public static synchronized Context7DocumentationService getInstance() {
        if (instance == null) {
            instance = new Context7DocumentationService();
        }
        return instance;
    }

    public CompletableFuture<Void> initialize() {
        if (this.initialized) {
            LOG.debug("Context7DocumentationService already initialized");
            return CompletableFuture.completedFuture(null);
        }
        LOG.info("Context7DocumentationService initialized (on-demand mode)");
        this.initialized = true;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setLlmProvider(ILlmProvider provider) {
        this.queryClassifier.setLlmProvider(provider);
        LOG.info("Context7DocumentationService: LLM provider configured for query classification");
    }

    public CompletableFuture<String> enrichWithDocumentation(String userMessage) {
        if (userMessage == null || userMessage.trim().isEmpty()) {
            return CompletableFuture.completedFuture("");
        }
        String cacheKey = this.buildCacheKey(userMessage);
        CacheEntry cached = this.documentationCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            LOG.debug("Documentation found in cache (age: %d sec)", Duration.between(cached.createdAt, Instant.now()).toSeconds());
            return CompletableFuture.completedFuture(cached.content);
        }
        return ((CompletableFuture)this.queryClassifier.classify(userMessage).orTimeout(20L, TimeUnit.SECONDS).thenCompose(category -> {
            if (category == null) {
                LOG.debug("Query classified as NONE (no documentation needed): %s", this.truncateMessage(userMessage, 50));
                return CompletableFuture.completedFuture("");
            }
            LOG.info("Query category: %s for: %s", category, this.truncateMessage(userMessage, 50));
            List<LibraryInfo> libraries = this.selectLibraries((QueryCategory)((Object)category));
            LOG.debug("Selected %d libraries: %s", libraries.size(), libraries.stream().map(l -> l.shortName).toList());
            String topic = this.extractTopic(userMessage);
            LOG.debug("Extracted topic: %s", topic);
            String query = this.buildQuery(userMessage);
            List<CompletableFuture> futures = libraries.stream().map(lib -> this.queryLibrary((LibraryInfo)lib, query, topic)).toList();
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> this.combineResults(futures, libraries.size(), cacheKey));
        })).exceptionally(e -> {
            LOG.warn("Documentation enrichment failed: %s", e.getMessage());
            return "";
        });
    }

    private String combineResults(List<CompletableFuture<LibraryResult>> futures, int totalLibraries, String cacheKey) {
        StringBuilder result = new StringBuilder();
        int successCount = 0;
        for (CompletableFuture<LibraryResult> future : futures) {
            try {
                LibraryResult libResult = future.join();
                if (libResult == null || libResult.content == null || libResult.content.isEmpty()) continue;
                if (result.length() > 0) {
                    result.append("\n\n");
                }
                result.append("### ").append(libResult.libraryName).append("\n\n");
                result.append(libResult.content);
                ++successCount;
            }
            catch (Exception e) {
                LOG.debug("Failed to get library result: %s", e.getMessage());
            }
        }
        if (result.length() > 0) {
            String formatted = this.formatDocumentation(result.toString());
            this.putInCache(cacheKey, formatted);
            LOG.info("Documentation enrichment complete: %d chars from %d/%d libraries", formatted.length(), successCount, totalLibraries);
            return formatted;
        }
        LOG.debug("No documentation found for query");
        return "";
    }

    private String truncateMessage(String message, int maxLen) {
        if (message == null) {
            return "null";
        }
        return message.length() > maxLen ? message.substring(0, maxLen) + "..." : message;
    }

    public CompletableFuture<String> getDocumentationContext(String userMessage, boolean includeBase) {
        return this.enrichWithDocumentation(userMessage);
    }

    public QueryCategory classifyQuery(String userMessage) {
        try {
            QueryCategory result = this.queryClassifier.classify(userMessage).orTimeout(20L, TimeUnit.SECONDS).join();
            return result != null ? result : QueryCategory.GENERAL;
        }
        catch (Exception e) {
            LOG.warn("Sync classification failed, using GENERAL: %s", e.getMessage());
            return QueryCategory.GENERAL;
        }
    }

    public CompletableFuture<QueryCategory> classifyQueryAsync(String userMessage) {
        return this.queryClassifier.classify(userMessage).orTimeout(20L, TimeUnit.SECONDS);
    }

    public List<LibraryInfo> selectLibraries(QueryCategory category) {
        return switch (category) {
            case QueryCategory.SYNTAX -> List.of(ALL_LIBRARIES.get(0));
            case QueryCategory.DIAGNOSTICS -> List.of(ALL_LIBRARIES.get(1));
            case QueryCategory.SUBSYSTEMS -> List.of(ALL_LIBRARIES.get(2));
            case QueryCategory.GENERAL -> List.of(ALL_LIBRARIES.get(0), ALL_LIBRARIES.get(2));
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private String extractTopic(String userMessage) {
        List<Pattern> topicPatterns = List.of(Pattern.compile("(?iu)(\u043c\u0430\u0441\u0441\u0438\u0432|array)"), Pattern.compile("(?iu)(\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440[\u0430\u0443\u0435]|structure)"), Pattern.compile("(?iu)(\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438[\u0435\u044e]|map)"), Pattern.compile("(?iu)(\u0442\u0430\u0431\u043b\u0438\u0446.*\u0437\u043d\u0430\u0447\u0435\u043d|value.*table)"), Pattern.compile("(?iu)(\u0441\u0442\u0440\u043e\u043a[\u0430\u0443\u0435]|string)"), Pattern.compile("(?iu)(\u0447\u0438\u0441\u043b[\u043e\u0430]|number)"), Pattern.compile("(?iu)(\u0434\u0430\u0442[\u0430\u0443\u0435]|date)"), Pattern.compile("(?iu)(\u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a|catalog)"), Pattern.compile("(?iu)(\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442|document)"), Pattern.compile("(?iu)(\u0440\u0435\u0433\u0438\u0441\u0442\u0440.*\u0441\u0432\u0435\u0434\u0435\u043d|information.*register)"), Pattern.compile("(?iu)(\u0440\u0435\u0433\u0438\u0441\u0442\u0440.*\u043d\u0430\u043a\u043e\u043f\u043b\u0435\u043d|accumulation.*register)"), Pattern.compile("(?iu)(\u0437\u0430\u043f\u0440\u043e\u0441|query)"), Pattern.compile("(?iu)(\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438|transaction)"), Pattern.compile("(?iu)(\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a|lock)"), Pattern.compile("(?iu)(\u0441\u043e\u0431\u044b\u0442\u0438[\u044f\u0435]|event)"), Pattern.compile("(?iu)(\u0444\u043e\u0440\u043c[\u0430\u0443\u0435]|form)"));
        for (Pattern pattern : topicPatterns) {
            Matcher matcher = pattern.matcher(userMessage);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private String buildQuery(String userMessage) {
        String cleaned = userMessage.replaceAll("(?iu)(\u043a\u0430\u043a|\u043a\u0430\u043a \u0431\u044b|\u043c\u043e\u0436\u043d\u043e|\u043d\u0443\u0436\u043d\u043e|\u0445\u043e\u0447\u0443|\u043f\u043e\u043c\u043e\u0433\u0438|\u043f\u043e\u0434\u0441\u043a\u0430\u0436\u0438|\u043e\u0431\u044a\u044f\u0441\u043d\u0438|\u0440\u0430\u0441\u0441\u043a\u0430\u0436\u0438)", "").replaceAll("(?iu)(\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c|\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c|\u0441\u0434\u0435\u043b\u0430\u0442\u044c|\u0441\u043e\u0437\u0434\u0430\u0442\u044c|\u043d\u0430\u043f\u0438\u0441\u0430\u0442\u044c)", "").replaceAll("(?iu)(\u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430|please)", "").replaceAll("\\s+", " ").trim();
        return "1\u0421 BSL " + cleaned;
    }

    private String buildCacheKey(String userMessage) {
        return userMessage.toLowerCase().replaceAll("\\s+", " ").trim();
    }

    private CompletableFuture<LibraryResult> queryLibrary(LibraryInfo library, String query, String topic) {
        ToolRegistry registry = ToolRegistry.getInstance();
        ITool tool = registry.getTool(TOOL_QUERY_DOCS);
        if (tool == null) {
            LOG.warn("Context7 tool not found: %s. Is Context7 MCP server running?", TOOL_QUERY_DOCS);
            return CompletableFuture.completedFuture(null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("libraryId", library.id);
        params.put("query", query);
        params.put("tokens", 3000);
        if (topic != null && !topic.isEmpty()) {
            params.put("topic", topic);
        }
        LOG.debug("Querying Context7: library=%s, query=%s, topic=%s, tokens=%d", library.shortName, query, topic, 3000);
        return ((CompletableFuture)tool.execute(params).thenApply(result -> {
            if (result.isSuccess() && result.getContent() != null && !result.getContent().isEmpty()) {
                LOG.debug("Context7 [%s] returned %d chars", libraryInfo.shortName, result.getContent().length());
                return new LibraryResult(libraryInfo.description, result.getContent());
            }
            LOG.debug("Context7 [%s] returned empty or failed: %s", libraryInfo.shortName, result.getErrorMessage());
            return null;
        })).exceptionally(e -> {
            LOG.warn("Context7 [%s] query exception: %s", libraryInfo.shortName, e.getMessage());
            return null;
        });
    }

    private String formatDocumentation(String rawDoc) {
        return "\n---\n## \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u0438 1\u0421\n\n" + rawDoc + "\n---\n";
    }

    private void putInCache(String key, String value) {
        if (this.documentationCache.size() >= 100) {
            this.cleanExpiredCache();
        }
        this.documentationCache.put(key, new CacheEntry(value));
    }

    private void cleanExpiredCache() {
        int removed = 0;
        for (Map.Entry<String, CacheEntry> entry : this.documentationCache.entrySet()) {
            if (!entry.getValue().isExpired() || !this.documentationCache.remove(entry.getKey(), entry.getValue())) continue;
            ++removed;
        }
        if (removed > 0) {
            LOG.debug("Cleaned %d expired cache entries", removed);
        }
    }

    public void clearCache() {
        this.documentationCache.clear();
        LOG.info("Documentation cache cleared");
    }

    public void reset() {
        this.documentationCache.clear();
        this.initialized = false;
        LOG.info("Context7DocumentationService reset");
    }

    @Deprecated
    public String getBaseDocumentation() {
        return "";
    }

    private static class CacheEntry {
        final String content;
        final Instant createdAt;

        CacheEntry(String content) {
            this.content = content;
            this.createdAt = Instant.now();
        }

        boolean isExpired() {
            return Duration.between(this.createdAt, Instant.now()).toMillis() > 600000L;
        }
    }

    public static class LibraryInfo {
        public final String id;
        public final String shortName;
        public final String description;

        public LibraryInfo(String id, String shortName, String description) {
            this.id = id;
            this.shortName = shortName;
            this.description = description;
        }
    }

    private static class LibraryResult {
        final String libraryName;
        final String content;

        LibraryResult(String libraryName, String content) {
            this.libraryName = libraryName;
            this.content = content;
        }
    }

    public static enum QueryCategory {
        SYNTAX,
        DIAGNOSTICS,
        SUBSYSTEMS,
        GENERAL;

    }
}

