/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.context7;

import com.example.vibe.core.context7.Context7DocumentationService;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.model.LlmRequest;
import com.example.vibe.core.model.LlmResponse;
import com.example.vibe.core.provider.ILlmProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class QueryClassifier {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(QueryClassifier.class);
    private static volatile QueryClassifier instance;
    private static final String CLASSIFICATION_PROMPT = "\u041a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043b\u044f 1\u0421:\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435.\n\u041e\u0442\u0432\u0435\u0442\u044c \u0422\u041e\u041b\u042c\u041a\u041e \u041e\u0414\u041d\u0418\u041c \u0441\u043b\u043e\u0432\u043e\u043c \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430:\n\n- SYNTAX - \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0435 BSL, \u0442\u0438\u043f\u0430\u0445 \u0434\u0430\u043d\u043d\u044b\u0445, \u0444\u0443\u043d\u043a\u0446\u0438\u044f\u0445, \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430\u0445, \u043f\u0440\u0438\u043c\u0435\u0440\u0430\u0445 \u043a\u043e\u0434\u0430\n- DIAGNOSTICS - \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430\u0445, \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043a\u043e\u0434\u0430, \u043b\u0438\u043d\u0442\u0438\u043d\u0433\u0435, \u0430\u043d\u0430\u043b\u0438\u0437\u0435, \u043e\u0448\u0438\u0431\u043a\u0430\u0445 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438\n- SUBSYSTEMS - \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e \u0411\u0421\u041f (\u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0445 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c), \u043e\u0431\u0449\u0438\u0445 \u043c\u043e\u0434\u0443\u043b\u044f\u0445, \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438\n- GENERAL - \u043e\u0431\u0449\u0438\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e 1\u0421, \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445, \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430\u0445, \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0445, \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0445\n- NONE - \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u0446\u0438\u0438 (\u043f\u0440\u0438\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435, \u0431\u043b\u0430\u0433\u043e\u0434\u0430\u0440\u043d\u043e\u0441\u0442\u044c, \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043d\u0435 \u043e 1\u0421)\n\n\u0417\u0430\u043f\u0440\u043e\u0441: %s\n\n\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:";
    private final Map<String, CacheEntry> classificationCache = new ConcurrentHashMap<String, CacheEntry>();
    private static final long CACHE_TTL_MS = 1800000L;
    private static final int MAX_CACHE_SIZE = 200;
    private static final int CLASSIFICATION_TIMEOUT_SECONDS = 20;
    private volatile boolean warmedUp = false;
    private ILlmProvider llmProvider;

    private QueryClassifier() {
    }

    public static synchronized QueryClassifier getInstance() {
        if (instance == null) {
            instance = new QueryClassifier();
        }
        return instance;
    }

    public static synchronized void dispose() {
        if (instance != null) {
            QueryClassifier.instance.llmProvider = null;
            QueryClassifier.instance.classificationCache.clear();
            QueryClassifier.instance.warmedUp = false;
            LOG.info("QueryClassifier disposed");
            instance = null;
        }
    }

    public void setLlmProvider(ILlmProvider provider) {
        this.llmProvider = provider;
        LOG.info("QueryClassifier: LLM provider set to %s", provider != null ? provider.getClass().getSimpleName() : "null");
        if (provider != null && !this.warmedUp) {
            this.warmup();
        }
    }

    private void warmup() {
        if (this.llmProvider == null || this.warmedUp) {
            return;
        }
        LOG.info("QueryClassifier: starting warmup...");
        CompletableFuture.runAsync(() -> {
            try {
                String warmupQuery = "\u041f\u0440\u0438\u0432\u0435\u0442";
                LlmMessage systemMessage = LlmMessage.system("\u041e\u0442\u0432\u0435\u0442\u044c \u043e\u0434\u043d\u0438\u043c \u0441\u043b\u043e\u0432\u043e\u043c: NONE");
                LlmMessage userMessage = LlmMessage.user(warmupQuery);
                LlmRequest request = LlmRequest.builder().messages(List.of(systemMessage, userMessage)).maxTokens(5).temperature(0.0).build();
                ((CompletableFuture)this.llmProvider.complete(request).orTimeout(15L, TimeUnit.SECONDS).thenAccept(response -> {
                    this.warmedUp = true;
                    LOG.info("QueryClassifier: warmup completed successfully");
                })).exceptionally(e -> {
                    this.warmedUp = true;
                    LOG.warn("QueryClassifier: warmup failed: %s", e.getMessage());
                    return null;
                });
            }
            catch (Exception e2) {
                this.warmedUp = true;
                LOG.warn("QueryClassifier: warmup exception: %s", e2.getMessage());
            }
        });
    }

    public CompletableFuture<Context7DocumentationService.QueryCategory> classify(String userQuery) {
        if (userQuery == null || userQuery.trim().isEmpty()) {
            return CompletableFuture.completedFuture(Context7DocumentationService.QueryCategory.GENERAL);
        }
        String cacheKey = this.normalizeForCache(userQuery);
        CacheEntry cached = this.classificationCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            LOG.debug("Classification cache hit: %s -> %s", new Object[]{this.truncate(userQuery, 50), cached.category});
            return CompletableFuture.completedFuture(cached.category);
        }
        if (this.llmProvider == null) {
            LOG.warn("No LLM provider available for classification, using GENERAL");
            return CompletableFuture.completedFuture(Context7DocumentationService.QueryCategory.GENERAL);
        }
        LOG.debug("Classifying query with LLM: %s", this.truncate(userQuery, 50));
        String prompt = String.format(CLASSIFICATION_PROMPT, userQuery);
        LlmMessage systemMessage = LlmMessage.system("\u0422\u044b \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432. \u041e\u0442\u0432\u0435\u0447\u0430\u0439 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u043d\u0438\u043c \u0441\u043b\u043e\u0432\u043e\u043c: SYNTAX, DIAGNOSTICS, SUBSYSTEMS, GENERAL \u0438\u043b\u0438 NONE.");
        LlmMessage userMessage = LlmMessage.user(prompt);
        LlmRequest request = LlmRequest.builder().messages(List.of(systemMessage, userMessage)).maxTokens(10).temperature(0.0).build();
        return ((CompletableFuture)this.llmProvider.complete(request).orTimeout(20L, TimeUnit.SECONDS).thenApply(response -> {
            Context7DocumentationService.QueryCategory category = this.parseCategory((LlmResponse)response);
            this.putInCache(cacheKey, category);
            LOG.info("Query classified: '%s' -> %s", new Object[]{this.truncate(userQuery, 50), category});
            return category;
        })).exceptionally(e -> {
            LOG.warn("Classification failed, using GENERAL: %s", e.getMessage());
            return Context7DocumentationService.QueryCategory.GENERAL;
        });
    }

    private Context7DocumentationService.QueryCategory parseCategory(LlmResponse response) {
        if (response == null || response.getContent() == null) {
            return Context7DocumentationService.QueryCategory.GENERAL;
        }
        String content = response.getContent().trim().toUpperCase();
        if (content.contains("NONE")) {
            return null;
        }
        if (content.contains("SYNTAX")) {
            return Context7DocumentationService.QueryCategory.SYNTAX;
        }
        if (content.contains("DIAGNOSTICS")) {
            return Context7DocumentationService.QueryCategory.DIAGNOSTICS;
        }
        if (content.contains("SUBSYSTEMS")) {
            return Context7DocumentationService.QueryCategory.SUBSYSTEMS;
        }
        if (content.contains("GENERAL")) {
            return Context7DocumentationService.QueryCategory.GENERAL;
        }
        LOG.debug("Could not parse category from: %s, using GENERAL", content);
        return Context7DocumentationService.QueryCategory.GENERAL;
    }

    private String normalizeForCache(String query) {
        return query.toLowerCase().replaceAll("[?!.,;:]+", "").replaceAll("\\s+", " ").trim();
    }

    private void putInCache(String key, Context7DocumentationService.QueryCategory category) {
        if (category == null) {
            return;
        }
        if (this.classificationCache.size() >= 200) {
            this.cleanExpiredCache();
        }
        this.classificationCache.put(key, new CacheEntry(category));
    }

    private void cleanExpiredCache() {
        int removed = 0;
        for (Map.Entry<String, CacheEntry> entry : this.classificationCache.entrySet()) {
            if (!entry.getValue().isExpired() || !this.classificationCache.remove(entry.getKey(), entry.getValue())) continue;
            ++removed;
        }
        if (removed > 0) {
            LOG.debug("Cleaned %d expired classification cache entries", removed);
        }
    }

    public void clearCache() {
        this.classificationCache.clear();
        LOG.info("Classification cache cleared");
    }

    private String truncate(String s, int maxLen) {
        if (s == null) {
            return "null";
        }
        return s.length() > maxLen ? s.substring(0, maxLen) + "..." : s;
    }

    private static class CacheEntry {
        final Context7DocumentationService.QueryCategory category;
        final Instant createdAt;

        CacheEntry(Context7DocumentationService.QueryCategory category) {
            this.category = category;
            this.createdAt = Instant.now();
        }

        boolean isExpired() {
            return Duration.between(this.createdAt, Instant.now()).toMillis() > 1800000L;
        }
    }
}

