/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.diff;

public class CodeChange {
    private final ChangeType type;
    private final int offset;
    private final int length;
    private final String oldText;
    private final String newText;
    private final String description;

    private CodeChange(Builder builder) {
        this.type = builder.type;
        this.offset = builder.offset;
        this.length = builder.length;
        this.oldText = builder.oldText;
        this.newText = builder.newText;
        this.description = builder.description;
    }

    public ChangeType getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getOldText() {
        return this.oldText;
    }

    public String getNewText() {
        return this.newText;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEndOffset() {
        return this.offset + this.length;
    }

    public int getLengthDelta() {
        int oldLen = this.oldText != null ? this.oldText.length() : this.length;
        int newLen = this.newText != null ? this.newText.length() : 0;
        return newLen - oldLen;
    }

    public static Builder insert(int offset, String text) {
        return new Builder().type(ChangeType.INSERT).offset(offset).length(0).newText(text);
    }

    public static Builder replace(int offset, int length, String oldText, String newText) {
        return new Builder().type(ChangeType.REPLACE).offset(offset).length(length).oldText(oldText).newText(newText);
    }

    public static Builder delete(int offset, int length, String oldText) {
        return new Builder().type(ChangeType.DELETE).offset(offset).length(length).oldText(oldText).newText(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("CodeChange[%s at %d, len=%d, delta=%d]", new Object[]{this.type, this.offset, this.length, this.getLengthDelta()});
    }

    public static class Builder {
        private ChangeType type = ChangeType.REPLACE;
        private int offset;
        private int length;
        private String oldText;
        private String newText;
        private String description;

        public Builder type(ChangeType type) {
            this.type = type;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder oldText(String oldText) {
            this.oldText = oldText;
            return this;
        }

        public Builder newText(String newText) {
            this.newText = newText;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public CodeChange build() {
            return new CodeChange(this);
        }
    }

    public static enum ChangeType {
        INSERT,
        REPLACE,
        DELETE;

    }
}

