/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.diff;

import com.example.vibe.core.diff.CodeChange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CodeDiffUtils {
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("```(\\w*)\\s*\\n(.*?)\\n```", 32);
    private static final Pattern INLINE_CODE_PATTERN = Pattern.compile("`([^`]+)`");

    private CodeDiffUtils() {
    }

    public static List<CodeBlock> extractCodeBlocks(String response) {
        ArrayList<CodeBlock> blocks = new ArrayList<CodeBlock>();
        if (response == null || response.isEmpty()) {
            return blocks;
        }
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(response);
        while (matcher.find()) {
            String language = matcher.group(1);
            String code = matcher.group(2);
            blocks.add(new CodeBlock(language, code, matcher.start(), matcher.end()));
        }
        return blocks;
    }

    public static String extractFirstCodeBlock(String response) {
        List<CodeBlock> blocks = CodeDiffUtils.extractCodeBlocks(response);
        return blocks.isEmpty() ? null : blocks.get(0).getCode();
    }

    public static List<CodeBlock> extractCodeBlocksByLanguage(String response, String language) {
        List<CodeBlock> all = CodeDiffUtils.extractCodeBlocks(response);
        if (language == null || language.isEmpty()) {
            return all;
        }
        ArrayList<CodeBlock> filtered = new ArrayList<CodeBlock>();
        for (CodeBlock block : all) {
            if (!language.equalsIgnoreCase(block.getLanguage())) continue;
            filtered.add(block);
        }
        return filtered;
    }

    public static CodeChange createInsertionFromResponse(int offset, String aiResponse) {
        String code = CodeDiffUtils.extractFirstCodeBlock(aiResponse);
        if (code == null) {
            code = aiResponse.trim();
        }
        if (code.isEmpty()) {
            return null;
        }
        return CodeChange.insert(offset, code).description("AI-generated code insertion").build();
    }

    public static CodeChange createReplacementFromResponse(int offset, int length, String oldText, String aiResponse) {
        String newCode = CodeDiffUtils.extractFirstCodeBlock(aiResponse);
        if (newCode == null) {
            newCode = aiResponse.trim();
        }
        if (newCode.isEmpty()) {
            return null;
        }
        return CodeChange.replace(offset, length, oldText, newCode).description("AI-generated code replacement").build();
    }

    public static String stripMarkdown(String text) {
        if (text == null) {
            return "";
        }
        List<CodeBlock> blocks = CodeDiffUtils.extractCodeBlocks(text);
        if (!blocks.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (CodeBlock block : blocks) {
                if (sb.length() > 0) {
                    sb.append("\n\n");
                }
                sb.append(block.getCode());
            }
            return sb.toString();
        }
        String result = text;
        result = result.replaceAll("(?m)^#{1,6}\\s+", "");
        result = result.replaceAll("\\*\\*(.+?)\\*\\*", "$1");
        result = result.replaceAll("\\*(.+?)\\*", "$1");
        result = result.replaceAll("__(.+?)__", "$1");
        result = result.replaceAll("_(.+?)_", "$1");
        result = result.replaceAll("`([^`]+)`", "$1");
        result = result.replaceAll("\\[(.+?)\\]\\(.+?\\)", "$1");
        return result.trim();
    }

    public static List<CodeChange> calculateDiff(String oldText, String newText) {
        ArrayList<CodeChange> changes = new ArrayList<CodeChange>();
        if (oldText == null) {
            oldText = "";
        }
        if (newText == null) {
            newText = "";
        }
        if (oldText.equals(newText)) {
            return changes;
        }
        changes.add(CodeChange.replace(0, oldText.length(), oldText, newText).build());
        return changes;
    }

    public static int commonPrefixLength(String a, String b) {
        int minLen = Math.min(a.length(), b.length());
        int i = 0;
        while (i < minLen && a.charAt(i) == b.charAt(i)) {
            ++i;
        }
        return i;
    }

    public static int commonSuffixLength(String a, String b) {
        int minLen = Math.min(a.length(), b.length());
        int i = 0;
        while (i < minLen && a.charAt(a.length() - 1 - i) == b.charAt(b.length() - 1 - i)) {
            ++i;
        }
        return i;
    }

    public static class CodeBlock {
        private final String language;
        private final String code;
        private final int startIndex;
        private final int endIndex;

        public CodeBlock(String language, String code, int startIndex, int endIndex) {
            this.language = language != null ? language : "";
            this.code = code != null ? code : "";
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getCode() {
            return this.code;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public boolean hasLanguage() {
            return !this.language.isEmpty();
        }

        public boolean isBsl() {
            if ("bsl".equalsIgnoreCase(this.language) || "1c".equalsIgnoreCase(this.language)) {
                return true;
            }
            String lower = this.code.toLowerCase();
            return lower.contains("\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430") || lower.contains("\u0444\u0443\u043d\u043a\u0446\u0438\u044f") || lower.contains("procedure") || lower.contains("function") || lower.contains("\u043a\u043e\u043d\u0435\u0446\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b") || lower.contains("\u043a\u043e\u043d\u0435\u0446\u0444\u0443\u043d\u043a\u0446\u0438\u0438");
        }

        public String toString() {
            return String.format("CodeBlock[lang=%s, len=%d]", this.language, this.code.length());
        }
    }
}

