/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.diff;

import com.example.vibe.core.diff.CodeChange;
import java.util.List;

public interface ICodeApplicator {
    public ApplyResult apply(CodeChange var1);

    public ApplyResult applyAll(List<CodeChange> var1);

    public ApplyResult applyWithUndo(List<CodeChange> var1, String var2);

    public boolean canApply(CodeChange var1);

    public boolean supportsUndo();

    public String preview(List<CodeChange> var1);

    public static class ApplyResult {
        private final boolean success;
        private final String message;
        private final int changesApplied;
        private final int changesFailed;
        private final Exception error;

        private ApplyResult(boolean success, String message, int applied, int failed, Exception error) {
            this.success = success;
            this.message = message;
            this.changesApplied = applied;
            this.changesFailed = failed;
            this.error = error;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public int getChangesApplied() {
            return this.changesApplied;
        }

        public int getChangesFailed() {
            return this.changesFailed;
        }

        public Exception getError() {
            return this.error;
        }

        public static ApplyResult success(int applied) {
            return new ApplyResult(true, "Applied " + applied + " change(s)", applied, 0, null);
        }

        public static ApplyResult partial(int applied, int failed, String message) {
            return new ApplyResult(false, message, applied, failed, null);
        }

        public static ApplyResult failure(String message, Exception error) {
            return new ApplyResult(false, message, 0, 0, error);
        }
    }
}

