/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InlineDiffUtils {
    private static final int MAX_TOKENS = 200;

    public static InlineDiffResult diff(String left, String right) {
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        if (left.equals(right)) {
            return new InlineDiffResult(Collections.emptyList(), Collections.emptyList());
        }
        if (left.isEmpty()) {
            return new InlineDiffResult(Collections.emptyList(), right.isEmpty() ? Collections.emptyList() : Collections.singletonList(new HighlightRange(0, right.length())));
        }
        if (right.isEmpty()) {
            return new InlineDiffResult(Collections.singletonList(new HighlightRange(0, left.length())), Collections.emptyList());
        }
        List<Token> leftTokens = InlineDiffUtils.tokenize(left);
        List<Token> rightTokens = InlineDiffUtils.tokenize(right);
        if (leftTokens.size() > 200 || rightTokens.size() > 200) {
            return InlineDiffUtils.diffByPrefixSuffix(left, right);
        }
        return InlineDiffUtils.diffByTokens(left, right, leftTokens, rightTokens);
    }

    /*
     * Unable to fully structure code
     */
    private static List<Token> tokenize(String text) {
        tokens = new ArrayList<Token>();
        i = 0;
        len = text.length();
        while (i < len) {
            block5: {
                block4: {
                    c = text.charAt(i);
                    start = i;
                    if (!InlineDiffUtils.isWordChar(c)) break block4;
                    while (i < len && InlineDiffUtils.isWordChar(text.charAt(i))) {
                        ++i;
                    }
                    break block5;
                }
                if (!Character.isWhitespace(c)) ** GOTO lbl20
                while (i < len && Character.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                break block5;
                while (!InlineDiffUtils.isWordChar(cc = text.charAt(i)) && !Character.isWhitespace(cc)) {
                    ++i;
lbl20:
                    // 2 sources

                    if (i < len) continue;
                }
            }
            tokens.add(new Token(text.substring(start, i), start, i - start));
        }
        return tokens;
    }

    private static boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static InlineDiffResult diffByTokens(String left, String right, List<Token> leftTokens, List<Token> rightTokens) {
        int m = leftTokens.size();
        int n = rightTokens.size();
        int[][] lcs = new int[m + 1][n + 1];
        int i = m - 1;
        while (i >= 0) {
            int j = n - 1;
            while (j >= 0) {
                lcs[i][j] = leftTokens.get((int)i).text.equals(rightTokens.get((int)j).text) ? 1 + lcs[i + 1][j + 1] : Math.max(lcs[i + 1][j], lcs[i][j + 1]);
                --j;
            }
            --i;
        }
        ArrayList<HighlightRange> leftRanges = new ArrayList<HighlightRange>();
        ArrayList<HighlightRange> rightRanges = new ArrayList<HighlightRange>();
        int i2 = 0;
        int j = 0;
        while (i2 < m || j < n) {
            Token t;
            if (i2 < m && j < n && leftTokens.get((int)i2).text.equals(rightTokens.get((int)j).text)) {
                ++i2;
                ++j;
                continue;
            }
            if (j < n && (i2 >= m || lcs[i2][j + 1] >= lcs[i2 + 1][j])) {
                t = rightTokens.get(j);
                rightRanges.add(new HighlightRange(t.start, t.length));
                ++j;
                continue;
            }
            if (i2 >= m) continue;
            t = leftTokens.get(i2);
            leftRanges.add(new HighlightRange(t.start, t.length));
            ++i2;
        }
        return new InlineDiffResult(InlineDiffUtils.mergeAdjacentRanges(leftRanges), InlineDiffUtils.mergeAdjacentRanges(rightRanges));
    }

    private static InlineDiffResult diffByPrefixSuffix(String left, String right) {
        int prefixLen = InlineDiffUtils.commonPrefixLength(left, right);
        int suffixLen = InlineDiffUtils.commonSuffixLength(left, right, prefixLen);
        int leftDiffStart = prefixLen;
        int leftDiffEnd = left.length() - suffixLen;
        int rightDiffStart = prefixLen;
        int rightDiffEnd = right.length() - suffixLen;
        ArrayList<HighlightRange> leftRanges = new ArrayList<HighlightRange>();
        ArrayList<HighlightRange> rightRanges = new ArrayList<HighlightRange>();
        if (leftDiffEnd > leftDiffStart) {
            leftRanges.add(new HighlightRange(leftDiffStart, leftDiffEnd - leftDiffStart));
        }
        if (rightDiffEnd > rightDiffStart) {
            rightRanges.add(new HighlightRange(rightDiffStart, rightDiffEnd - rightDiffStart));
        }
        return new InlineDiffResult(leftRanges, rightRanges);
    }

    private static int commonPrefixLength(String a, String b) {
        int maxLen = Math.min(a.length(), b.length());
        int i = 0;
        while (i < maxLen && a.charAt(i) == b.charAt(i)) {
            ++i;
        }
        return i;
    }

    private static int commonSuffixLength(String a, String b, int prefixLen) {
        int maxLen = Math.min(a.length() - prefixLen, b.length() - prefixLen);
        int i = 0;
        while (i < maxLen && a.charAt(a.length() - 1 - i) == b.charAt(b.length() - 1 - i)) {
            ++i;
        }
        return i;
    }

    private static List<HighlightRange> mergeAdjacentRanges(List<HighlightRange> ranges) {
        if (ranges.size() <= 1) {
            return ranges;
        }
        ArrayList<HighlightRange> merged = new ArrayList<HighlightRange>();
        HighlightRange current = ranges.get(0);
        int i = 1;
        while (i < ranges.size()) {
            HighlightRange next = ranges.get(i);
            if (next.getStart() <= current.getEnd()) {
                int newEnd = Math.max(current.getEnd(), next.getEnd());
                current = new HighlightRange(current.getStart(), newEnd - current.getStart());
            } else {
                merged.add(current);
                current = next;
            }
            ++i;
        }
        merged.add(current);
        return merged;
    }

    public static class HighlightRange {
        private final int start;
        private final int length;

        public HighlightRange(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public int getEnd() {
            return this.start + this.length;
        }
    }

    public static class InlineDiffResult {
        private final List<HighlightRange> leftRanges;
        private final List<HighlightRange> rightRanges;

        public InlineDiffResult(List<HighlightRange> leftRanges, List<HighlightRange> rightRanges) {
            this.leftRanges = Collections.unmodifiableList(new ArrayList<HighlightRange>(leftRanges));
            this.rightRanges = Collections.unmodifiableList(new ArrayList<HighlightRange>(rightRanges));
        }

        public List<HighlightRange> getLeftRanges() {
            return this.leftRanges;
        }

        public List<HighlightRange> getRightRanges() {
            return this.rightRanges;
        }

        public boolean hasChanges() {
            return !this.leftRanges.isEmpty() || !this.rightRanges.isEmpty();
        }
    }

    private static class Token {
        final String text;
        final int start;
        final int length;

        Token(String text, int start, int length) {
            this.text = text;
            this.start = start;
            this.length = length;
        }
    }
}

