/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LineDiffUtils {
    public static final int DEFAULT_CONTEXT_LINES = 3;

    public static DiffResult computeDiff(String oldText, String newText) {
        return LineDiffUtils.computeDiff(oldText, newText, 3);
    }

    public static DiffResult computeDiff(String oldText, String newText, int contextLines) {
        String[] oldLines = LineDiffUtils.splitLines(oldText);
        String[] newLines = LineDiffUtils.splitLines(newText);
        List<DiffLine> diffLines = LineDiffUtils.computeDiffLines(oldLines, newLines);
        List<DiffHunk> hunks = LineDiffUtils.buildHunks(diffLines, contextLines);
        List<AlignedRow> alignedRows = LineDiffUtils.buildAlignedRows(diffLines);
        int added = 0;
        int deleted = 0;
        for (DiffLine line : diffLines) {
            if (line.getType() == LineType.ADDED) {
                ++added;
            }
            if (line.getType() != LineType.DELETED) continue;
            ++deleted;
        }
        return new DiffResult(diffLines, hunks, alignedRows, added, deleted);
    }

    private static String[] splitLines(String text) {
        if (text == null || text.isEmpty()) {
            return new String[0];
        }
        text = text.replace("\r\n", "\n").replace("\r", "\n");
        return text.split("\n", -1);
    }

    private static List<DiffLine> computeDiffLines(String[] oldLines, String[] newLines) {
        int m = oldLines.length;
        int n = newLines.length;
        int[][] lcs = new int[m + 1][n + 1];
        int i = m - 1;
        while (i >= 0) {
            int j = n - 1;
            while (j >= 0) {
                lcs[i][j] = oldLines[i].equals(newLines[j]) ? 1 + lcs[i + 1][j + 1] : Math.max(lcs[i + 1][j], lcs[i][j + 1]);
                --j;
            }
            --i;
        }
        ArrayList<DiffLine> result = new ArrayList<DiffLine>();
        int i2 = 0;
        int j = 0;
        int oldLineNum = 1;
        int newLineNum = 1;
        while (i2 < m || j < n) {
            if (i2 < m && j < n && oldLines[i2].equals(newLines[j])) {
                result.add(new DiffLine(LineType.UNCHANGED, oldLines[i2], oldLineNum++, newLineNum++));
                ++i2;
                ++j;
                continue;
            }
            if (j < n && (i2 >= m || lcs[i2][j + 1] >= lcs[i2 + 1][j])) {
                result.add(new DiffLine(LineType.ADDED, newLines[j], -1, newLineNum++));
                ++j;
                continue;
            }
            if (i2 >= m) continue;
            result.add(new DiffLine(LineType.DELETED, oldLines[i2], oldLineNum++, -1));
            ++i2;
        }
        return result;
    }

    private static List<DiffHunk> buildHunks(List<DiffLine> diffLines, int contextLines) {
        if (diffLines.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<int[]> changeRanges = new ArrayList<int[]>();
        int changeStart = -1;
        int i = 0;
        while (i < diffLines.size()) {
            if (diffLines.get(i).isChanged()) {
                if (changeStart < 0) {
                    changeStart = i;
                }
            } else if (changeStart >= 0) {
                changeRanges.add(new int[]{changeStart, i - 1});
                changeStart = -1;
            }
            ++i;
        }
        if (changeStart >= 0) {
            changeRanges.add(new int[]{changeStart, diffLines.size() - 1});
        }
        if (changeRanges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<int[]> mergedRanges = new ArrayList<int[]>();
        int[] currentRange = null;
        for (int[] range : changeRanges) {
            int start = Math.max(0, range[0] - contextLines);
            int end = Math.min(diffLines.size() - 1, range[1] + contextLines);
            if (currentRange == null) {
                currentRange = new int[]{start, end};
                continue;
            }
            if (start <= currentRange[1] + true) {
                currentRange[1] = Math.max(currentRange[1], end);
                continue;
            }
            mergedRanges.add(currentRange);
            currentRange = new int[]{start, end};
        }
        if (currentRange != null) {
            mergedRanges.add(currentRange);
        }
        ArrayList<DiffHunk> hunks = new ArrayList<DiffHunk>();
        for (int[] range : mergedRanges) {
            ArrayList<DiffLine> hunkLines = new ArrayList<DiffLine>();
            int oldStart = -1;
            int newStart = -1;
            int oldCount = 0;
            int newCount = 0;
            int i2 = range[0];
            while (i2 <= range[1]) {
                DiffLine line = diffLines.get(i2);
                hunkLines.add(line);
                switch (line.getType()) {
                    case UNCHANGED: {
                        if (oldStart < 0) {
                            oldStart = line.getOldLineNumber();
                        }
                        if (newStart < 0) {
                            newStart = line.getNewLineNumber();
                        }
                        ++oldCount;
                        ++newCount;
                        break;
                    }
                    case DELETED: {
                        if (oldStart < 0) {
                            oldStart = line.getOldLineNumber();
                        }
                        ++oldCount;
                        break;
                    }
                    case ADDED: {
                        if (newStart < 0) {
                            newStart = line.getNewLineNumber();
                        }
                        ++newCount;
                    }
                }
                ++i2;
            }
            if (oldStart < 0) {
                oldStart = 1;
            }
            if (newStart < 0) {
                newStart = 1;
            }
            hunks.add(new DiffHunk(oldStart, oldCount, newStart, newCount, hunkLines));
        }
        return hunks;
    }

    private static List<AlignedRow> buildAlignedRows(List<DiffLine> diffLines) {
        ArrayList<AlignedRow> rows = new ArrayList<AlignedRow>();
        int i = 0;
        while (i < diffLines.size()) {
            DiffLine line = diffLines.get(i);
            switch (line.getType()) {
                case UNCHANGED: {
                    rows.add(new AlignedRow(line.getContent(), line.getContent(), line.getOldLineNumber(), line.getNewLineNumber(), AlignedRow.RowType.UNCHANGED));
                    ++i;
                    break;
                }
                case DELETED: {
                    if (i + 1 < diffLines.size() && diffLines.get(i + 1).getType() == LineType.ADDED) {
                        DiffLine addedLine = diffLines.get(i + 1);
                        rows.add(new AlignedRow(line.getContent(), addedLine.getContent(), line.getOldLineNumber(), addedLine.getNewLineNumber(), AlignedRow.RowType.MODIFIED));
                        i += 2;
                        break;
                    }
                    rows.add(new AlignedRow(line.getContent(), "", line.getOldLineNumber(), -1, AlignedRow.RowType.DELETED));
                    ++i;
                    break;
                }
                case ADDED: {
                    rows.add(new AlignedRow("", line.getContent(), -1, line.getNewLineNumber(), AlignedRow.RowType.ADDED));
                    ++i;
                }
            }
        }
        return rows;
    }

    private static List<AlignedRow> filterWithContext(List<AlignedRow> rows, int contextLines) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changeIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < rows.size()) {
            if (rows.get(i).isChanged()) {
                changeIndices.add(i);
            }
            ++i;
        }
        if (changeIndices.isEmpty()) {
            return Collections.emptyList();
        }
        boolean[] include = new boolean[rows.size()];
        Iterator iterator = changeIndices.iterator();
        while (iterator.hasNext()) {
            int changeIdx = (Integer)iterator.next();
            int start = Math.max(0, changeIdx - contextLines);
            int end = Math.min(rows.size() - 1, changeIdx + contextLines);
            int i2 = start;
            while (i2 <= end) {
                include[i2] = true;
                ++i2;
            }
        }
        ArrayList<AlignedRow> result = new ArrayList<AlignedRow>();
        boolean inGap = false;
        int i3 = 0;
        while (i3 < rows.size()) {
            if (include[i3]) {
                if (inGap && !result.isEmpty()) {
                    result.add(new AlignedRow("...", "...", -1, -1, AlignedRow.RowType.UNCHANGED));
                }
                result.add(rows.get(i3));
                inGap = false;
            } else {
                inGap = true;
            }
            ++i3;
        }
        return result;
    }

    public static class AlignedRow {
        private final String leftContent;
        private final String rightContent;
        private final int leftLineNumber;
        private final int rightLineNumber;
        private final RowType type;

        public AlignedRow(String leftContent, String rightContent, int leftLineNumber, int rightLineNumber, RowType type) {
            this.leftContent = leftContent;
            this.rightContent = rightContent;
            this.leftLineNumber = leftLineNumber;
            this.rightLineNumber = rightLineNumber;
            this.type = type;
        }

        public String getLeftContent() {
            return this.leftContent;
        }

        public String getRightContent() {
            return this.rightContent;
        }

        public int getLeftLineNumber() {
            return this.leftLineNumber;
        }

        public int getRightLineNumber() {
            return this.rightLineNumber;
        }

        public RowType getType() {
            return this.type;
        }

        public boolean isChanged() {
            return this.type != RowType.UNCHANGED;
        }

        public boolean hasLeft() {
            return this.leftLineNumber >= 0;
        }

        public boolean hasRight() {
            return this.rightLineNumber >= 0;
        }

        public static enum RowType {
            UNCHANGED,
            DELETED,
            ADDED,
            MODIFIED;

        }
    }

    public static class DiffHunk {
        private final int oldStart;
        private final int oldCount;
        private final int newStart;
        private final int newCount;
        private final List<DiffLine> lines;

        public DiffHunk(int oldStart, int oldCount, int newStart, int newCount, List<DiffLine> lines) {
            this.oldStart = oldStart;
            this.oldCount = oldCount;
            this.newStart = newStart;
            this.newCount = newCount;
            this.lines = Collections.unmodifiableList(new ArrayList<DiffLine>(lines));
        }

        public int getOldStart() {
            return this.oldStart;
        }

        public int getOldCount() {
            return this.oldCount;
        }

        public int getNewStart() {
            return this.newStart;
        }

        public int getNewCount() {
            return this.newCount;
        }

        public List<DiffLine> getLines() {
            return this.lines;
        }

        public String getHeader() {
            return String.format("@@ -%d,%d +%d,%d @@", this.oldStart, this.oldCount, this.newStart, this.newCount);
        }
    }

    public static class DiffLine {
        private final LineType type;
        private final String content;
        private final int oldLineNumber;
        private final int newLineNumber;

        public DiffLine(LineType type, String content, int oldLineNumber, int newLineNumber) {
            this.type = type;
            this.content = content;
            this.oldLineNumber = oldLineNumber;
            this.newLineNumber = newLineNumber;
        }

        public LineType getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public int getOldLineNumber() {
            return this.oldLineNumber;
        }

        public int getNewLineNumber() {
            return this.newLineNumber;
        }

        public boolean isChanged() {
            return this.type != LineType.UNCHANGED;
        }
    }

    public static class DiffResult {
        private final List<DiffLine> allLines;
        private final List<DiffHunk> hunks;
        private final List<AlignedRow> alignedRows;
        private final int addedCount;
        private final int deletedCount;

        public DiffResult(List<DiffLine> allLines, List<DiffHunk> hunks, List<AlignedRow> alignedRows, int addedCount, int deletedCount) {
            this.allLines = Collections.unmodifiableList(new ArrayList<DiffLine>(allLines));
            this.hunks = Collections.unmodifiableList(new ArrayList<DiffHunk>(hunks));
            this.alignedRows = Collections.unmodifiableList(new ArrayList<AlignedRow>(alignedRows));
            this.addedCount = addedCount;
            this.deletedCount = deletedCount;
        }

        public List<DiffLine> getAllLines() {
            return this.allLines;
        }

        public List<DiffHunk> getHunks() {
            return this.hunks;
        }

        public List<AlignedRow> getAlignedRows() {
            return this.alignedRows;
        }

        public int getAddedCount() {
            return this.addedCount;
        }

        public int getDeletedCount() {
            return this.deletedCount;
        }

        public boolean hasChanges() {
            return this.addedCount > 0 || this.deletedCount > 0;
        }

        public List<AlignedRow> getAlignedRowsWithContext(int contextLines) {
            return LineDiffUtils.filterWithContext(this.alignedRows, contextLines);
        }
    }

    public static enum LineType {
        DELETED,
        ADDED,
        UNCHANGED;

    }
}

