/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

import com.example.vibe.core.edit.EditBlock;
import com.example.vibe.core.edit.FuzzyMatcher;
import com.example.vibe.core.edit.MatchLocation;
import com.example.vibe.core.edit.MatchResult;
import com.example.vibe.core.edit.MatchStrategy;
import com.example.vibe.core.edit.SearchReplaceFormat;
import com.example.vibe.core.logging.VibeLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FileEditApplier {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(FileEditApplier.class);
    private final FuzzyMatcher matcher;
    private final SearchReplaceFormat parser;

    public FileEditApplier() {
        this(new FuzzyMatcher(), new SearchReplaceFormat());
    }

    public FileEditApplier(FuzzyMatcher matcher, SearchReplaceFormat parser) {
        this.matcher = matcher;
        this.parser = parser;
    }

    public ApplyResult apply(String beforeContent, List<EditBlock> blocks) {
        if (beforeContent == null) {
            beforeContent = "";
        }
        if (blocks == null || blocks.isEmpty()) {
            return ApplyResult.noChanges(beforeContent);
        }
        LOG.debug("FileEditApplier: applying %d blocks to content of %d chars", blocks.size(), beforeContent.length());
        ArrayList<MatchedEdit> matchedEdits = new ArrayList<MatchedEdit>();
        ArrayList<Hunk> failedHunks = new ArrayList<Hunk>();
        for (EditBlock block : blocks) {
            MatchResult matchResult = this.matcher.findMatch(block.getSearchText(), beforeContent);
            if (matchResult.isSuccess()) {
                MatchLocation location = matchResult.getLocation().orElseThrow();
                matchedEdits.add(new MatchedEdit(block, location, matchResult.getStrategy()));
                continue;
            }
            Hunk failedHunk = new Hunk(block.getBlockIndex(), -1, -1, block.getSearchText(), block.getReplaceText(), HunkStatus.FAILED, matchResult.generateFeedback());
            failedHunks.add(failedHunk);
            LOG.warn("FileEditApplier: block %d failed to match: %s", block.getBlockIndex(), matchResult.getErrorMessage());
        }
        matchedEdits.sort(Comparator.comparingInt(e -> e.location.getStartOffset()));
        int i = 1;
        while (i < matchedEdits.size()) {
            MatchedEdit prev = (MatchedEdit)matchedEdits.get(i - 1);
            MatchedEdit curr = (MatchedEdit)matchedEdits.get(i);
            if (prev.location.getEndOffset() > curr.location.getStartOffset()) {
                String error = String.format("\u0411\u043b\u043e\u043a\u0438 %d \u0438 %d \u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u044f\u0445 %d-%d \u0438 %d-%d", prev.block.getBlockIndex(), curr.block.getBlockIndex(), prev.location.getStartOffset(), prev.location.getEndOffset(), curr.location.getStartOffset(), curr.location.getEndOffset());
                return ApplyResult.error(beforeContent, error);
            }
            ++i;
        }
        ArrayList<Hunk> appliedHunks = new ArrayList<Hunk>();
        Object currentContent = beforeContent;
        matchedEdits.sort(Comparator.comparingInt(e -> e.location.getStartOffset()).reversed());
        for (MatchedEdit edit : matchedEdits) {
            int start = edit.location.getStartOffset();
            int end = edit.location.getEndOffset();
            String before = ((String)currentContent).substring(0, start);
            String after = ((String)currentContent).substring(end);
            currentContent = before + edit.block.getReplaceText() + after;
            Hunk hunk = new Hunk(edit.block.getBlockIndex(), edit.location.getStartLine(), edit.location.getEndLine(), edit.location.getMatchedText(), edit.block.getReplaceText(), HunkStatus.APPLIED, "\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0438: " + edit.strategy.getDisplayName());
            appliedHunks.add(hunk);
        }
        appliedHunks.sort(Comparator.comparingInt(Hunk::blockIndex));
        failedHunks.sort(Comparator.comparingInt(Hunk::blockIndex));
        ArrayList<Hunk> allHunks = new ArrayList<Hunk>();
        allHunks.addAll(appliedHunks);
        allHunks.addAll(failedHunks);
        allHunks.sort(Comparator.comparingInt(Hunk::blockIndex));
        LOG.info("FileEditApplier: %d/%d blocks applied successfully", appliedHunks.size(), blocks.size());
        return new ApplyResult(beforeContent, (String)currentContent, allHunks, failedHunks.isEmpty());
    }

    public ApplyResult applyFromResponse(String beforeContent, String llmResponse) {
        List<EditBlock> blocks = this.parser.parse(llmResponse);
        if (blocks.isEmpty()) {
            return ApplyResult.noChanges(beforeContent);
        }
        List<String> errors = this.parser.validate(blocks);
        if (!errors.isEmpty()) {
            return ApplyResult.error(beforeContent, String.join((CharSequence)"; ", errors));
        }
        return this.apply(beforeContent, blocks);
    }

    public ApplyResult preview(String beforeContent, List<EditBlock> blocks) {
        ApplyResult result = this.apply(beforeContent, blocks);
        ArrayList<Hunk> previewHunks = new ArrayList<Hunk>();
        for (Hunk hunk : result.hunks()) {
            if (hunk.status() == HunkStatus.APPLIED) {
                previewHunks.add(new Hunk(hunk.blockIndex(), hunk.startLine(), hunk.endLine(), hunk.beforeText(), hunk.afterText(), HunkStatus.PREVIEW, hunk.message()));
                continue;
            }
            previewHunks.add(hunk);
        }
        return new ApplyResult(result.beforeContent(), result.afterContent(), previewHunks, result.allSuccessful());
    }

    public record ApplyResult(String beforeContent, String afterContent, List<Hunk> hunks, boolean allSuccessful) {
        public static ApplyResult noChanges(String content) {
            return new ApplyResult(content, content, Collections.emptyList(), true);
        }

        public static ApplyResult error(String content, String error) {
            Hunk errorHunk = new Hunk(0, -1, -1, "", "", HunkStatus.FAILED, error);
            return new ApplyResult(content, content, List.of(errorHunk), false);
        }

        public List<Hunk> getAppliedHunks() {
            return this.hunks.stream().filter(h -> h.status() == HunkStatus.APPLIED || h.status() == HunkStatus.PREVIEW).toList();
        }

        public List<Hunk> getFailedHunks() {
            return this.hunks.stream().filter(h -> h.status() == HunkStatus.FAILED).toList();
        }

        public boolean hasChanges() {
            return !this.beforeContent.equals(this.afterContent);
        }

        public String getSummary() {
            int applied = this.getAppliedHunks().size();
            int failed = this.getFailedHunks().size();
            int total = this.hunks.size();
            if (total == 0) {
                return "\u041d\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439";
            }
            if (this.allSuccessful) {
                return String.format("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439: %d", applied);
            }
            return String.format("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e: %d/%d, \u043e\u0448\u0438\u0431\u043e\u043a: %d", applied, total, failed);
        }

        public String getFailureFeedback() {
            List<Hunk> failed = this.getFailedHunks();
            if (failed.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f:\n\n");
            for (Hunk hunk : failed) {
                sb.append(String.format("=== \u0411\u043b\u043e\u043a %d ===\n", hunk.blockIndex() + 1));
                sb.append(hunk.message()).append("\n\n");
            }
            return sb.toString();
        }
    }

    public record Hunk(int blockIndex, int startLine, int endLine, String beforeText, String afterText, HunkStatus status, String message) {
        public boolean isMatched() {
            return this.startLine >= 0;
        }

        public int getLineDelta() {
            int beforeLines = this.beforeText != null ? this.beforeText.split("\n", -1).length : 0;
            int afterLines = this.afterText != null ? this.afterText.split("\n", -1).length : 0;
            return afterLines - beforeLines;
        }

        public String getSummary() {
            if (!this.isMatched()) {
                return String.format("\u0411\u043b\u043e\u043a %d: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", this.blockIndex + 1);
            }
            int delta = this.getLineDelta();
            if (delta > 0) {
                return String.format("\u0421\u0442\u0440\u043e\u043a\u0438 %d-%d (+%d)", this.startLine, this.endLine, delta);
            }
            if (delta < 0) {
                return String.format("\u0421\u0442\u0440\u043e\u043a\u0438 %d-%d (%d)", this.startLine, this.endLine, delta);
            }
            return String.format("\u0421\u0442\u0440\u043e\u043a\u0438 %d-%d", this.startLine, this.endLine);
        }
    }

    public static enum HunkStatus {
        APPLIED,
        PREVIEW,
        FAILED,
        ACCEPTED,
        REJECTED;

    }

    private static class MatchedEdit {
        final EditBlock block;
        final MatchLocation location;
        final MatchStrategy strategy;

        MatchedEdit(EditBlock block, MatchLocation location, MatchStrategy strategy) {
            this.block = block;
            this.location = location;
            this.strategy = strategy;
        }
    }
}

