/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

public final class MatchLocation {
    private final int startOffset;
    private final int endOffset;
    private final int startLine;
    private final int endLine;
    private final String matchedText;

    public MatchLocation(int startOffset, int endOffset, int startLine, int endLine, String matchedText) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.startLine = startLine;
        this.endLine = endLine;
        this.matchedText = matchedText;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getMatchedText() {
        return this.matchedText;
    }

    public String toString() {
        return String.format("MatchLocation[offset=%d-%d, lines=%d-%d, len=%d]", this.startOffset, this.endOffset, this.startLine, this.endLine, this.getLength());
    }
}

