/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

import com.example.vibe.core.edit.MatchLocation;
import com.example.vibe.core.edit.MatchStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class MatchResult {
    private final boolean success;
    private final MatchLocation location;
    private final MatchStrategy strategy;
    private final double similarity;
    private final String errorMessage;
    private final List<SimilarMatch> candidates;

    private MatchResult(boolean success, MatchLocation location, MatchStrategy strategy, double similarity, String errorMessage, List<SimilarMatch> candidates) {
        this.success = success;
        this.location = location;
        this.strategy = strategy;
        this.similarity = similarity;
        this.errorMessage = errorMessage;
        this.candidates = candidates != null ? candidates : Collections.emptyList();
    }

    public static MatchResult success(MatchLocation location, MatchStrategy strategy) {
        return new MatchResult(true, location, strategy, 1.0, null, null);
    }

    public static MatchResult success(MatchLocation location, MatchStrategy strategy, double similarity) {
        return new MatchResult(true, location, strategy, similarity, null, null);
    }

    public static MatchResult failure(String errorMessage) {
        return new MatchResult(false, null, null, 0.0, errorMessage, null);
    }

    public static MatchResult failure(String errorMessage, List<SimilarMatch> candidates) {
        return new MatchResult(false, null, null, 0.0, errorMessage, candidates);
    }

    public static MatchResult ambiguous(List<SimilarMatch> candidates) {
        String message = String.format("\u041d\u0430\u0439\u0434\u0435\u043d\u043e %d \u043f\u043e\u0445\u043e\u0436\u0438\u0445 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0439. \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438.", candidates.size());
        return new MatchResult(false, null, null, 0.0, message, candidates);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Optional<MatchLocation> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public MatchStrategy getStrategy() {
        return this.strategy;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimilarMatch> getCandidates() {
        return this.candidates;
    }

    public String generateFeedback() {
        if (this.success) {
            return "\u0421\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u041e\u0428\u0418\u0411\u041a\u0410: ").append(this.errorMessage).append("\n\n");
        if (!this.candidates.isEmpty()) {
            sb.append("\u041d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0445\u043e\u0436\u0438\u0435 \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u044b:\n");
            int shown = Math.min(this.candidates.size(), 3);
            int i = 0;
            while (i < shown) {
                SimilarMatch candidate = this.candidates.get(i);
                sb.append(String.format("\n--- \u041a\u0430\u043d\u0434\u0438\u0434\u0430\u0442 %d (\u0441\u0442\u0440\u043e\u043a\u0438 %d-%d, \u0441\u0445\u043e\u0434\u0441\u0442\u0432\u043e: %.0f%%) ---\n", i + 1, candidate.startLine(), candidate.endLine(), candidate.similarity() * 100.0));
                String[] lines = candidate.text().split("\n", 6);
                int j = 0;
                while (j < Math.min(lines.length, 5)) {
                    sb.append(lines[j]).append("\n");
                    ++j;
                }
                if (lines.length > 5) {
                    sb.append("...\n");
                }
                ++i;
            }
            sb.append("\n\u041f\u041e\u0414\u0421\u041a\u0410\u0417\u041a\u0410: \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0422\u041e\u0427\u041d\u042b\u0419 \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u043a\u0430\u043d\u0434\u0438\u0434\u0430\u0442\u043e\u0432 \u0432 SEARCH \u0431\u043b\u043e\u043a\u0435.");
        } else {
            sb.append("\u041f\u041e\u0414\u0421\u041a\u0410\u0417\u041a\u0410: \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0447\u0442\u043e \u0438\u0441\u043a\u043e\u043c\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0444\u0430\u0439\u043b\u0435. ");
            sb.append("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0444\u0430\u0439\u043b \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0451\u043d \u0438\u043b\u0438 \u0442\u0435\u043a\u0441\u0442 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0431\u0435\u043b\u0430\u043c\u0438/\u043e\u0442\u0441\u0442\u0443\u043f\u0430\u043c\u0438.");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.success) {
            return String.format("MatchResult[success, %s, similarity=%.2f]", new Object[]{this.strategy, this.similarity});
        }
        return String.format("MatchResult[failed: %s, candidates=%d]", this.errorMessage, this.candidates.size());
    }

    public record SimilarMatch(String text, int startLine, int endLine, double similarity) {
    }
}

