/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.http;

import com.example.vibe.core.http.HttpClientConfig;
import com.example.vibe.core.http.HttpClientFactory;
import com.example.vibe.core.internal.VibeCorePlugin;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private volatile HttpClient httpClient;
    private volatile HttpClientConfig config = this.loadConfigFromPreferences();
    private volatile ExecutorService executor = this.createExecutor();

    public DefaultHttpClientFactory() {
        this.httpClient = this.buildClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getSharedClient() {
        HttpClient client = this.httpClient;
        if (client == null) {
            DefaultHttpClientFactory defaultHttpClientFactory = this;
            synchronized (defaultHttpClientFactory) {
                client = this.httpClient;
                if (client == null) {
                    this.httpClient = client = this.buildClient();
                }
            }
        }
        return client;
    }

    @Override
    public HttpClientConfig getConfig() {
        return this.config;
    }

    @Override
    public synchronized void refresh() {
        this.config = this.loadConfigFromPreferences();
        this.httpClient = this.buildClient();
        VibeCorePlugin.logInfo("HTTP client refreshed with new configuration");
    }

    @Override
    public synchronized void dispose() {
        this.httpClient = null;
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.executor = null;
        }
        VibeCorePlugin.logInfo("HTTP client factory disposed");
    }

    private HttpClient buildClient() {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(this.config.getConnectTimeout()).followRedirects(this.config.getRedirectPolicy());
        if (this.config.isHttp2Enabled()) {
            builder.version(HttpClient.Version.HTTP_2);
        } else {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        if (this.config.isUseSystemProxy()) {
            builder.proxy(ProxySelector.getDefault());
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            builder.executor(this.executor);
        }
        return builder.build();
    }

    private ExecutorService createExecutor() {
        return Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r, "Vibe-HTTP-Worker");
            t.setDaemon(true);
            return t;
        });
    }

    private HttpClientConfig loadConfigFromPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.example.vibe.core");
        int timeout = prefs.getInt("requestTimeout", 60);
        boolean http2Enabled = prefs.getBoolean("http.http2Enabled", true);
        boolean useProxy = prefs.getBoolean("http.useSystemProxy", true);
        boolean gzipEnabled = prefs.getBoolean("http.gzipEnabled", true);
        int gzipMinBytes = prefs.getInt("http.gzipMinBytes", 1024);
        return HttpClientConfig.builder().connectTimeout(Duration.ofSeconds(30L)).requestTimeout(Duration.ofSeconds(timeout)).http2Enabled(http2Enabled).useSystemProxy(useProxy).redirectPolicy(HttpClient.Redirect.NORMAL).gzipRequestEnabled(gzipEnabled).gzipMinBytes(gzipMinBytes).build();
    }
}

