/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.logging;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public final class LogSanitizer {
    public static final int DEFAULT_MAX_LENGTH = 500;
    public static final int CODE_MAX_LENGTH = 200;
    public static final int PATH_MAX_LENGTH = 150;
    private static final AtomicLong REQUEST_COUNTER = new AtomicLong(0L);
    private static final Pattern API_KEY_PATTERN = Pattern.compile("(sk-[a-zA-Z0-9]{20,}|api[_-]?key[\"']?\\s*[:=]\\s*[\"']?)[a-zA-Z0-9_-]{10,}", 2);
    private static final Pattern BEARER_TOKEN_PATTERN = Pattern.compile("(Bearer\\s+)[a-zA-Z0-9._-]{20,}", 2);
    private static final Pattern AUTH_HEADER_PATTERN = Pattern.compile("(Authorization[\"']?\\s*[:=]\\s*[\"']?)[^\"'\\s]{10,}", 2);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(password[\"']?\\s*[:=]\\s*[\"']?)[^\"'\\s]{3,}", 2);

    private LogSanitizer() {
    }

    public static String newCorrelationId() {
        long counter = REQUEST_COUNTER.incrementAndGet();
        return String.format("req-%d-%s", counter, UUID.randomUUID().toString().substring(0, 8));
    }

    public static String newId(String prefix) {
        return String.format("%s-%s", prefix, UUID.randomUUID().toString().substring(0, 8));
    }

    public static String truncate(String text, int maxLength) {
        if (text == null) {
            return "[null]";
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + "... [\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e, \u0432\u0441\u0435\u0433\u043e " + text.length() + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432]";
    }

    public static String truncate(String text) {
        return LogSanitizer.truncate(text, 500);
    }

    public static String truncateCode(String code) {
        return LogSanitizer.truncate(code, 200);
    }

    public static String truncatePath(String path) {
        return LogSanitizer.truncate(path, 150);
    }

    public static String textSize(String text) {
        if (text == null) {
            return "null";
        }
        return text.length() + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432";
    }

    public static String byteSize(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return LogSanitizer.formatBytes(bytes.length);
    }

    public static String redactSecrets(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = text;
        result = API_KEY_PATTERN.matcher(result).replaceAll("$1[REDACTED]");
        result = BEARER_TOKEN_PATTERN.matcher(result).replaceAll("$1[REDACTED]");
        result = AUTH_HEADER_PATTERN.matcher(result).replaceAll("$1[REDACTED]");
        result = PASSWORD_PATTERN.matcher(result).replaceAll("$1[REDACTED]");
        return result;
    }

    public static String maskApiKey(String apiKey) {
        if (apiKey == null || apiKey.length() < 8) {
            return "[\u043d\u0435 \u0437\u0430\u0434\u0430\u043d]";
        }
        return apiKey.substring(0, 3) + "..." + apiKey.substring(apiKey.length() - 4);
    }

    public static String formatDuration(long millis) {
        if (millis < 1000L) {
            return millis + " \u043c\u0441";
        }
        if (millis < 60000L) {
            return String.format("%.1f \u0441", (double)millis / 1000.0);
        }
        long minutes = millis / 60000L;
        long seconds = millis % 60000L / 1000L;
        return String.format("%d \u043c\u0438\u043d %d \u0441", minutes, seconds);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    public static String safeToString(Object obj) {
        if (obj == null) {
            return "[null]";
        }
        try {
            return LogSanitizer.truncate(obj.toString());
        }
        catch (Exception e) {
            return "[\u043e\u0448\u0438\u0431\u043a\u0430 toString: " + e.getClass().getSimpleName() + "]";
        }
    }

    public static String className(Object obj) {
        if (obj == null) {
            return "[null]";
        }
        return obj.getClass().getSimpleName();
    }

    public static String arraySize(Object[] array) {
        if (array == null) {
            return "null";
        }
        return array.length + " \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432";
    }

    public static String collectionSize(Collection<?> collection) {
        if (collection == null) {
            return "null";
        }
        return collection.size() + " \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432";
    }

    public static String mapSize(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        return map.size() + " \u043f\u0430\u0440";
    }
}

