/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class VibeLogger {
    private static final VibeLogger INSTANCE = new VibeLogger();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final int MAX_MEMORY_LOGS = 1000;
    private Level minLevel = Level.DEBUG;
    private boolean logToEclipse = true;
    private boolean logToFile = false;
    private Path logFilePath;
    private final List<LogEntry> memoryLog = new CopyOnWriteArrayList<LogEntry>();
    private final List<Consumer<LogEntry>> listeners = new CopyOnWriteArrayList<Consumer<LogEntry>>();

    private VibeLogger() {
        try {
            Path stateLocation = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(VibeLogger.class)).toPath();
            this.logFilePath = stateLocation.resolve("vibe.log");
        }
        catch (Exception exception) {
            this.logFilePath = Path.of(System.getProperty("java.io.tmpdir"), "vibe.log");
        }
    }

    public static VibeLogger getInstance() {
        return INSTANCE;
    }

    public void setMinLevel(Level level) {
        this.minLevel = level;
    }

    public void setLogToEclipse(boolean enabled) {
        this.logToEclipse = enabled;
    }

    public void setLogToFile(boolean enabled) {
        this.logToFile = enabled;
    }

    public void setLogFilePath(Path path) {
        this.logFilePath = path;
    }

    public Path getLogFilePath() {
        return this.logFilePath;
    }

    public void addListener(Consumer<LogEntry> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Consumer<LogEntry> listener) {
        this.listeners.remove(listener);
    }

    public void debug(String category, String message) {
        this.log(Level.DEBUG, category, message, null);
    }

    public void debug(String category, String format, Object ... args) {
        this.log(Level.DEBUG, category, String.format(format, args), null);
    }

    public void info(String category, String message) {
        this.log(Level.INFO, category, message, null);
    }

    public void info(String category, String format, Object ... args) {
        this.log(Level.INFO, category, String.format(format, args), null);
    }

    public void warn(String category, String message) {
        this.log(Level.WARN, category, message, null);
    }

    public void warn(String category, String message, Throwable t) {
        this.log(Level.WARN, category, message, t);
    }

    public void error(String category, String message) {
        this.log(Level.ERROR, category, message, null);
    }

    public void error(String category, String message, Throwable t) {
        this.log(Level.ERROR, category, message, t);
    }

    public void log(Level level, String category, String message, Throwable throwable) {
        if (level.getSeverity() < this.minLevel.getSeverity()) {
            return;
        }
        LogEntry entry = new LogEntry(level, category, message, throwable);
        this.memoryLog.add(entry);
        while (this.memoryLog.size() > 1000) {
            this.memoryLog.remove(0);
        }
        for (Consumer<LogEntry> listener : this.listeners) {
            try {
                listener.accept(entry);
            }
            catch (Exception exception) {}
        }
        if (this.logToEclipse) {
            this.logToEclipse(entry);
        }
        if (this.logToFile) {
            this.logToFile(entry);
        }
    }

    private void logToEclipse(LogEntry entry) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(VibeLogger.class);
            if (bundle == null) {
                return;
            }
            ILog log = Platform.getLog((Bundle)bundle);
            int severity = switch (entry.getLevel()) {
                case Level.DEBUG, Level.INFO -> 1;
                case Level.WARN -> 2;
                case Level.ERROR -> 4;
                default -> 1;
            };
            String fullMessage = "[" + entry.getCategory() + "] " + entry.getMessage();
            log.log((IStatus)new Status(severity, bundle.getSymbolicName(), fullMessage, entry.getThrowable()));
        }
        catch (Exception exception) {
            System.err.println(entry.toString());
        }
    }

    private void logToFile(LogEntry entry) {
        if (this.logFilePath == null) {
            return;
        }
        try {
            Files.writeString(this.logFilePath, (CharSequence)(entry.toString() + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {}
    }

    public List<LogEntry> getMemoryLog() {
        return Collections.unmodifiableList(new ArrayList<LogEntry>(this.memoryLog));
    }

    public List<LogEntry> getMemoryLog(Level minLevel) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (LogEntry entry : this.memoryLog) {
            if (entry.getLevel().getSeverity() < minLevel.getSeverity()) continue;
            result.add(entry);
        }
        return result;
    }

    public void clearMemoryLog() {
        this.memoryLog.clear();
    }

    public void clearLogFile() {
        if (this.logFilePath != null) {
            try {
                Files.deleteIfExists(this.logFilePath);
            }
            catch (IOException iOException) {}
        }
    }

    public static CategoryLogger forCategory(String category) {
        return new CategoryLogger(category);
    }

    public static CategoryLogger forClass(Class<?> clazz) {
        return new CategoryLogger(clazz.getSimpleName());
    }

    public static class CategoryLogger {
        private final String category;

        public CategoryLogger(String category) {
            this.category = category;
        }

        public void debug(String message) {
            INSTANCE.debug(this.category, message);
        }

        public void debug(String format, Object ... args) {
            INSTANCE.debug(this.category, format, args);
        }

        public void info(String message) {
            INSTANCE.info(this.category, message);
        }

        public void info(String format, Object ... args) {
            INSTANCE.info(this.category, format, args);
        }

        public void warn(String message) {
            INSTANCE.warn(this.category, message);
        }

        public void warn(String format, Object ... args) {
            INSTANCE.log(Level.WARN, this.category, String.format(format, args), null);
        }

        public void warn(String message, Throwable t) {
            INSTANCE.warn(this.category, message, t);
        }

        public void error(String message) {
            INSTANCE.error(this.category, message);
        }

        public void error(String format, Object ... args) {
            INSTANCE.log(Level.ERROR, this.category, String.format(format, args), null);
        }

        public void error(String message, Throwable t) {
            INSTANCE.error(this.category, message, t);
        }
    }

    public static enum Level {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3);

        private final int severity;

        private Level(int severity) {
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }
    }

    public static class LogEntry {
        private final LocalDateTime timestamp = LocalDateTime.now();
        private final Level level;
        private final String category;
        private final String message;
        private final Throwable throwable;

        public LogEntry(Level level, String category, String message, Throwable throwable) {
            this.level = level;
            this.category = category;
            this.message = message;
            this.throwable = throwable;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getCategory() {
            return this.category;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(TIMESTAMP_FORMAT.format(this.timestamp)).append("] ");
            sb.append('[').append(this.level.name()).append("] ");
            sb.append('[').append(this.category).append("] ");
            sb.append(this.message);
            if (this.throwable != null) {
                sb.append('\n');
                StringWriter sw = new StringWriter();
                this.throwable.printStackTrace(new PrintWriter(sw));
                sb.append(sw.toString());
            }
            return sb.toString();
        }
    }
}

