/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.model;

import com.example.vibe.core.model.ToolCall;
import java.util.Collections;
import java.util.List;

public class LlmResponse {
    public static final String FINISH_REASON_TOOL_USE = "tool_use";
    public static final String FINISH_REASON_STOP = "stop";
    private final String content;
    private final String model;
    private final Usage usage;
    private final String finishReason;
    private final List<ToolCall> toolCalls;
    private final String reasoningContent;

    public LlmResponse(String content, String model, Usage usage, String finishReason) {
        this(content, model, usage, finishReason, null);
    }

    public LlmResponse(String content, String model, Usage usage, String finishReason, List<ToolCall> toolCalls) {
        this(content, model, usage, finishReason, toolCalls, null);
    }

    public LlmResponse(String content, String model, Usage usage, String finishReason, List<ToolCall> toolCalls, String reasoningContent) {
        this.content = content != null ? content : "";
        this.model = model;
        this.usage = usage;
        this.finishReason = finishReason;
        this.toolCalls = toolCalls != null ? Collections.unmodifiableList(toolCalls) : Collections.emptyList();
        this.reasoningContent = reasoningContent;
    }

    public static LlmResponse of(String content) {
        return new LlmResponse(content, null, null, null);
    }

    public static LlmResponse withToolCalls(List<ToolCall> toolCalls) {
        return new LlmResponse(null, null, null, FINISH_REASON_TOOL_USE, toolCalls);
    }

    public String getContent() {
        return this.content;
    }

    public String getModel() {
        return this.model;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String getFinishReason() {
        return this.finishReason;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !this.toolCalls.isEmpty();
    }

    public boolean isToolUse() {
        return FINISH_REASON_TOOL_USE.equals(this.finishReason) || !this.toolCalls.isEmpty();
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public boolean hasReasoning() {
        return this.reasoningContent != null && !this.reasoningContent.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String content;
        private String model;
        private Usage usage;
        private String finishReason;
        private List<ToolCall> toolCalls;
        private String reasoningContent;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder finishReason(String finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public LlmResponse build() {
            return new LlmResponse(this.content, this.model, this.usage, this.finishReason, this.toolCalls, this.reasoningContent);
        }
    }

    public static class Usage {
        private final int promptTokens;
        private final int completionTokens;
        private final int totalTokens;

        public Usage(int promptTokens, int completionTokens, int totalTokens) {
            this.promptTokens = promptTokens;
            this.completionTokens = completionTokens;
            this.totalTokens = totalTokens;
        }

        public int getPromptTokens() {
            return this.promptTokens;
        }

        public int getCompletionTokens() {
            return this.completionTokens;
        }

        public int getTotalTokens() {
            return this.totalTokens;
        }
    }
}

