/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.model;

import com.example.vibe.core.model.ToolCall;
import java.util.Collections;
import java.util.List;

public class LlmStreamChunk {
    private final String content;
    private final boolean isComplete;
    private final String finishReason;
    private final String errorMessage;
    private final List<ToolCall> toolCalls;
    private final String reasoningContent;

    public LlmStreamChunk(String content, boolean isComplete, String finishReason, String errorMessage, List<ToolCall> toolCalls) {
        this(content, isComplete, finishReason, errorMessage, toolCalls, null);
    }

    public LlmStreamChunk(String content, boolean isComplete, String finishReason, String errorMessage, List<ToolCall> toolCalls, String reasoningContent) {
        this.content = content;
        this.isComplete = isComplete;
        this.finishReason = finishReason;
        this.errorMessage = errorMessage;
        this.toolCalls = toolCalls != null ? Collections.unmodifiableList(toolCalls) : Collections.emptyList();
        this.reasoningContent = reasoningContent;
    }

    public LlmStreamChunk(String content, boolean isComplete, String finishReason, String errorMessage) {
        this(content, isComplete, finishReason, errorMessage, null);
    }

    public LlmStreamChunk(String content, boolean isComplete, String finishReason) {
        this(content, isComplete, finishReason, null, null);
    }

    public static LlmStreamChunk content(String content) {
        return new LlmStreamChunk(content, false, null);
    }

    public static LlmStreamChunk complete(String finishReason) {
        return new LlmStreamChunk("", true, finishReason);
    }

    public static LlmStreamChunk error(String errorMessage) {
        return new LlmStreamChunk("", true, "error", errorMessage, null);
    }

    public static LlmStreamChunk toolCalls(List<ToolCall> toolCalls) {
        return new LlmStreamChunk("", false, null, null, toolCalls);
    }

    public static LlmStreamChunk reasoning(String reasoning) {
        return new LlmStreamChunk("", false, null, null, null, reasoning);
    }

    public String getContent() {
        return this.content;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public String getFinishReason() {
        return this.finishReason;
    }

    public boolean isError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !this.toolCalls.isEmpty();
    }

    public boolean isToolUse() {
        return !this.toolCalls.isEmpty() || "tool_use".equals(this.finishReason);
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public boolean hasReasoning() {
        return this.reasoningContent != null && !this.reasoningContent.isEmpty();
    }
}

