/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.permissions;

import com.example.vibe.core.permissions.PermissionDecision;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@FunctionalInterface
public interface IPermissionCallback {
    public CompletableFuture<PermissionResponse> requestPermission(PermissionRequest var1);

    public static class PermissionRequest {
        private final String toolName;
        private final String toolDescription;
        private final String action;
        private final String resource;
        private final Map<String, Object> context;
        private final boolean isDestructive;

        public PermissionRequest(String toolName, String toolDescription, String action, String resource, Map<String, Object> context, boolean isDestructive) {
            this.toolName = toolName;
            this.toolDescription = toolDescription;
            this.action = action;
            this.resource = resource;
            this.context = context;
            this.isDestructive = isDestructive;
        }

        public String getToolName() {
            return this.toolName;
        }

        public String getToolDescription() {
            return this.toolDescription;
        }

        public String getAction() {
            return this.action;
        }

        public String getResource() {
            return this.resource;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public boolean isDestructive() {
            return this.isDestructive;
        }

        public String toString() {
            return "PermissionRequest{tool='" + this.toolName + "', action='" + this.action + "', resource='" + this.resource + "', destructive=" + this.isDestructive + "}";
        }
    }

    public static class PermissionResponse {
        private final PermissionDecision decision;
        private final boolean rememberForSession;
        private final boolean rememberPermanently;

        private PermissionResponse(PermissionDecision decision, boolean rememberForSession, boolean rememberPermanently) {
            this.decision = decision;
            this.rememberForSession = rememberForSession;
            this.rememberPermanently = rememberPermanently;
        }

        public PermissionDecision getDecision() {
            return this.decision;
        }

        public boolean isRememberForSession() {
            return this.rememberForSession;
        }

        public boolean isRememberPermanently() {
            return this.rememberPermanently;
        }

        public static PermissionResponse allow() {
            return new PermissionResponse(PermissionDecision.ALLOW, false, false);
        }

        public static PermissionResponse allowForSession() {
            return new PermissionResponse(PermissionDecision.ALLOW, true, false);
        }

        public static PermissionResponse allowPermanently() {
            return new PermissionResponse(PermissionDecision.ALLOW, false, true);
        }

        public static PermissionResponse deny() {
            return new PermissionResponse(PermissionDecision.DENY, false, false);
        }

        public static PermissionResponse denyForSession() {
            return new PermissionResponse(PermissionDecision.DENY, true, false);
        }

        public static PermissionResponse denyPermanently() {
            return new PermissionResponse(PermissionDecision.DENY, false, true);
        }

        public String toString() {
            return "PermissionResponse{decision=" + String.valueOf((Object)this.decision) + ", rememberSession=" + this.rememberForSession + ", rememberPermanent=" + this.rememberPermanently + "}";
        }
    }
}

