/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider;

import com.example.vibe.core.http.HttpClientConfig;
import com.example.vibe.core.http.HttpClientFactory;
import com.example.vibe.core.http.HttpRequestBodies;
import com.example.vibe.core.internal.VibeCorePlugin;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.LlmProviderException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public abstract class AbstractLlmProvider
implements ILlmProvider {
    protected final Gson gson = new GsonBuilder().create();
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);

    protected IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("com.example.vibe.core");
    }

    protected int getRequestTimeout() {
        return this.getPreferences().getInt("requestTimeout", 60);
    }

    protected HttpClient getHttpClient() {
        HttpClientFactory factory;
        VibeCorePlugin plugin = VibeCorePlugin.getDefault();
        if (plugin != null && (factory = plugin.getHttpClientFactory()) != null) {
            return factory.getSharedClient();
        }
        return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
    }

    protected HttpClientConfig getHttpClientConfig() {
        VibeCorePlugin plugin = VibeCorePlugin.getDefault();
        if (plugin != null) {
            HttpClientFactory factory = plugin.getHttpClientFactory();
            return factory != null ? factory.getConfig() : null;
        }
        return null;
    }

    protected HttpRequest.Builder createPostRequest(String url) {
        return HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(this.getRequestTimeout())).header("Content-Type", "application/json");
    }

    protected HttpRequest.Builder createPostRequestWithBody(String url, String json) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(this.getRequestTimeout()));
        HttpClientConfig config = this.getHttpClientConfig();
        if (config != null) {
            return HttpRequestBodies.postJson(builder, json, config);
        }
        return HttpRequestBodies.postJsonUncompressed(builder, json);
    }

    protected CompletableFuture<HttpResponse<String>> sendAsync(HttpRequest request) {
        return this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    protected CompletableFuture<Void> sendAsyncStreaming(HttpRequest request, BiConsumer<String, Runnable> lineProcessor, Consumer<Throwable> errorHandler) {
        return ((CompletableFuture)this.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenAcceptAsync(response -> {
            block25: {
                if (!this.isSuccess(response.statusCode())) {
                    try {
                        Throwable throwable = null;
                        Object var5_10 = null;
                        try (InputStream is = (InputStream)response.body();){
                            String errorBody = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                            errorHandler.accept(new LlmProviderException("HTTP error: " + response.statusCode() + " - " + errorBody, null, response.statusCode(), null));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        errorHandler.accept(new LlmProviderException("HTTP error: " + response.statusCode(), (Throwable)e, response.statusCode(), null));
                    }
                    return;
                }
                try {
                    Throwable e = null;
                    Object var5_12 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.body(), StandardCharsets.UTF_8));){
                        String line;
                        boolean[] completed = new boolean[1];
                        Runnable completeCallback = () -> {
                            boolean bl = blArray[0] = true;
                        };
                        while (!completed[0] && !this.isCancelled() && (line = reader.readLine()) != null) {
                            lineProcessor.accept(line, completeCallback);
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    if (this.isCancelled()) break block25;
                    errorHandler.accept(new LlmProviderException("Failed to read stream response", e));
                }
            }
        })).exceptionally(ex -> {
            if (!this.isCancelled()) {
                errorHandler.accept((Throwable)ex);
            }
            return null;
        });
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    @Override
    public void cancel() {
        this.cancelled.set(true);
    }

    protected void resetCancelled() {
        this.cancelled.set(false);
    }

    protected boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void dispose() {
        this.cancel();
    }
}

