/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.config.LlmProviderConfigStore;
import java.util.Collections;
import java.util.List;

public final class LlmProviderRegistry {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(LlmProviderRegistry.class);
    private static LlmProviderRegistry instance;
    private volatile ILlmProvider backendProvider;
    private boolean initialized = false;
    private LlmProviderConfigStore configStore;

    private LlmProviderRegistry() {
    }

    public static synchronized LlmProviderRegistry getInstance() {
        if (instance == null) {
            instance = new LlmProviderRegistry();
        }
        return instance;
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        LOG.info("LLM Provider Registry initialized");
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setBackendProvider(ILlmProvider provider) {
        if (this.backendProvider != null) {
            this.backendProvider.dispose();
        }
        this.backendProvider = provider;
        LOG.info("Backend provider set: %s", provider != null ? provider.getDisplayName() : "null");
    }

    public ILlmProvider getActiveProvider() {
        return this.backendProvider;
    }

    public ILlmProvider getProvider(String id) {
        if (this.backendProvider != null && id != null && id.equals(this.backendProvider.getId())) {
            return this.backendProvider;
        }
        return null;
    }

    public List<ILlmProvider> getProviders() {
        if (this.backendProvider != null) {
            return Collections.singletonList(this.backendProvider);
        }
        return Collections.emptyList();
    }

    public LlmProviderConfigStore getConfigStore() {
        return this.configStore;
    }

    public synchronized void dispose() {
        if (this.backendProvider != null) {
            try {
                this.backendProvider.dispose();
            }
            catch (Exception e) {
                LOG.warn("Error disposing backend provider", e);
            }
            this.backendProvider = null;
        }
        this.initialized = false;
    }
}

