/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider.config;

import com.example.vibe.core.provider.config.ProviderType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class LlmProviderConfig {
    private String id;
    private String name;
    private ProviderType type;
    private String baseUrl;
    private String apiKey;
    private String model;
    private int maxTokens;
    private Map<String, String> customHeaders;
    private boolean streamingEnabled;

    public LlmProviderConfig() {
        this.id = UUID.randomUUID().toString();
        this.type = ProviderType.OPENAI_COMPATIBLE;
        this.maxTokens = 4096;
        this.customHeaders = new HashMap<String, String>();
        this.streamingEnabled = true;
    }

    public LlmProviderConfig(String id, String name, ProviderType type, String baseUrl, String apiKey, String model, int maxTokens) {
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.name = name;
        this.type = type != null ? type : ProviderType.OPENAI_COMPATIBLE;
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.model = model;
        this.maxTokens = maxTokens > 0 ? maxTokens : 4096;
        this.customHeaders = new HashMap<String, String>();
        this.streamingEnabled = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProviderType getType() {
        return this.type;
    }

    public void setType(ProviderType type) {
        this.type = type;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = this.normalizeUrl(baseUrl);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders != null ? customHeaders : new HashMap();
    }

    public boolean isStreamingEnabled() {
        return this.streamingEnabled;
    }

    public void setStreamingEnabled(boolean streamingEnabled) {
        this.streamingEnabled = streamingEnabled;
    }

    public boolean isConfigured() {
        if (this.name == null || this.name.trim().isEmpty()) {
            return false;
        }
        if (this.baseUrl == null || this.baseUrl.trim().isEmpty()) {
            return false;
        }
        if (this.model == null || this.model.trim().isEmpty()) {
            return false;
        }
        return this.type == ProviderType.OLLAMA || this.apiKey != null && !this.apiKey.trim().isEmpty();
    }

    public String getChatEndpointUrl() {
        if (this.baseUrl == null) {
            return null;
        }
        String base = this.normalizeUrl(this.baseUrl);
        String endpoint = this.type.getChatEndpoint();
        return base + endpoint;
    }

    public String getModelsEndpointUrl() {
        if (this.baseUrl == null || !this.type.supportsModelListing()) {
            return null;
        }
        String base = this.normalizeUrl(this.baseUrl);
        String endpoint = this.type.getModelsEndpoint();
        return base + endpoint;
    }

    private String normalizeUrl(String url) {
        if (url == null) {
            return null;
        }
        url = url.trim();
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public LlmProviderConfig copy() {
        LlmProviderConfig copy = new LlmProviderConfig();
        copy.id = this.id;
        copy.name = this.name;
        copy.type = this.type;
        copy.baseUrl = this.baseUrl;
        copy.apiKey = this.apiKey;
        copy.model = this.model;
        copy.maxTokens = this.maxTokens;
        copy.customHeaders = new HashMap<String, String>(this.customHeaders);
        copy.streamingEnabled = this.streamingEnabled;
        return copy;
    }

    public LlmProviderConfig copyWithNewId() {
        LlmProviderConfig copy = this.copy();
        copy.id = UUID.randomUUID().toString();
        copy.name = this.name + " (Copy)";
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LlmProviderConfig other = (LlmProviderConfig)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "LlmProviderConfig[" + this.name + " (" + String.valueOf((Object)this.type) + "), model=" + this.model + "]";
    }
}

