/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider.config;

import com.example.vibe.core.internal.VibeCorePlugin;
import com.example.vibe.core.provider.config.LlmProviderConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class LlmProviderConfigStore {
    private static final int CURRENT_CONFIG_VERSION = 1;
    private static LlmProviderConfigStore instance;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private List<LlmProviderConfig> cachedConfigs;
    private String cachedActiveProviderId;

    private LlmProviderConfigStore() {
    }

    public static synchronized LlmProviderConfigStore getInstance() {
        if (instance == null) {
            instance = new LlmProviderConfigStore();
        }
        return instance;
    }

    public List<LlmProviderConfig> getProviders() {
        if (this.cachedConfigs == null) {
            this.loadFromPreferences();
        }
        return Collections.unmodifiableList(this.cachedConfigs);
    }

    public Optional<LlmProviderConfig> getProvider(String id) {
        return this.getProviders().stream().filter(p -> p.getId().equals(id)).findFirst();
    }

    public Optional<LlmProviderConfig> getActiveProvider() {
        String activeId = this.getActiveProviderId();
        if (activeId == null || activeId.isEmpty()) {
            return this.getProviders().stream().filter(LlmProviderConfig::isConfigured).findFirst();
        }
        return this.getProvider(activeId);
    }

    public String getActiveProviderId() {
        if (this.cachedActiveProviderId == null) {
            this.loadFromPreferences();
        }
        return this.cachedActiveProviderId;
    }

    public void setActiveProviderId(String id) {
        this.cachedActiveProviderId = id;
        this.saveToPreferences();
    }

    public void addProvider(LlmProviderConfig config) {
        if (this.cachedConfigs == null) {
            this.loadFromPreferences();
        }
        this.cachedConfigs.add(config);
        this.saveToPreferences();
    }

    public void updateProvider(LlmProviderConfig config) {
        if (this.cachedConfigs == null) {
            this.loadFromPreferences();
        }
        int i = 0;
        while (i < this.cachedConfigs.size()) {
            if (this.cachedConfigs.get(i).getId().equals(config.getId())) {
                this.cachedConfigs.set(i, config);
                break;
            }
            ++i;
        }
        this.saveToPreferences();
    }

    public void removeProvider(String id) {
        if (this.cachedConfigs == null) {
            this.loadFromPreferences();
        }
        this.cachedConfigs.removeIf(p -> p.getId().equals(id));
        if (id.equals(this.cachedActiveProviderId)) {
            this.cachedActiveProviderId = null;
        }
        this.saveToPreferences();
    }

    public void saveProviders(List<LlmProviderConfig> providers) {
        this.cachedConfigs = new ArrayList<LlmProviderConfig>(providers);
        this.saveToPreferences();
    }

    public void refresh() {
        this.cachedConfigs = null;
        this.cachedActiveProviderId = null;
        this.loadFromPreferences();
    }

    private void loadFromPreferences() {
        IEclipsePreferences prefs = this.getPreferences();
        String json = prefs.get("llm.providers", "[]");
        try {
            this.cachedConfigs = new ArrayList<LlmProviderConfig>();
            JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
            for (JsonElement element : array) {
                LlmProviderConfig config = (LlmProviderConfig)this.gson.fromJson(element, LlmProviderConfig.class);
                if (config == null) continue;
                this.cachedConfigs.add(config);
            }
        }
        catch (Exception e) {
            VibeCorePlugin.logWarn("Failed to parse provider configs: " + e.getMessage());
            this.cachedConfigs = new ArrayList<LlmProviderConfig>();
        }
        this.cachedActiveProviderId = prefs.get("llm.activeProviderId", "");
    }

    private void saveToPreferences() {
        IEclipsePreferences prefs = this.getPreferences();
        try {
            String json = this.gson.toJson(this.cachedConfigs);
            prefs.put("llm.providers", json);
            prefs.put("llm.activeProviderId", this.cachedActiveProviderId != null ? this.cachedActiveProviderId : "");
            prefs.putInt("llm.configVersion", 1);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            VibeCorePlugin.logError("Failed to save provider configs", e);
        }
    }

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("com.example.vibe.core");
    }

    public boolean hasConfiguredProviders() {
        return this.getProviders().stream().anyMatch(LlmProviderConfig::isConfigured);
    }

    public int getStoredConfigVersion() {
        return this.getPreferences().getInt("llm.configVersion", 0);
    }
}

