/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.provider.config;

public enum ProviderType {
    OPENAI_COMPATIBLE("openai_compatible", "OpenAI Compatible"),
    ANTHROPIC("anthropic", "Anthropic (Claude)"),
    OLLAMA("ollama", "Ollama (Local)");

    private final String id;
    private final String displayName;

    private ProviderType(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean supportsModelListing() {
        return true;
    }

    public String getModelsEndpoint() {
        switch (this) {
            case OPENAI_COMPATIBLE: {
                return "/models";
            }
            case ANTHROPIC: {
                return "/v1/models";
            }
            case OLLAMA: {
                return "/api/tags";
            }
        }
        return "/models";
    }

    public String getChatEndpoint() {
        switch (this) {
            case OPENAI_COMPATIBLE: {
                return "/chat/completions";
            }
            case ANTHROPIC: {
                return "/messages";
            }
            case OLLAMA: {
                return "/api/chat";
            }
        }
        return "/chat/completions";
    }

    public static ProviderType fromId(String id) {
        ProviderType[] providerTypeArray = ProviderType.values();
        int n = providerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderType type = providerTypeArray[n2];
            if (type.id.equals(id)) {
                return type;
            }
            ++n2;
        }
        return OPENAI_COMPATIBLE;
    }
}

