/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.review;

import com.example.vibe.core.review.IssueSeverity;
import java.util.Objects;

public class BslReviewIssue {
    public static final int REPORT_THRESHOLD = 80;
    private final String ruleId;
    private final String description;
    private final int confidence;
    private final IssueSeverity severity;
    private final String filePath;
    private final int lineNumber;
    private final int endLineNumber;
    private final String codeSnippet;
    private final String suggestedFix;
    private final String rationale;

    private BslReviewIssue(Builder builder) {
        this.ruleId = builder.ruleId;
        this.description = Objects.requireNonNull(builder.description, "description");
        this.confidence = Math.max(0, Math.min(100, builder.confidence));
        this.severity = builder.severity != null ? builder.severity : IssueSeverity.fromConfidence(this.confidence);
        this.filePath = builder.filePath;
        this.lineNumber = builder.lineNumber;
        this.endLineNumber = builder.endLineNumber > 0 ? builder.endLineNumber : builder.lineNumber;
        this.codeSnippet = builder.codeSnippet;
        this.suggestedFix = builder.suggestedFix;
        this.rationale = builder.rationale;
    }

    public boolean shouldReport() {
        return this.confidence >= 80;
    }

    public boolean isCritical() {
        return this.confidence >= 90;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public String getCodeSnippet() {
        return this.codeSnippet;
    }

    public String getSuggestedFix() {
        return this.suggestedFix;
    }

    public String getRationale() {
        return this.rationale;
    }

    public String getLocation() {
        if (this.filePath == null) {
            return "unknown";
        }
        if (this.lineNumber == this.endLineNumber || this.endLineNumber <= 0) {
            return String.format("%s:%d", this.filePath, this.lineNumber);
        }
        return String.format("%s:%d-%d", this.filePath, this.lineNumber, this.endLineNumber);
    }

    public String toDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.severity.getDisplayName()).append("]");
        sb.append(" (").append(this.confidence).append("%) ");
        sb.append(this.description);
        if (this.filePath != null && this.lineNumber > 0) {
            sb.append("\n  \u2192 ").append(this.getLocation());
        }
        if (this.suggestedFix != null && !this.suggestedFix.isEmpty()) {
            sb.append("\n  \u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: ").append(this.suggestedFix);
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("BslReviewIssue[%s, confidence=%d, %s]", this.ruleId != null ? this.ruleId : "no-rule", this.confidence, this.getLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ruleId;
        private String description;
        private int confidence = 50;
        private IssueSeverity severity;
        private String filePath;
        private int lineNumber;
        private int endLineNumber;
        private String codeSnippet;
        private String suggestedFix;
        private String rationale;

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder confidence(int confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder endLineNumber(int endLineNumber) {
            this.endLineNumber = endLineNumber;
            return this;
        }

        public Builder lineRange(int start, int end) {
            this.lineNumber = start;
            this.endLineNumber = end;
            return this;
        }

        public Builder codeSnippet(String codeSnippet) {
            this.codeSnippet = codeSnippet;
            return this;
        }

        public Builder suggestedFix(String suggestedFix) {
            this.suggestedFix = suggestedFix;
            return this;
        }

        public Builder rationale(String rationale) {
            this.rationale = rationale;
            return this;
        }

        public BslReviewIssue build() {
            return new BslReviewIssue(this);
        }
    }
}

