/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.review;

import com.example.vibe.core.review.BslReviewIssue;
import com.example.vibe.core.review.IssueSeverity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class BslReviewResult {
    private final String filePath;
    private final List<BslReviewIssue> allIssues;
    private final long analysisTimeMs;

    public BslReviewResult(String filePath, List<BslReviewIssue> issues, long analysisTimeMs) {
        this.filePath = filePath;
        this.allIssues = new ArrayList<BslReviewIssue>(issues);
        this.analysisTimeMs = analysisTimeMs;
    }

    public List<BslReviewIssue> getAllIssues() {
        return new ArrayList<BslReviewIssue>(this.allIssues);
    }

    public List<BslReviewIssue> getReportableIssues() {
        return this.allIssues.stream().filter(BslReviewIssue::shouldReport).sorted(Comparator.comparingInt(BslReviewIssue::getConfidence).reversed()).collect(Collectors.toList());
    }

    public List<BslReviewIssue> getCriticalIssues() {
        return this.allIssues.stream().filter(BslReviewIssue::isCritical).sorted(Comparator.comparingInt(BslReviewIssue::getConfidence).reversed()).collect(Collectors.toList());
    }

    public List<BslReviewIssue> getIssuesWithConfidence(int minConfidence) {
        return this.allIssues.stream().filter(i -> i.getConfidence() >= minConfidence).sorted(Comparator.comparingInt(BslReviewIssue::getConfidence).reversed()).collect(Collectors.toList());
    }

    public List<BslReviewIssue> getIssuesBySeverity(IssueSeverity severity) {
        return this.allIssues.stream().filter(i -> i.getSeverity() == severity).collect(Collectors.toList());
    }

    public boolean hasReportableIssues() {
        return this.allIssues.stream().anyMatch(BslReviewIssue::shouldReport);
    }

    public boolean hasCriticalIssues() {
        return this.allIssues.stream().anyMatch(BslReviewIssue::isCritical);
    }

    public int getTotalCount() {
        return this.allIssues.size();
    }

    public int getReportableCount() {
        return (int)this.allIssues.stream().filter(BslReviewIssue::shouldReport).count();
    }

    public int getCriticalCount() {
        return (int)this.allIssues.stream().filter(BslReviewIssue::isCritical).count();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getAnalysisTimeMs() {
        return this.analysisTimeMs;
    }

    public String getSummary() {
        int reportable = this.getReportableCount();
        int critical = this.getCriticalCount();
        if (reportable == 0) {
            return String.format("\u2705 \u041f\u0440\u043e\u0431\u043b\u0435\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e (\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e \u0437\u0430 %d \u043c\u0441)", this.analysisTimeMs);
        }
        StringBuilder sb = new StringBuilder();
        if (critical > 0) {
            sb.append(String.format("\ud83d\udd34 \u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445: %d  ", critical));
        }
        sb.append(String.format("\u26a0\ufe0f \u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c: %d (\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e \u0437\u0430 %d \u043c\u0441)", reportable, this.analysisTimeMs));
        return sb.toString();
    }

    public String toReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("## \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u0434\u0430\n\n");
        sb.append("**\u0424\u0430\u0439\u043b:** ").append(this.filePath != null ? this.filePath : "unknown").append("\n");
        sb.append("**\u0421\u0442\u0430\u0442\u0443\u0441:** ").append(this.getSummary()).append("\n\n");
        List<BslReviewIssue> reportable = this.getReportableIssues();
        if (reportable.isEmpty()) {
            sb.append("\u041f\u0440\u043e\u0431\u043b\u0435\u043c, \u0442\u0440\u0435\u0431\u0443\u044e\u0449\u0438\u0445 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u044f, \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e.\n");
            return sb.toString();
        }
        List<BslReviewIssue> critical = reportable.stream().filter(BslReviewIssue::isCritical).toList();
        List<BslReviewIssue> warnings = reportable.stream().filter(i -> !i.isCritical()).toList();
        if (!critical.isEmpty()) {
            sb.append("### \ud83d\udd34 \u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b\n\n");
            for (BslReviewIssue issue : critical) {
                this.appendIssue(sb, issue);
            }
        }
        if (!warnings.isEmpty()) {
            sb.append("### \u26a0\ufe0f \u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\n\n");
            for (BslReviewIssue issue : warnings) {
                this.appendIssue(sb, issue);
            }
        }
        return sb.toString();
    }

    private void appendIssue(StringBuilder sb, BslReviewIssue issue) {
        sb.append("- **").append(issue.getDescription()).append("**");
        sb.append(" (").append(issue.getConfidence()).append("%)\n");
        if (issue.getFilePath() != null && issue.getLineNumber() > 0) {
            sb.append("  - \u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435: `").append(issue.getLocation()).append("`\n");
        }
        if (issue.getCodeSnippet() != null && !issue.getCodeSnippet().isEmpty()) {
            sb.append("  - \u041a\u043e\u0434: `").append(issue.getCodeSnippet()).append("`\n");
        }
        if (issue.getSuggestedFix() != null && !issue.getSuggestedFix().isEmpty()) {
            sb.append("  - \u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: ").append(issue.getSuggestedFix()).append("\n");
        }
        sb.append("\n");
    }

    public String toString() {
        return String.format("BslReviewResult[file=%s, total=%d, reportable=%d, critical=%d]", this.filePath, this.getTotalCount(), this.getReportableCount(), this.getCriticalCount());
    }
}

