/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.review;

import com.example.vibe.core.review.BslReviewIssue;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BslSilentFailureHunter {
    private static final List<FailurePattern> PATTERNS = List.of(new FailurePattern("bsl.empty-exception", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s*;", "\u041f\u0443\u0441\u0442\u043e\u0439 \u0431\u043b\u043e\u043a \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 - \u043e\u0448\u0438\u0431\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430", "\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u043e\u0448\u0438\u0431\u043a\u0438: \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435, \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", 95), new FailurePattern("bsl.exception-no-handler", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s+\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438", "\u0411\u043b\u043e\u043a \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0434\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438", "\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438() \u0438\u043b\u0438 \u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u044b\u0448\u0435", 92), new FailurePattern("bsl.empty-rethrow", "\u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s*;", "\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0431\u0435\u0437 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0442\u0435\u0440\u044f\u0435\u0442 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0441 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u043c: \u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438\";", 88), new FailurePattern("bsl.generic-exception-handler", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430[\\s\\S]{1,500}?\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s+\u0421\u043e\u043e\u0431\u0449\u0438\u0442\u044c\\s*\\(", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0421\u043e\u043e\u0431\u0449\u0438\u0442\u044c() \u0432 \u0431\u043b\u043e\u043a\u0435 \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 - \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043c\u043e\u0436\u0435\u0442 \u043d\u0435 \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438() \u0434\u043b\u044f \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0432\u044b\u0432\u043e\u0434\u0438\u0442\u0435 \u043e\u0448\u0438\u0431\u043a\u0443 \u0447\u0435\u0440\u0435\u0437 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 UI \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c", 75), new FailurePattern("bsl.empty-log-message", "\u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438\\s*\\([^,]*,\\s*[^,]*,\\s*\"\"", "\u0417\u0430\u043f\u0438\u0441\u044c \u0432 \u0436\u0443\u0440\u043d\u0430\u043b \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441 \u043f\u0443\u0441\u0442\u044b\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435", "\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043e\u043f\u0438\u0441\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0441 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u043c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", 85), new FailurePattern("bsl.try-without-exception", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430\\s+[^\u0418]*\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438", "\u0411\u043b\u043e\u043a \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0431\u0435\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", "\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0431\u043b\u043e\u043a \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a", 80), new FailurePattern("bsl.ignored-return-value", "\\b\u041d\u0430\u0447\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e\\s*\\(\\s*\\)\\s*;[\\s\\S]{1,200}?(?!\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e)", "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0430\u0447\u0430\u0442\u0430, \u043d\u043e \u043d\u0435\u0442 \u044f\u0432\u043d\u043e\u0439 \u0444\u0438\u043a\u0441\u0430\u0446\u0438\u0438 \u0438\u043b\u0438 \u043e\u0442\u043c\u0435\u043d\u044b \u0432 \u0431\u043b\u0438\u0437\u043a\u043e\u043c \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435", "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c \u0447\u0442\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e() \u0438\u043b\u0438 \u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e()", 70), new FailurePattern("bsl.exception-only-return", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s+\u0412\u043e\u0437\u0432\u0440\u0430\u0442\\s*(\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e|\u041b\u043e\u0436\u044c|0|\"\")?\\s*;\\s*\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438", "\u0411\u043b\u043e\u043a \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0431\u0435\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0448\u0438\u0431\u043a\u0438", "\u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0435\u0440\u0435\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u043c: \u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438()", 85), new FailurePattern("bsl.suppressed-error", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\\s+\u0415\u0441\u043b\u0438\\s+.*\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435\u041e\u0448\u0438\u0431\u043a\u0438\\s*\\(\\s*\\).*\u0422\u043e\u0433\u0434\u0430", "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0442\u0435\u043a\u0441\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0431\u0435\u0437 \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f - \u043c\u043e\u0436\u0435\u0442 \u0441\u043a\u0440\u044b\u0442\u044c \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0435 \u043e\u0448\u0438\u0431\u043a\u0438", "\u041b\u043e\u0433\u0438\u0440\u0443\u0439\u0442\u0435 \u0432\u0441\u0435 \u043e\u0448\u0438\u0431\u043a\u0438, \u0434\u0430\u0436\u0435 \u0435\u0441\u043b\u0438 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u043e\u0441\u043e\u0431\u044b\u043c \u043e\u0431\u0440\u0430\u0437\u043e\u043c", 72));

    public List<BslReviewIssue> analyze(String code, String filePath) {
        ArrayList<BslReviewIssue> issues = new ArrayList<BslReviewIssue>();
        if (code == null || code.isEmpty()) {
            return issues;
        }
        for (FailurePattern fp : PATTERNS) {
            Matcher matcher = fp.pattern.matcher(code);
            while (matcher.find()) {
                int lineNumber = this.countLines(code, matcher.start());
                String snippet = this.extractSnippet(code, matcher.start(), matcher.end());
                int adjustedConfidence = this.adjustConfidence(fp.baseConfidence, code, matcher);
                BslReviewIssue issue = BslReviewIssue.builder().ruleId(fp.ruleId).description(fp.description).confidence(adjustedConfidence).filePath(filePath).lineNumber(lineNumber).codeSnippet(snippet).suggestedFix(fp.suggestion).rationale("Silent failures make debugging difficult and hide problems from users").build();
                issues.add(issue);
            }
        }
        return issues;
    }

    public List<BslReviewIssue> analyzeAndFilter(String code, String filePath) {
        return this.analyze(code, filePath).stream().filter(BslReviewIssue::shouldReport).toList();
    }

    private int adjustConfidence(int baseConfidence, String code, Matcher matcher) {
        int end;
        int adjustment = 0;
        int start = Math.max(0, matcher.start() - 200);
        String context = code.substring(start, end = Math.min(code.length(), matcher.end() + 200));
        if (context.contains("\u0417\u0430\u043f\u0438\u0441\u044c\u0416\u0443\u0440\u043d\u0430\u043b\u0430\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438")) {
            adjustment -= 15;
        }
        if (context.contains("// TODO") || context.contains("// FIXME")) {
            adjustment -= 10;
        }
        if (code.contains("\u0422\u0435\u0441\u0442") || code.contains("Test")) {
            adjustment -= 20;
        }
        return Math.max(0, Math.min(100, baseConfidence + adjustment));
    }

    private int countLines(String code, int position) {
        int lines = 1;
        int i = 0;
        while (i < position && i < code.length()) {
            if (code.charAt(i) == '\n') {
                ++lines;
            }
            ++i;
        }
        return lines;
    }

    private String extractSnippet(String code, int start, int end) {
        int snippetStart = start;
        while (snippetStart > 0 && code.charAt(snippetStart - 1) != '\n') {
            --snippetStart;
        }
        int snippetEnd = end;
        while (snippetEnd < code.length() && code.charAt(snippetEnd) != '\n') {
            ++snippetEnd;
        }
        Object snippet = code.substring(snippetStart, snippetEnd).trim();
        if (((String)snippet).length() > 200) {
            snippet = ((String)snippet).substring(0, 197) + "...";
        }
        return snippet;
    }

    public static List<String> getRuleIds() {
        return PATTERNS.stream().map(p -> p.ruleId).toList();
    }

    private static class FailurePattern {
        final String ruleId;
        final Pattern pattern;
        final String description;
        final String suggestion;
        final int baseConfidence;

        FailurePattern(String ruleId, String regex, String description, String suggestion, int baseConfidence) {
            this.ruleId = ruleId;
            this.pattern = Pattern.compile(regex, 10);
            this.description = description;
            this.suggestion = suggestion;
            this.baseConfidence = baseConfidence;
        }
    }
}

