/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.session;

import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.session.SessionMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Session {
    private final String id;
    private String title;
    private String projectPath;
    private String projectName;
    private SessionStatus status;
    private final Instant createdAt;
    private Instant updatedAt;
    private final List<SessionMessage> messages;
    private String systemPrompt;
    private String agentProfile;
    private int totalTokens;

    public Session() {
        this.id = UUID.randomUUID().toString();
        this.updatedAt = this.createdAt = Instant.now();
        this.status = SessionStatus.ACTIVE;
        this.messages = new ArrayList<SessionMessage>();
        this.totalTokens = 0;
    }

    public Session(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.updatedAt = this.createdAt = Instant.now();
        this.status = SessionStatus.ACTIVE;
        this.messages = new ArrayList<SessionMessage>();
        this.totalTokens = 0;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.touch();
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
        this.touch();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.touch();
    }

    public SessionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SessionStatus status) {
        this.status = status;
        this.touch();
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public List<SessionMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessage(SessionMessage message) {
        Objects.requireNonNull(message, "message");
        this.messages.add(message);
        this.touch();
        if (this.title == null && message.getType() == SessionMessage.MessageType.USER) {
            this.title = this.generateTitle(message.getContent());
        }
    }

    public void addMessages(List<SessionMessage> newMessages) {
        for (SessionMessage msg : newMessages) {
            this.addMessage(msg);
        }
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public SessionMessage getLastMessage() {
        return this.messages.isEmpty() ? null : this.messages.get(this.messages.size() - 1);
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        this.touch();
    }

    public String getAgentProfile() {
        return this.agentProfile;
    }

    public void setAgentProfile(String agentProfile) {
        this.agentProfile = agentProfile;
        this.touch();
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public void setTotalTokens(int totalTokens) {
        this.totalTokens = totalTokens;
    }

    public void addTokens(int tokens) {
        this.totalTokens += tokens;
    }

    public List<LlmMessage> toLlmMessages() {
        ArrayList<LlmMessage> result = new ArrayList<LlmMessage>();
        if (this.systemPrompt != null && !this.systemPrompt.isEmpty()) {
            result.add(LlmMessage.system(this.systemPrompt));
        }
        for (SessionMessage msg : this.messages) {
            switch (msg.getType()) {
                case USER: {
                    result.add(LlmMessage.user(msg.getContent()));
                    break;
                }
                case ASSISTANT: {
                    if (msg.hasToolCalls()) {
                        result.add(LlmMessage.assistantWithToolCalls(msg.getContent(), msg.getToolCalls()));
                        break;
                    }
                    result.add(LlmMessage.assistant(msg.getContent()));
                    break;
                }
                case SYSTEM: {
                    result.add(LlmMessage.system(msg.getContent()));
                    break;
                }
                case TOOL_RESULT: {
                    result.add(LlmMessage.toolResult(msg.getToolCallId(), msg.getContent()));
                    break;
                }
            }
        }
        return result;
    }

    public void clearMessages() {
        this.messages.clear();
        this.touch();
    }

    public boolean hasProject() {
        return this.projectPath != null && !this.projectPath.isEmpty();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    private void touch() {
        this.updatedAt = Instant.now();
    }

    private String generateTitle(String content) {
        if (content == null || content.isEmpty()) {
            return "\u041d\u043e\u0432\u0430\u044f \u0441\u0435\u0441\u0441\u0438\u044f";
        }
        Object title = content.split("\n")[0];
        if (((String)title).length() > 50) {
            title = ((String)title).substring(0, 47) + "...";
        }
        return title;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String toString() {
        return "Session{id='" + this.id + "', title='" + this.title + "', project='" + this.projectName + "', messages=" + this.messages.size() + ", status=" + String.valueOf((Object)this.status) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.id, session.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum SessionStatus {
        ACTIVE,
        PAUSED,
        COMPLETED,
        ARCHIVED;

    }
}

