/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.state;

public enum VibeState {
    IDLE("idle", "Ready", "icons/vibe_ready.png"),
    COMPLETING("completing", "Completing...", "icons/vibe_working.png"),
    PROCESSING("processing", "Processing...", "icons/vibe_working.png"),
    STREAMING("streaming", "Streaming...", "icons/vibe_streaming.png"),
    INDEXING("indexing", "Indexing...", "icons/vibe_indexing.png"),
    ERROR("error", "Error", "icons/vibe_error.png"),
    DISABLED("disabled", "Disabled", "icons/vibe_disabled.png"),
    NOT_CONFIGURED("not_configured", "Not Configured", "icons/vibe_warning.png"),
    BUDGET_EXCEEDED("budget_exceeded", "Budget Exceeded", "icons/vibe_warning.png");

    private final String id;
    private final String displayName;
    private final String iconPath;

    private VibeState(String id, String displayName, String iconPath) {
        this.id = id;
        this.displayName = displayName;
        this.iconPath = iconPath;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public boolean isActive() {
        return this == COMPLETING || this == PROCESSING || this == STREAMING || this == INDEXING;
    }

    public boolean isError() {
        return this == ERROR || this == NOT_CONFIGURED || this == BUDGET_EXCEEDED;
    }

    public boolean isReady() {
        return this == IDLE;
    }

    public static VibeState fromId(String id) {
        if (id == null) {
            return IDLE;
        }
        VibeState[] vibeStateArray = VibeState.values();
        int n = vibeStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            VibeState state = vibeStateArray[n2];
            if (state.id.equals(id)) {
                return state;
            }
            ++n2;
        }
        return IDLE;
    }
}

