/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.state;

import com.example.vibe.core.internal.VibeCorePlugin;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.state.VibeState;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class VibeStateService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(VibeStateService.class);
    private static VibeStateService instance;
    private final AtomicReference<VibeState> currentState = new AtomicReference<VibeState>(VibeState.IDLE);
    private final AtomicReference<String> statusMessage = new AtomicReference<String>("");
    private final AtomicReference<String> errorMessage = new AtomicReference<Object>(null);
    private final List<StateChangeListener> listeners = new CopyOnWriteArrayList<StateChangeListener>();

    private VibeStateService() {
    }

    public static synchronized VibeStateService getInstance() {
        if (instance == null) {
            instance = new VibeStateService();
        }
        return instance;
    }

    public VibeState getState() {
        return this.currentState.get();
    }

    public String getStatusMessage() {
        return this.statusMessage.get();
    }

    public String getErrorMessage() {
        return this.errorMessage.get();
    }

    public void setIdle() {
        this.setState(VibeState.IDLE, "Ready");
        this.errorMessage.set(null);
    }

    public void setCompleting(String message) {
        this.setState(VibeState.COMPLETING, message != null ? message : "Completing...");
    }

    public void setProcessing(String message) {
        this.setState(VibeState.PROCESSING, message != null ? message : "Processing...");
    }

    public void setStreaming(String message) {
        this.setState(VibeState.STREAMING, message != null ? message : "Streaming...");
    }

    public void setIndexing(String message) {
        this.setState(VibeState.INDEXING, message != null ? message : "Indexing...");
    }

    public void setError(String errorMsg) {
        this.errorMessage.set(errorMsg);
        this.setState(VibeState.ERROR, "Error");
        LOG.warn("Vibe state error: %s", errorMsg);
    }

    public void setDisabled() {
        this.setState(VibeState.DISABLED, "Disabled");
    }

    public void setNotConfigured(String message) {
        this.errorMessage.set(message);
        this.setState(VibeState.NOT_CONFIGURED, message != null ? message : "Not Configured");
    }

    public void setBudgetExceeded(String message) {
        this.errorMessage.set(message);
        this.setState(VibeState.BUDGET_EXCEEDED, message != null ? message : "Budget Exceeded");
        LOG.warn("Vibe state budget exceeded: %s", message);
    }

    private void setState(VibeState state, String message) {
        VibeState oldState = this.currentState.getAndSet(state);
        this.statusMessage.set(message);
        if (oldState != state) {
            LOG.debug("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e: %s -> %s (%s)", new Object[]{oldState, state, message});
            this.notifyListeners(oldState, state, message);
        }
    }

    private void notifyListeners(VibeState oldState, VibeState newState, String message) {
        for (StateChangeListener listener : this.listeners) {
            try {
                listener.onStateChanged(oldState, newState, message);
            }
            catch (Exception e) {
                VibeCorePlugin.logWarn("Error notifying state listener", e);
            }
        }
    }

    public void addListener(StateChangeListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(StateChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isActive() {
        return this.currentState.get().isActive();
    }

    public boolean isReady() {
        return this.currentState.get().isReady();
    }

    public boolean hasError() {
        return this.currentState.get().isError();
    }

    @FunctionalInterface
    public static interface StateChangeListener {
        public void onStateChanged(VibeState var1, VibeState var2, String var3);
    }
}

