/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.edit.EditBlock;
import com.example.vibe.core.edit.FileEditApplier;
import com.example.vibe.core.edit.FuzzyMatcher;
import com.example.vibe.core.edit.MatchLocation;
import com.example.vibe.core.edit.MatchResult;
import com.example.vibe.core.edit.SearchReplaceFormat;
import com.example.vibe.core.logging.LogSanitizer;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class EditFileTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(EditFileTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Path to the file (workspace-relative)\"\n        },\n        \"content\": {\n            \"type\": \"string\",\n            \"description\": \"New content for the file (replaces entire file)\"\n        },\n        \"old_text\": {\n            \"type\": \"string\",\n            \"description\": \"Text to search for and replace (for partial edits). Supports fuzzy matching.\"\n        },\n        \"new_text\": {\n            \"type\": \"string\",\n            \"description\": \"Replacement text (used with old_text)\"\n        },\n        \"edits\": {\n            \"type\": \"string\",\n            \"description\": \"SEARCH/REPLACE blocks in format: <<<<<<< SEARCH\\nold code\\n=======\\nnew code\\n>>>>>>> REPLACE. Supports multiple blocks.\"\n        },\n        \"create\": {\n            \"type\": \"boolean\",\n            \"description\": \"Create file if it doesn't exist (default: false)\"\n        }\n    },\n    \"required\": [\"path\"]\n}\n";
    private final FuzzyMatcher fuzzyMatcher = new FuzzyMatcher();
    private final SearchReplaceFormat searchReplaceFormat = new SearchReplaceFormat();
    private final FileEditApplier fileEditApplier = new FileEditApplier(this.fuzzyMatcher, this.searchReplaceFormat);

    @Override
    public String getName() {
        return "edit_file";
    }

    @Override
    public String getDescription() {
        return "Edit a file in the workspace. Can replace entire file content or perform search-and-replace operations. Can also create new files. \u26a0\ufe0f \u041d\u0415 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u043b\u044f \u0421\u041e\u0417\u0414\u0410\u041d\u0418\u042f \u043d\u043e\u0432\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421 (.mdo \u0444\u0430\u0439\u043b\u043e\u0432)! \u0414\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432, \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 create_metadata.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public boolean requiresConfirmation() {
        return false;
    }

    @Override
    public boolean isDestructive() {
        return false;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            long startTime = System.currentTimeMillis();
            String pathStr = (String)parameters.get("path");
            if (pathStr == null || pathStr.isEmpty()) {
                LOG.warn("edit_file: \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 path");
                return ToolResult.failure("Path parameter is required");
            }
            String content = (String)parameters.get("content");
            String oldText = (String)parameters.get("old_text");
            String newText = (String)parameters.get("new_text");
            String edits = (String)parameters.get("edits");
            boolean create = Boolean.TRUE.equals(parameters.get("create"));
            LOG.debug("edit_file: path=%s, hasContent=%b, hasOldText=%b, hasEdits=%b, create=%b", LogSanitizer.truncatePath(pathStr), content != null, oldText != null, edits != null, create);
            try {
                ToolResult result;
                String normalizedPath = this.normalizePath(pathStr);
                IFile file = this.findWorkspaceFile(normalizedPath);
                if (file == null || !file.exists()) {
                    if (create && content != null) {
                        if (normalizedPath.endsWith(".mdo") && !normalizedPath.contains("Configuration.mdo")) {
                            LOG.warn("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                            LOG.warn("[EDIT_FILE] \u2717 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d\u041e: \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u0442\u044c .mdo \u0444\u0430\u0439\u043b \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e!");
                            LOG.warn("[EDIT_FILE] \u041f\u0443\u0442\u044c: %s", pathStr);
                            LOG.warn("[EDIT_FILE] \u0420\u0430\u0437\u043c\u0435\u0440 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430: %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", content != null ? content.length() : 0);
                            LOG.warn("[EDIT_FILE] \u0420\u0415\u0428\u0415\u041d\u0418\u0415: \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 create_metadata \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445");
                            LOG.warn("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                            return ToolResult.failure("\u274c \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c .mdo \u0444\u0430\u0439\u043b\u044b \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0447\u0435\u0440\u0435\u0437 edit_file!\n\n\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 **create_metadata** \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445.\n\u042d\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u0447\u0442\u043e\u0431\u044b \u043e\u0431\u044a\u0435\u043a\u0442 \u0431\u044b\u043b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 Configuration.mdo.\n\n\u041f\u0440\u0438\u043c\u0435\u0440: create_metadata(kind=\"Catalog\", name=\"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\", synonym=\"\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b\")");
                        }
                        LOG.info("edit_file: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 %s", pathStr);
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        file = root.getFile(Path.fromPortableString((String)normalizedPath.replace('\\', '/')));
                        ToolResult result2 = this.createFile(file, content);
                        LOG.debug("edit_file: \u0444\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u0437\u0430 %s", LogSanitizer.formatDuration(System.currentTimeMillis() - startTime));
                        return result2;
                    }
                    LOG.warn("edit_file: \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", pathStr);
                    return ToolResult.failure("File not found: " + pathStr + ". Use create=true to create a new file.");
                }
                if (content != null) {
                    LOG.info("edit_file: \u0437\u0430\u043c\u0435\u043d\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 %s (%d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432)", file.getFullPath(), content.length());
                    result = this.replaceContent(file, content);
                } else if (edits != null && !edits.isEmpty()) {
                    LOG.info("edit_file: SEARCH/REPLACE \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 %s", file.getFullPath());
                    result = this.applySearchReplaceEdits(file, edits);
                } else if (oldText != null && newText != null) {
                    LOG.info("edit_file: fuzzy search-replace \u0432 %s (oldText=%d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432)", file.getFullPath(), oldText.length());
                    result = this.fuzzySearchAndReplace(file, oldText, newText);
                } else {
                    LOG.warn("edit_file: \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                    return ToolResult.failure("Either 'content', 'edits', or both 'old_text' and 'new_text' are required");
                }
                LOG.debug("edit_file: \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e \u0437\u0430 %s, success=%b", LogSanitizer.formatDuration(System.currentTimeMillis() - startTime), result.isSuccess());
                return result;
            }
            catch (CoreException e) {
                LOG.error("edit_file: \u043e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f %s: %s", pathStr, e.getMessage());
                return ToolResult.failure("Error editing file: " + e.getMessage());
            }
        });
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        return normalized.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private IFile findWorkspaceFile(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LOG.debug("findWorkspaceFile: \u0438\u0449\u0435\u043c \u0444\u0430\u0439\u043b \u043f\u043e \u043f\u0443\u0442\u0438 '%s'", path);
        LOG.debug("findWorkspaceFile: workspace root = %s", root.getLocation());
        try {
            IResource resource = root.findMember(path);
            if (resource instanceof IFile && resource.exists()) {
                LOG.debug("findWorkspaceFile: \u043d\u0430\u0439\u0434\u0435\u043d \u0447\u0435\u0440\u0435\u0437 findMember: %s -> %s", resource.getFullPath(), resource.getLocation());
                return (IFile)resource;
            }
        }
        catch (Exception e) {
            LOG.debug("findWorkspaceFile: findMember failed: %s", e.getMessage());
        }
        try {
            IFile file = root.getFile(Path.fromOSString((String)path));
            if (file.exists()) {
                LOG.debug("findWorkspaceFile: \u043d\u0430\u0439\u0434\u0435\u043d \u0447\u0435\u0440\u0435\u0437 fromOSString: %s -> %s", file.getFullPath(), file.getLocation());
                return file;
            }
        }
        catch (Exception e) {
            LOG.debug("findWorkspaceFile: fromOSString failed: %s", e.getMessage());
        }
        try {
            String forwardSlashPath = path.replace('\\', '/');
            IResource resource = root.findMember(forwardSlashPath);
            if (resource instanceof IFile && resource.exists()) {
                LOG.debug("findWorkspaceFile: \u043d\u0430\u0439\u0434\u0435\u043d \u0447\u0435\u0440\u0435\u0437 forward slashes: %s -> %s", resource.getFullPath(), resource.getLocation());
                return (IFile)resource;
            }
        }
        catch (Exception e) {
            LOG.debug("findWorkspaceFile: forward slashes failed: %s", e.getMessage());
        }
        LOG.warn("findWorkspaceFile: \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", path);
        return null;
    }

    private ToolResult createFile(IFile file, String content) throws CoreException {
        this.createParentFolders(file);
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        file.create((InputStream)stream, true, (IProgressMonitor)new NullProgressMonitor());
        return ToolResult.success("Created file: " + file.getFullPath().toString(), ToolResult.ToolResultType.CONFIRMATION);
    }

    private void createParentFolders(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        Stack<IFolder> foldersToCreate = new Stack<IFolder>();
        while (parent instanceof IFolder && !parent.exists()) {
            foldersToCreate.push((IFolder)parent);
            parent = parent.getParent();
        }
        while (!foldersToCreate.isEmpty()) {
            ((IFolder)foldersToCreate.pop()).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private ToolResult replaceContent(IFile file, String content) throws CoreException {
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        file.setContents((InputStream)stream, 3, (IProgressMonitor)new NullProgressMonitor());
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        LOG.info("edit_file: \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u043e \u0432 %s (%d \u0431\u0430\u0439\u0442)", file.getFullPath(), content.length());
        return ToolResult.success("Updated file: " + file.getFullPath().toString() + " (location: " + String.valueOf(file.getLocation()) + ")", ToolResult.ToolResultType.CONFIRMATION);
    }

    private ToolResult applySearchReplaceEdits(IFile file, String edits) throws CoreException {
        String currentContent = this.readFileContent(file);
        if (currentContent == null) {
            return ToolResult.failure("Error reading file content");
        }
        List<EditBlock> blocks = this.searchReplaceFormat.parse(edits);
        if (blocks.isEmpty()) {
            return ToolResult.failure("No valid SEARCH/REPLACE blocks found in 'edits' parameter. Use format: <<<<<<< SEARCH\\nold code\\n=======\\nnew code\\n>>>>>>> REPLACE");
        }
        List<String> errors = this.searchReplaceFormat.validate(blocks);
        if (!errors.isEmpty()) {
            return ToolResult.failure("Invalid edit blocks: " + String.join((CharSequence)"; ", errors));
        }
        FileEditApplier.ApplyResult applyResult = this.fileEditApplier.apply(currentContent, blocks);
        if (!applyResult.allSuccessful()) {
            String feedback = applyResult.getFailureFeedback();
            LOG.warn("edit_file: \u043d\u0435 \u0432\u0441\u0435 \u0431\u043b\u043e\u043a\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u044b: %s", applyResult.getSummary());
            return ToolResult.failure(feedback);
        }
        Charset charset = this.getFileCharset(file);
        ByteArrayInputStream stream = new ByteArrayInputStream(applyResult.afterContent().getBytes(charset));
        file.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
        return ToolResult.success(applyResult.getSummary() + " \u0432: " + file.getFullPath().toString(), ToolResult.ToolResultType.CONFIRMATION);
    }

    private ToolResult fuzzySearchAndReplace(IFile file, String oldText, String newText) throws CoreException {
        String currentContent = this.readFileContent(file);
        if (currentContent == null) {
            return ToolResult.failure("Error reading file content");
        }
        MatchResult matchResult = this.fuzzyMatcher.findMatch(oldText, currentContent);
        if (!matchResult.isSuccess()) {
            String feedback = matchResult.generateFeedback();
            LOG.warn("edit_file: fuzzy match \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            return ToolResult.failure(feedback);
        }
        MatchLocation location = matchResult.getLocation().orElseThrow();
        String before = currentContent.substring(0, location.getStartOffset());
        String after = currentContent.substring(location.getEndOffset());
        String newContent = before + newText + after;
        Charset charset = this.getFileCharset(file);
        ByteArrayInputStream stream = new ByteArrayInputStream(newContent.getBytes(charset));
        file.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
        String strategyInfo = matchResult.getStrategy() != null ? " (\u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u044f: " + matchResult.getStrategy().getDisplayName() + ")" : "";
        return ToolResult.success("\u0417\u0430\u043c\u0435\u043d\u0435\u043d\u043e \u0432 \u0441\u0442\u0440\u043e\u043a\u0430\u0445 " + location.getStartLine() + "-" + location.getEndLine() + strategyInfo + " \u0432: " + file.getFullPath().toString(), ToolResult.ToolResultType.CONFIRMATION);
    }

    private String readFileContent(IFile file) {
        Charset charset = this.getFileCharset(file);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), charset));){
                String line;
                StringBuilder sb = new StringBuilder();
                boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (!firstLine) {
                        sb.append("\n");
                    }
                    if (firstLine && line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    sb.append(line);
                    firstLine = false;
                }
                return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            LOG.error("Error reading file %s: %s", file.getFullPath(), e.getMessage());
            return null;
        }
    }

    @Deprecated
    private ToolResult searchAndReplace(IFile file, String oldText, String newText) throws CoreException {
        String currentContent;
        Charset charset = this.getFileCharset(file);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), charset));){
                String line;
                StringBuilder sb = new StringBuilder();
                boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (!firstLine) {
                        sb.append(System.lineSeparator());
                    }
                    if (firstLine && line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    sb.append(line);
                    firstLine = false;
                }
                currentContent = sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return ToolResult.failure("Error reading file: " + e.getMessage());
        }
        if (!currentContent.contains(oldText)) {
            return ToolResult.failure("Text not found in file: " + oldText);
        }
        int count = 0;
        int index = 0;
        while ((index = currentContent.indexOf(oldText, index)) != -1) {
            ++count;
            index += oldText.length();
        }
        String newContent = currentContent.replace(oldText, newText);
        ByteArrayInputStream stream = new ByteArrayInputStream(newContent.getBytes(charset));
        file.setContents((InputStream)stream, true, true, (IProgressMonitor)new NullProgressMonitor());
        return ToolResult.success("Replaced " + count + " occurrence(s) in: " + file.getFullPath().toString(), ToolResult.ToolResultType.CONFIRMATION);
    }

    private Charset getFileCharset(IFile file) {
        try {
            String charsetName = file.getCharset();
            if (charsetName != null) {
                return Charset.forName(charsetName);
            }
        }
        catch (IllegalArgumentException | CoreException throwable) {}
        return StandardCharsets.UTF_8;
    }
}

