/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class GlobTool
implements ITool {
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"pattern\": {\n            \"type\": \"string\",\n            \"description\": \"Glob pattern (e.g., '**/*.java', 'src/**/*.bsl')\"\n        },\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Directory to search in (project name or workspace-relative path, default: workspace root)\"\n        },\n        \"max_results\": {\n            \"type\": \"integer\",\n            \"description\": \"Maximum number of results (default: 100, max: 500)\"\n        },\n        \"include_hidden\": {\n            \"type\": \"boolean\",\n            \"description\": \"Include hidden files and directories (default: false)\"\n        }\n    },\n    \"required\": [\"pattern\"]\n}\n";
    private static final int DEFAULT_MAX_RESULTS = 100;
    private static final int MAX_RESULTS_LIMIT = 500;

    @Override
    public String getName() {
        return "glob";
    }

    @Override
    public String getDescription() {
        return "\u041d\u0430\u0445\u043e\u0434\u0438\u0442 \u0444\u0430\u0439\u043b\u044b \u043f\u043e glob \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u0443. \u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 ** \u0434\u043b\u044f \u0440\u0435\u043a\u0443\u0440\u0441\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u0438\u0441\u043a\u0430, * \u0434\u043b\u044f \u043b\u044e\u0431\u044b\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432, ? \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0433\u043e \u0441\u0438\u043c\u0432\u043e\u043b\u0430. \u041f\u0440\u0438\u043c\u0435\u0440: **/*.java";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            String pattern = (String)parameters.get("pattern");
            if (pattern == null || pattern.isEmpty()) {
                return ToolResult.failure("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 pattern \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d");
            }
            int maxResults = 100;
            Object maxParam = parameters.get("max_results");
            if (maxParam instanceof Number) {
                maxResults = Math.min(((Number)maxParam).intValue(), 500);
            }
            boolean includeHidden = Boolean.TRUE.equals(parameters.get("include_hidden"));
            Path baseDir = this.resolveBaseDirectory((String)parameters.get("path"));
            if (baseDir == null || !Files.exists(baseDir, new LinkOption[0])) {
                return ToolResult.failure("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            }
            try {
                List<Path> matches = this.findFiles(baseDir, pattern, maxResults, includeHidden);
                return this.formatResult(matches, pattern, baseDir, maxResults);
            }
            catch (IOException e) {
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430: " + e.getMessage());
            }
        });
    }

    private List<Path> findFiles(final Path baseDir, String pattern, final int maxResults, final boolean includeHidden) throws IOException {
        String normalizedPattern = this.normalizePattern(pattern);
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + normalizedPattern);
        final ArrayList<Path> matches = new ArrayList<Path>();
        final AtomicInteger count = new AtomicInteger(0);
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (!includeHidden && GlobTool.this.isHidden(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String name = dir.getFileName().toString();
                if (GlobTool.this.shouldSkipDirectory(name)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!includeHidden && GlobTool.this.isHidden(file)) {
                    return FileVisitResult.CONTINUE;
                }
                Path relativePath = baseDir.relativize(file);
                if (matcher.matches(relativePath)) {
                    matches.add(file);
                    if (count.incrementAndGet() >= maxResults) {
                        return FileVisitResult.TERMINATE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        matches.sort(Comparator.comparing(this::getModificationTime).reversed());
        return matches;
    }

    private String normalizePattern(String pattern) {
        String normalized = pattern.replace('\\', '/');
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return normalized;
    }

    private boolean isHidden(Path path) {
        try {
            return Files.isHidden(path) || path.getFileName().toString().startsWith(".");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean shouldSkipDirectory(String name) {
        return name.equals("node_modules") || name.equals(".git") || name.equals(".svn") || name.equals(".hg") || name.equals("target") || name.equals("build") || name.equals("bin") || name.equals(".metadata") || name.equals(".settings");
    }

    private long getModificationTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    private Path resolveBaseDirectory(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path workspacePath = Paths.get(root.getLocation().toOSString(), new String[0]);
        if (path == null || path.isEmpty()) {
            return workspacePath;
        }
        IProject project = root.getProject(path);
        if (project.exists() && project.getLocation() != null) {
            return Paths.get(project.getLocation().toOSString(), new String[0]);
        }
        Path resolved = workspacePath.resolve(path);
        if (Files.exists(resolved, new LinkOption[0]) && Files.isDirectory(resolved, new LinkOption[0])) {
            return resolved;
        }
        return workspacePath;
    }

    private ToolResult formatResult(List<Path> matches, String pattern, Path baseDir, int maxResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("**\u041f\u0430\u0442\u0442\u0435\u0440\u043d:** `").append(pattern).append("`\n");
        sb.append("**\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f:** `").append(baseDir).append("`\n");
        sb.append("**\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0444\u0430\u0439\u043b\u043e\u0432:** ").append(matches.size());
        if (matches.size() >= maxResults) {
            sb.append(" (\u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 ").append(maxResults).append(")");
        }
        sb.append("\n\n");
        if (matches.isEmpty()) {
            sb.append("*\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b*");
        } else {
            sb.append("```\n");
            for (Path match : matches) {
                Path relativePath = baseDir.relativize(match);
                sb.append(relativePath.toString().replace('\\', '/')).append("\n");
            }
            sb.append("```");
        }
        return ToolResult.success(sb.toString(), ToolResult.ToolResultType.TEXT);
    }
}

