/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class GrepTool
implements ITool {
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"pattern\": {\n            \"type\": \"string\",\n            \"description\": \"Search pattern (text or regex)\"\n        },\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"Directory to search in (default: entire workspace)\"\n        },\n        \"file_pattern\": {\n            \"type\": \"string\",\n            \"description\": \"File name pattern to filter (e.g., '*.bsl')\"\n        },\n        \"regex\": {\n            \"type\": \"boolean\",\n            \"description\": \"Treat pattern as regex (default: false)\"\n        },\n        \"case_sensitive\": {\n            \"type\": \"boolean\",\n            \"description\": \"Case-sensitive search (default: false)\"\n        },\n        \"context_lines\": {\n            \"type\": \"integer\",\n            \"description\": \"Lines of context around matches (default: 0)\"\n        }\n    },\n    \"required\": [\"pattern\"]\n}\n";
    private static final int MAX_RESULTS = 50;

    @Override
    public String getName() {
        return "grep";
    }

    @Override
    public String getDescription() {
        return "Search for text patterns in files. Supports plain text and regex patterns.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            Pattern searchPattern;
            String patternStr = (String)parameters.get("pattern");
            if (patternStr == null || patternStr.isEmpty()) {
                return ToolResult.failure("Pattern parameter is required");
            }
            String path = (String)parameters.get("path");
            String filePattern = (String)parameters.get("file_pattern");
            boolean useRegex = Boolean.TRUE.equals(parameters.get("regex"));
            boolean caseSensitive = Boolean.TRUE.equals(parameters.get("case_sensitive"));
            int contextLines = 0;
            Object contextParam = parameters.get("context_lines");
            if (contextParam instanceof Number) {
                contextLines = ((Number)contextParam).intValue();
            }
            try {
                int flags;
                int n = flags = caseSensitive ? 0 : 2;
                searchPattern = useRegex ? Pattern.compile(patternStr, flags) : Pattern.compile(Pattern.quote(patternStr), flags);
            }
            catch (PatternSyntaxException e) {
                return ToolResult.failure("Invalid regex pattern: " + e.getMessage());
            }
            try {
                IWorkspaceRoot searchRoot;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                if (path != null && !path.isEmpty()) {
                    String normalizedPath = this.normalizePath(path);
                    IResource resource = this.findWorkspaceResource(normalizedPath);
                    if (!(resource instanceof IContainer)) return ToolResult.failure("Path not found or not a directory: " + path);
                    searchRoot = (IContainer)resource;
                } else {
                    searchRoot = root;
                }
                ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
                this.searchInContainer((IContainer)searchRoot, searchPattern, filePattern, contextLines, matches);
                return this.formatResults(patternStr, matches);
            }
            catch (CoreException e) {
                return ToolResult.failure("Error searching: " + e.getMessage());
            }
        });
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        return normalized.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private IResource findWorkspaceResource(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(path);
        if (resource != null && resource.exists()) {
            return resource;
        }
        String forwardSlashPath = path.replace('\\', '/');
        resource = root.findMember(forwardSlashPath);
        if (resource != null && resource.exists()) {
            return resource;
        }
        return null;
    }

    private void searchInContainer(IContainer container, Pattern pattern, String filePattern, int contextLines, List<SearchMatch> matches) throws CoreException {
        IResource[] members;
        if (matches.size() >= 50) {
            return;
        }
        if (container instanceof IWorkspaceRoot) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ((IWorkspaceRoot)container).getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    this.searchInContainer((IContainer)project, pattern, filePattern, contextLines, matches);
                }
                ++n2;
            }
            return;
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n3 = 0;
        while (n3 < n) {
            IFile file;
            IResource member = iResourceArray[n3];
            if (matches.size() >= 50) break;
            if (member instanceof IContainer) {
                this.searchInContainer((IContainer)member, pattern, filePattern, contextLines, matches);
            } else if (member instanceof IFile && this.matchesFilePattern((file = (IFile)member).getName(), filePattern)) {
                this.searchInFile(file, pattern, contextLines, matches);
            }
            ++n3;
        }
    }

    private boolean matchesFilePattern(String name, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return name.endsWith(".bsl") || name.endsWith(".os") || name.endsWith(".java") || name.endsWith(".xml");
        }
        String regex = pattern.replace(".", "\\.").replace("*", ".*").replace("?", ".");
        return name.matches(regex);
    }

    private void searchInFile(IFile file, Pattern pattern, int contextLines, List<SearchMatch> matches) throws CoreException {
        if (matches.size() >= 50) {
            return;
        }
        Charset charset = this.getFileCharset(file);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), charset));){
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (firstLine && line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    firstLine = false;
                    lines.add(line);
                }
                int i = 0;
                while (i < lines.size() && matches.size() < 50) {
                    Matcher matcher = pattern.matcher((CharSequence)lines.get(i));
                    if (matcher.find()) {
                        int startContext = Math.max(0, i - contextLines);
                        int endContext = Math.min(lines.size() - 1, i + contextLines);
                        StringBuilder contextBuilder = new StringBuilder();
                        int j = startContext;
                        while (j <= endContext) {
                            String prefix = j == i ? ">" : " ";
                            contextBuilder.append(String.format("%s%4d | %s%n", prefix, j + 1, lines.get(j)));
                            ++j;
                        }
                        matches.add(new SearchMatch(file.getFullPath().toString(), i + 1, ((String)lines.get(i)).trim(), contextBuilder.toString().trim()));
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    private Charset getFileCharset(IFile file) {
        try {
            String charsetName = file.getCharset();
            if (charsetName != null) {
                return Charset.forName(charsetName);
            }
        }
        catch (IllegalArgumentException | CoreException throwable) {}
        return StandardCharsets.UTF_8;
    }

    private ToolResult formatResults(String pattern, List<SearchMatch> matches) {
        StringBuilder sb = new StringBuilder();
        sb.append("**Search results for:** `").append(pattern).append("`\n");
        sb.append("**Found:** ").append(matches.size());
        if (matches.size() == 50) {
            sb.append("+ (limited)");
        }
        sb.append(" matches\n\n");
        for (SearchMatch match : matches) {
            sb.append("**").append(match.filePath).append(":").append(match.lineNumber).append("**\n");
            sb.append("```\n").append(match.context).append("\n```\n\n");
        }
        return ToolResult.success(sb.toString(), ToolResult.ToolResultType.SEARCH_RESULTS);
    }

    private static class SearchMatch {
        final String filePath;
        final int lineNumber;
        final String matchLine;
        final String context;

        SearchMatch(String filePath, int lineNumber, String matchLine, String context) {
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.matchLine = matchLine;
            this.context = context;
        }
    }
}

