/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.agent.AgentConfig;
import com.example.vibe.core.agent.AgentResult;
import com.example.vibe.core.agent.AgentRunner;
import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.profiles.AgentProfile;
import com.example.vibe.core.agent.profiles.AgentProfileRegistry;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.LlmProviderRegistry;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolRegistry;
import com.example.vibe.core.tools.ToolResult;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class TaskTool
implements ITool {
    private static final String PLUGIN_ID = "com.example.vibe.core";
    private static final ILog LOG = Platform.getLog(TaskTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"prompt\": {\n            \"type\": \"string\",\n            \"description\": \"Task description for the subagent\"\n        },\n        \"profile\": {\n            \"type\": \"string\",\n            \"enum\": [\"explore\", \"plan\", \"build\"],\n            \"description\": \"Agent profile: explore (fast search), plan (analysis), build (full access)\"\n        },\n        \"description\": {\n            \"type\": \"string\",\n            \"description\": \"Short description of what the subagent will do (3-5 words)\"\n        }\n    },\n    \"required\": [\"prompt\"]\n}\n";
    private static final int MAX_DEPTH = 3;
    private static final int DEFAULT_TIMEOUT_SECONDS = 180;
    private static final ThreadLocal<AtomicInteger> currentDepth = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private final ToolRegistry toolRegistry;

    public TaskTool(ToolRegistry toolRegistry) {
        this.toolRegistry = toolRegistry;
    }

    @Override
    public String getName() {
        return "task";
    }

    @Override
    public String getDescription() {
        return "\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0439 \u0437\u0430\u0434\u0430\u0447\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u043b\u044f \u0434\u0435\u043b\u0435\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u0434\u0430 (explore), \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043b\u0430\u043d\u043e\u0432 (plan) \u0438\u043b\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u0447 (build).";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicInteger depth;
            String description;
            String prompt = (String)parameters.get("prompt");
            if (prompt == null || prompt.isEmpty()) {
                return ToolResult.failure("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 prompt \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d");
            }
            String profileId = (String)parameters.get("profile");
            if (profileId == null || profileId.isEmpty()) {
                profileId = "explore";
            }
            if ((description = (String)parameters.get("description")) == null || description.isEmpty()) {
                description = "\u041f\u043e\u0434\u0437\u0430\u0434\u0430\u0447\u0430";
            }
            if ((depth = currentDepth.get()).get() >= 3) {
                return ToolResult.failure("\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u043e\u0432 (3)");
            }
            try {
                depth.incrementAndGet();
                ToolResult toolResult = this.executeSubagent(prompt, profileId, description);
                return toolResult;
            }
            finally {
                depth.decrementAndGet();
            }
        });
    }

    private ToolResult executeSubagent(String prompt, String profileId, String description) {
        this.logInfo("\u0417\u0430\u043f\u0443\u0441\u043a \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u0430 [" + profileId + "]: " + description);
        ILlmProvider provider = LlmProviderRegistry.getInstance().getActiveProvider();
        if (provider == null || !provider.isConfigured()) {
            return ToolResult.failure("LLM \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        AgentProfile profile = AgentProfileRegistry.getInstance().getProfile(profileId).orElse(AgentProfileRegistry.getInstance().getExploreProfile());
        AgentConfig.Builder configBuilder = AgentConfig.builder().maxSteps(Math.min(profile.getMaxSteps(), 15)).timeoutMs(180000L).systemPromptAddition(this.buildSubagentSystemPrompt(profile, description)).profileName(profileId);
        for (String tool : profile.getAllowedTools()) {
            if ("task".equals(tool) && currentDepth.get().get() >= 2) continue;
            configBuilder.enableTool(tool);
        }
        AgentConfig config = configBuilder.build();
        AgentRunner subagent = new AgentRunner(provider, this.toolRegistry, profile.getSystemPromptAddition());
        try {
            CompletableFuture<AgentResult> future = subagent.run(prompt, config);
            AgentResult result = future.get(190L, TimeUnit.SECONDS);
            ToolResult toolResult = this.formatResult(result, description, profileId);
            return toolResult;
        }
        catch (Exception e) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u0430", e);
            subagent.cancel();
            ToolResult toolResult = ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u0430: " + e.getMessage());
            return toolResult;
        }
        finally {
            subagent.dispose();
        }
    }

    private String buildSubagentSystemPrompt(AgentProfile profile, String description) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u0422\u044b - \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442, \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u044e\u0449\u0438\u0439 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0443\u044e \u0437\u0430\u0434\u0430\u0447\u0443.\n\n");
        sb.append("**\u0417\u0430\u0434\u0430\u0447\u0430:** ").append(description).append("\n\n");
        sb.append("**\u041f\u0440\u043e\u0444\u0438\u043b\u044c:** ").append(profile.getName()).append("\n\n");
        sb.append("**\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438:**\n");
        sb.append("1. \u0412\u044b\u043f\u043e\u043b\u043d\u0438 \u0437\u0430\u0434\u0430\u0447\u0443 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\n");
        sb.append("2. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u043c\u0438\u043d\u0438\u043c\u0443\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0445 \u0448\u0430\u0433\u043e\u0432\n");
        sb.append("3. \u0412\u0435\u0440\u043d\u0438 \u043a\u0440\u0430\u0442\u043a\u0438\u0439, \u043d\u043e \u043f\u043e\u043b\u043d\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\n");
        sb.append("4. \u041d\u0435 \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0439 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e - \u0440\u0430\u0431\u043e\u0442\u0430\u0439 \u0441 \u0442\u0435\u043c, \u0447\u0442\u043e \u0435\u0441\u0442\u044c\n");
        if (profile.isReadOnly()) {
            sb.append("\n**\u0412\u0410\u0416\u041d\u041e:** \u0423 \u0442\u0435\u0431\u044f \u0440\u0435\u0436\u0438\u043c \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u0435\u043d\u0438\u0435. ");
            sb.append("\u041d\u0435 \u043f\u044b\u0442\u0430\u0439\u0441\u044f \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0444\u0430\u0439\u043b\u044b \u0438\u043b\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u044b.\n");
        }
        return sb.toString();
    }

    private ToolResult formatResult(AgentResult result, String description, String profileId) {
        StringBuilder sb = new StringBuilder();
        sb.append("## \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u043e\u0434\u0430\u0433\u0435\u043d\u0442\u0430\n\n");
        sb.append("**\u0417\u0430\u0434\u0430\u0447\u0430:** ").append(description).append("\n");
        sb.append("**\u041f\u0440\u043e\u0444\u0438\u043b\u044c:** ").append(profileId).append("\n");
        sb.append("**\u0421\u0442\u0430\u0442\u0443\u0441:** ").append(this.formatStatus(result.getFinalState())).append("\n");
        sb.append("**\u0428\u0430\u0433\u043e\u0432:** ").append(result.getStepsExecuted()).append("\n");
        sb.append("**\u0412\u044b\u0437\u043e\u0432\u043e\u0432 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432:** ").append(result.getToolCallsExecuted()).append("\n");
        sb.append("**\u0412\u0440\u0435\u043c\u044f:** ").append(result.getExecutionTimeMs()).append(" \u043c\u0441\n\n");
        if (result.isSuccess() && result.getFinalResponse() != null) {
            sb.append("### \u041e\u0442\u0432\u0435\u0442\n\n");
            sb.append(this.truncateResponse(result.getFinalResponse()));
        } else if (result.isError()) {
            sb.append("### \u041e\u0448\u0438\u0431\u043a\u0430\n\n");
            sb.append(result.getErrorMessage());
        } else if (result.isCancelled()) {
            sb.append("*\u0417\u0430\u0434\u0430\u0447\u0430 \u0431\u044b\u043b\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430*");
        }
        this.logInfo("\u041f\u043e\u0434\u0430\u0433\u0435\u043d\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d: " + String.valueOf((Object)result.getFinalState()) + ", \u0448\u0430\u0433\u043e\u0432: " + result.getStepsExecuted());
        if (result.isSuccess()) {
            return ToolResult.success(sb.toString(), ToolResult.ToolResultType.TEXT);
        }
        return ToolResult.failure(sb.toString());
    }

    private String formatStatus(AgentState state) {
        switch (state) {
            case COMPLETED: {
                return "\u2713 \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
            }
            case CANCELLED: {
                return "\u2298 \u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e";
            }
            case ERROR: {
                return "\u2717 \u041e\u0448\u0438\u0431\u043a\u0430";
            }
        }
        return state.toString();
    }

    private String truncateResponse(String response) {
        if (response.length() > 10000) {
            return response.substring(0, 10000) + "\n\n*... (\u043e\u0442\u0432\u0435\u0442 \u043e\u0431\u0440\u0435\u0437\u0430\u043d, " + response.length() + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432)*";
        }
        return response;
    }

    private void logInfo(String message) {
        LOG.log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    private void logError(String message, Throwable error) {
        LOG.log((IStatus)new Status(4, PLUGIN_ID, message, error));
    }
}

