/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.model.ToolCall;
import com.example.vibe.core.model.ToolDefinition;
import com.example.vibe.core.tools.EditFileTool;
import com.example.vibe.core.tools.GlobTool;
import com.example.vibe.core.tools.GrepTool;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ListFilesTool;
import com.example.vibe.core.tools.ReadFileTool;
import com.example.vibe.core.tools.ToolLogger;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.WriteTool;
import com.example.vibe.core.tools.metadata.AddAttributeTool;
import com.example.vibe.core.tools.metadata.AddDimensionTool;
import com.example.vibe.core.tools.metadata.AddEnumValueTool;
import com.example.vibe.core.tools.metadata.AddFormTool;
import com.example.vibe.core.tools.metadata.AddResourceTool;
import com.example.vibe.core.tools.metadata.AddTabularSectionTool;
import com.example.vibe.core.tools.metadata.CreateMetadataTool;
import com.example.vibe.core.tools.metadata.GetMetadataTool;
import com.example.vibe.core.tools.metadata.ListMetadataTool;
import com.example.vibe.core.tools.metadata.MetadataReferencesTool;
import com.example.vibe.core.tools.metadata.ModifySubsystemTool;
import com.example.vibe.core.tools.metadata.OpenModuleTool;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ToolRegistry {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ToolRegistry.class);
    private static ToolRegistry instance;
    private final Map<String, ITool> tools = new HashMap<String, ITool>();
    private final Map<String, ITool> dynamicTools = new ConcurrentHashMap<String, ITool>();
    private final Gson gson = new Gson();

    private ToolRegistry() {
        this.registerDefaultTools();
        LOG.info("ToolRegistry initialized with %d tools", this.tools.size());
    }

    public static synchronized ToolRegistry getInstance() {
        if (instance == null) {
            instance = new ToolRegistry();
        }
        return instance;
    }

    private void registerDefaultTools() {
        this.register(new ListMetadataTool());
        this.register(new GetMetadataTool());
        this.register(new OpenModuleTool());
        this.register(new MetadataReferencesTool());
        this.register(new CreateMetadataTool());
        this.register(new AddAttributeTool());
        this.register(new AddEnumValueTool());
        this.register(new AddFormTool());
        this.register(new AddTabularSectionTool());
        this.register(new AddDimensionTool());
        this.register(new AddResourceTool());
        this.register(new ModifySubsystemTool());
        this.register(new ReadFileTool());
        this.register(new ListFilesTool());
        this.register(new EditFileTool());
        this.register(new WriteTool());
        this.register(new GrepTool());
        this.register(new GlobTool());
    }

    public void register(ITool tool) {
        this.tools.put(tool.getName(), tool);
    }

    public void unregister(String name) {
        this.tools.remove(name);
    }

    public void registerDynamicTool(ITool tool) {
        this.dynamicTools.put(tool.getName(), tool);
        LOG.debug("Registered dynamic tool: %s", tool.getName());
    }

    public void unregisterDynamicTool(String name) {
        this.dynamicTools.remove(name);
        LOG.debug("Unregistered dynamic tool: %s", name);
    }

    public void unregisterToolsByPrefix(String prefix) {
        List<String> toRemove = this.dynamicTools.keySet().stream().filter(name -> name.startsWith(prefix)).collect(Collectors.toList());
        toRemove.forEach(this.dynamicTools::remove);
        if (!toRemove.isEmpty()) {
            LOG.debug("Unregistered %d dynamic tools with prefix: %s", toRemove.size(), prefix);
        }
    }

    public ITool getTool(String name) {
        ITool tool = this.tools.get(name);
        if (tool == null) {
            tool = this.dynamicTools.get(name);
        }
        return tool;
    }

    public List<ITool> getAllTools() {
        LinkedHashMap<String, ITool> allTools = new LinkedHashMap<String, ITool>();
        allTools.putAll(this.dynamicTools);
        allTools.putAll(this.tools);
        return Collections.unmodifiableList(new ArrayList(allTools.values()));
    }

    public List<ToolDefinition> getToolDefinitions() {
        return this.getAllTools().stream().map(tool -> new ToolDefinition(tool.getName(), tool.getDescription(), tool.getParameterSchema())).collect(Collectors.toList());
    }

    public CompletableFuture<ToolResult> execute(ToolCall toolCall) {
        LOG.debug("Executing tool: %s with args: %s", toolCall.getName(), toolCall.getArguments());
        ToolLogger toolLogger = ToolLogger.getInstance();
        ITool tool = this.getTool(toolCall.getName());
        if (tool == null) {
            LOG.error("Unknown tool: %s (checked %d built-in and %d dynamic tools)", toolCall.getName(), this.tools.size(), this.dynamicTools.size());
            ToolResult failResult = ToolResult.failure("Unknown tool: " + toolCall.getName());
            toolLogger.logToolCallResult(-1, toolCall.getName(), failResult, 0L);
            return CompletableFuture.completedFuture(failResult);
        }
        try {
            Map<String, Object> parameters = this.parseArguments(toolCall.getArguments());
            LOG.debug("Parsed parameters: %s", parameters);
            int callId = toolLogger.logToolCallStart(toolCall.getName(), parameters);
            long startTime = System.currentTimeMillis();
            return ((CompletableFuture)tool.execute(parameters).thenApply(result -> {
                long duration = System.currentTimeMillis() - startTime;
                toolLogger.logToolCallResult(callId, toolCall.getName(), (ToolResult)result, duration);
                if (result.isSuccess()) {
                    LOG.debug("Tool %s completed in %d ms, result length: %d", toolCall.getName(), duration, result.getContent() != null ? result.getContent().length() : 0);
                } else {
                    LOG.warn("Tool %s failed in %d ms: %s", toolCall.getName(), duration, result.getErrorMessage());
                }
                return result;
            })).exceptionally(error -> {
                long duration = System.currentTimeMillis() - startTime;
                toolLogger.logToolCallError(callId, toolCall.getName(), (Throwable)error, duration);
                LOG.error("Tool %s threw exception in %d ms: %s", toolCall.getName(), duration, error.getMessage());
                return ToolResult.failure("Exception: " + error.getMessage());
            });
        }
        catch (Exception e) {
            LOG.error("Error executing tool %s: %s", toolCall.getName(), e.getMessage());
            ToolResult failResult = ToolResult.failure("Error executing tool: " + e.getMessage());
            toolLogger.logToolCallResult(-1, toolCall.getName(), failResult, 0L);
            return CompletableFuture.completedFuture(failResult);
        }
    }

    private Map<String, Object> parseArguments(String json) {
        if (json == null || json.isEmpty() || "{}".equals(json)) {
            return Collections.emptyMap();
        }
        try {
            JsonElement element = JsonParser.parseString((String)json);
            if (!element.isJsonObject()) {
                LOG.warn("Tool arguments is not a JSON object: %s", json);
                return Collections.emptyMap();
            }
            JsonObject obj = element.getAsJsonObject();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : obj.keySet()) {
                JsonElement value = obj.get(key);
                result.put(key, this.convertJsonElement(value));
            }
            return result;
        }
        catch (JsonSyntaxException e) {
            String truncatedJson = json.length() > 200 ? json.substring(0, 200) + "..." : json;
            LOG.warn("Failed to parse JSON arguments: %s, error: %s", truncatedJson, e.getMessage());
            return this.parseSimpleJson(json);
        }
    }

    private Object convertJsonElement(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                double d = primitive.getAsDouble();
                if (d == Math.floor(d) && !Double.isInfinite(d)) {
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        return (int)d;
                    }
                    return primitive.getAsLong();
                }
                return d;
            }
            return primitive.getAsString();
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement item : array) {
                list.add(this.convertJsonElement(item));
            }
            return list;
        }
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : obj.keySet()) {
                map.put(key, this.convertJsonElement(obj.get(key)));
            }
            return map;
        }
        return element.toString();
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> parseSimpleJson(String json) {
        result = new HashMap<String, Object>();
        if ((json = json.trim()).startsWith("{") && json.endsWith("}")) {
            json = json.substring(1, json.length() - 1).trim();
        }
        if (json.isEmpty()) {
            return result;
        }
        depth = 0;
        inString = false;
        current = new StringBuilder();
        pairs = new ArrayList<String>();
        i = 0;
        while (i < json.length()) {
            c = json.charAt(i);
            if (c == '\"' && (i == 0 || json.charAt(i - 1) != '\\')) {
                v0 = inString = inString == false;
            }
            if (inString) ** GOTO lbl-1000
            if (c == '{' || c == '[') {
                ++depth;
            }
            if (c == '}' || c == ']') {
                --depth;
            }
            if (c == ',' && depth == 0) {
                pairs.add(current.toString().trim());
                current = new StringBuilder();
            } else lbl-1000:
            // 2 sources

            {
                current.append(c);
            }
            ++i;
        }
        if (current.length() > 0) {
            pairs.add(current.toString().trim());
        }
        for (String pair : pairs) {
            colonIndex = this.findFirstColonOutsideQuotes(pair);
            if (colonIndex <= 0) continue;
            key = pair.substring(0, colonIndex).trim();
            value = pair.substring(colonIndex + 1).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                unescaped = value.substring(1, value.length() - 1);
                unescaped = unescaped.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\"", "\"").replace("\\\\", "\\");
                result.put(key, unescaped);
                continue;
            }
            if ("true".equals(value)) {
                result.put(key, Boolean.TRUE);
                continue;
            }
            if ("false".equals(value)) {
                result.put(key, Boolean.FALSE);
                continue;
            }
            if ("null".equals(value)) {
                result.put(key, null);
                continue;
            }
            try {
                if (value.contains(".")) {
                    result.put(key, Double.parseDouble(value));
                    continue;
                }
                result.put(key, Integer.parseInt(value));
            }
            catch (NumberFormatException v1) {
                result.put(key, value);
            }
        }
        return result;
    }

    private int findFirstColonOutsideQuotes(String str) {
        boolean inString = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\"' && (i == 0 || str.charAt(i - 1) != '\\')) {
                boolean bl = inString = !inString;
            }
            if (c == ':' && !inString) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

