/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.MdoTemplates;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class AddTabularSectionTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(AddTabularSectionTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"target\": {\n            \"type\": \"string\",\n            \"description\": \"FQN \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Document.\u0417\u0430\u043a\u0430\u0437\u041a\u043b\u0438\u0435\u043d\u0442\u0430)\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438\"\n        },\n        \"synonym\": {\n            \"type\": \"string\",\n            \"description\": \"\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (\u0441\u0438\u043d\u043e\u043d\u0438\u043c)\"\n        },\n        \"attributes\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"type\": \"object\",\n                \"properties\": {\n                    \"name\": { \"type\": \"string\", \"description\": \"\u0418\u043c\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430\" },\n                    \"synonym\": { \"type\": \"string\", \"description\": \"\u0421\u0438\u043d\u043e\u043d\u0438\u043c \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430\" },\n                    \"type\": { \"type\": \"string\", \"description\": \"\u0422\u0438\u043f: String, Number, Boolean, Date, CatalogRef.X\" },\n                    \"length\": { \"type\": \"integer\" },\n                    \"precision\": { \"type\": \"integer\" },\n                    \"scale\": { \"type\": \"integer\" }\n                },\n                \"required\": [\"name\", \"type\"]\n            },\n            \"description\": \"\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438\"\n        }\n    },\n    \"required\": [\"target\", \"name\", \"synonym\", \"attributes\"]\n}\n";
    private final MdoXmlService xmlService = MdoXmlService.getInstance();
    private final MdoTemplates templates = MdoTemplates.getInstance();

    @Override
    public String getName() {
        return "add_tabular_section";
    }

    @Override
    public String getDescription() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u043a \u043e\u0431\u044a\u0435\u043a\u0442\u0443 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421 (\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0443, \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 \u0438 \u0434\u0440.)";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] add_tabular_section called with parameters: %s", parameters);
            try {
                String target = (String)parameters.get("target");
                String name = (String)parameters.get("name");
                String synonym = (String)parameters.get("synonym");
                List attributes = (List)parameters.get("attributes");
                if (target == null || !target.contains(".")) {
                    return ToolResult.failure("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 target");
                }
                if (name == null || name.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438");
                }
                if (synonym == null || synonym.isEmpty()) {
                    synonym = name;
                }
                if (attributes == null || attributes.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438");
                }
                MetadataKind kind = MetadataKind.fromFqn(target);
                String objectName = MetadataKind.extractNameFromFqn(target);
                if (kind == null || !this.supportsTabularSections(kind)) {
                    return ToolResult.failure("\u041e\u0431\u044a\u0435\u043a\u0442 " + target + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438");
                }
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                String mdoPath = "src/" + kind.getFolderName() + "/" + objectName + "/" + objectName + ".mdo";
                IFile mdoFile = project.getFile(mdoPath);
                if (!mdoFile.exists()) {
                    return ToolResult.failure("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + mdoPath);
                }
                this.addTabularSection(mdoFile, name, synonym, attributes);
                LOG.info("[TOOL] add_tabular_section: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0422\u0427 %s \u0432 %s", name, target);
                StringBuilder result = new StringBuilder();
                result.append("\u2705 \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u0430\u044f \u0447\u0430\u0441\u0442\u044c **").append(name).append("** \u0432 ").append(target).append("\n\n");
                result.append("- \u0421\u0438\u043d\u043e\u043d\u0438\u043c: ").append(synonym).append("\n");
                result.append("- \u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432: ").append(attributes.size()).append("\n");
                for (Map attr : attributes) {
                    result.append("  - ").append(attr.get("name")).append(": ").append(attr.get("type")).append("\n");
                }
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[TOOL] add_tabular_section error: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }

    private void addTabularSection(IFile mdoFile, String name, String synonym, List<Map<String, Object>> attributes) throws CoreException {
        String content = this.xmlService.getMdoContent(mdoFile);
        Pattern tsPattern = Pattern.compile("<tabularSections[^>]*>\\s*.*?<name>" + name + "</name>", 32);
        if (tsPattern.matcher(content).find()) {
            throw new RuntimeException("\u0422\u0430\u0431\u043b\u0438\u0447\u043d\u0430\u044f \u0447\u0430\u0441\u0442\u044c " + name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UUID", this.xmlService.generateUuid());
        params.put("NAME", name);
        params.put("SYNONYM", synonym);
        params.put("TYPE_ID_OBJ_1", this.xmlService.generateUuid());
        params.put("TYPE_ID_OBJ_2", this.xmlService.generateUuid());
        params.put("TYPE_ID_ROW_1", this.xmlService.generateUuid());
        params.put("TYPE_ID_ROW_2", this.xmlService.generateUuid());
        StringBuilder attrsXml = new StringBuilder();
        for (Map<String, Object> attr : attributes) {
            attrsXml.append(this.formatAttribute(attr));
        }
        params.put("ATTRIBUTES", attrsXml.toString());
        String tsXml = this.templates.applyParameters(this.templates.getTabularSectionTemplate(), params);
        content = this.insertTabularSection(content, tsXml);
        this.xmlService.writeMdo(mdoFile, content);
    }

    private String formatAttribute(Map<String, Object> attr) {
        String attrName = (String)attr.get("name");
        String attrSynonym = (String)attr.getOrDefault("synonym", attrName);
        String attrType = this.mapType((String)attr.get("type"));
        int length = this.getInt(attr, "length", 100);
        int precision = this.getInt(attr, "precision", 15);
        int scale = this.getInt(attr, "scale", 2);
        String typeQualifiers = this.getTypeQualifiers(attrType, length, precision, scale);
        return "    <attributes uuid=\"%s\">\n      <name>%s</name>\n      <synonym>\n        <key>ru</key>\n        <value>%s</value>\n      </synonym>\n      <type>\n        <types>%s</types>\n        %s\n      </type>\n      <minValue xsi:type=\"core:UndefinedValue\"/>\n      <maxValue xsi:type=\"core:UndefinedValue\"/>\n      <dataHistory>Use</dataHistory>\n      <fullTextSearch>Use</fullTextSearch>\n    </attributes>\n".formatted(this.xmlService.generateUuid(), attrName, attrSynonym, attrType, typeQualifiers);
    }

    private String insertTabularSection(String content, String tsXml) {
        Pattern pattern = Pattern.compile("(</tabularSections>)", 32);
        Matcher matcher = pattern.matcher(content);
        int lastEnd = -1;
        while (matcher.find()) {
            lastEnd = matcher.end();
        }
        if (lastEnd > 0) {
            return content.substring(0, lastEnd) + "\n" + tsXml + content.substring(lastEnd);
        }
        int insertPos = content.indexOf("<forms");
        if (insertPos < 0) {
            insertPos = content.lastIndexOf("</mdclass:");
        }
        if (insertPos > 0) {
            int lineStart = content.lastIndexOf(10, insertPos - 1);
            if (lineStart < 0) {
                lineStart = 0;
            }
            return content.substring(0, lineStart) + "\n" + tsXml + content.substring(lineStart);
        }
        throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043c\u0435\u0441\u0442\u043e \u0434\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438");
    }

    private boolean supportsTabularSections(MetadataKind kind) {
        return switch (kind) {
            case MetadataKind.CATALOG, MetadataKind.DOCUMENT, MetadataKind.CHART_OF_CHARACTERISTIC_TYPES, MetadataKind.CHART_OF_ACCOUNTS, MetadataKind.CHART_OF_CALCULATION_TYPES, MetadataKind.DATA_PROCESSOR, MetadataKind.REPORT, MetadataKind.BUSINESS_PROCESS, MetadataKind.TASK, MetadataKind.EXCHANGE_PLAN -> true;
            default -> false;
        };
    }

    private String mapType(String type) {
        if (type.contains("Ref.")) {
            return type;
        }
        return switch (type.toLowerCase()) {
            case "\u0441\u0442\u0440\u043e\u043a\u0430", "string" -> "String";
            case "number", "\u0447\u0438\u0441\u043b\u043e" -> "Number";
            case "boolean", "\u0431\u0443\u043b\u0435\u0432\u043e" -> "Boolean";
            case "date", "\u0434\u0430\u0442\u0430" -> "Date";
            default -> type;
        };
    }

    private String getTypeQualifiers(String type, int length, int precision, int scale) {
        if (type.equals("String")) {
            return "<stringQualifiers><length>" + length + "</length></stringQualifiers>";
        }
        if (type.equals("Number")) {
            return "<numberQualifiers><precision>" + precision + "</precision><scale>" + scale + "</scale></numberQualifiers>";
        }
        return "";
    }

    private int getInt(Map<String, Object> map, String key, int defaultValue) {
        Object val = map.get(key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return defaultValue;
    }
}

