/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.BmMetadataService;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.ConfigurationMdoService;
import com.example.vibe.core.tools.metadata.services.MdoTemplates;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CreateMetadataTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(CreateMetadataTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"kind\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 (48 \u0442\u0438\u043f\u043e\u0432). \u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435: Catalog, Document, Enum, CommonModule, InformationRegister, AccumulationRegister, DataProcessor, Report, Subsystem, Role, Constant, ScheduledJob, EventSubscription, ExchangePlan, WebService, HTTPService. \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435: DefinedType (\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c\u044b\u0439\u0422\u0438\u043f), CommonAttribute (\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442), DocumentJournal (\u0416\u0443\u0440\u043d\u0430\u043b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432), XDTOPackage, ExternalDataSource, FunctionalOption, SessionParameter, CommonTemplate, CommonPicture, CommandGroup, FilterCriterion, SettingsStorage, DocumentNumerator, Style, Language, IntegrationService, WebSocketClient, Bot\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (CamelCase \u0431\u0435\u0437 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: \u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b, \u0421\u0442\u0430\u0442\u0443\u0441\u044b\u0417\u0430\u043a\u0430\u0437\u0430)\"\n        },\n        \"synonym\": {\n            \"type\": \"string\",\n            \"description\": \"\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (\u0441\u0438\u043d\u043e\u043d\u0438\u043c) \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: \u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b, \u0421\u0442\u0430\u0442\u0443\u0441\u044b \u0437\u0430\u043a\u0430\u0437\u0430\"\n        },\n        \"comment\": {\n            \"type\": \"string\",\n            \"description\": \"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e)\"\n        },\n        \"subsystem\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e). \u041c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u0443\u044e: \u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c.\u0414\u043e\u0447\u0435\u0440\u043d\u044f\u044f\"\n        },\n        \"options\": {\n            \"type\": \"object\",\n            \"description\": \"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430\",\n            \"properties\": {\n                \"hierarchical\": { \"type\": \"boolean\", \"description\": \"\u0418\u0435\u0440\u0430\u0440\u0445\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a (\u0434\u043b\u044f Catalog)\" },\n                \"codeLength\": { \"type\": \"integer\", \"description\": \"\u0414\u043b\u0438\u043d\u0430 \u043a\u043e\u0434\u0430 (\u0434\u043b\u044f Catalog, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 9)\" },\n                \"descriptionLength\": { \"type\": \"integer\", \"description\": \"\u0414\u043b\u0438\u043d\u0430 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f (\u0434\u043b\u044f Catalog, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 150)\" },\n                \"numberLength\": { \"type\": \"integer\", \"description\": \"\u0414\u043b\u0438\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 (\u0434\u043b\u044f Document, \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 11)\" },\n                \"server\": { \"type\": \"boolean\", \"description\": \"\u0421\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c (\u0434\u043b\u044f CommonModule)\" },\n                \"clientManagedApplication\": { \"type\": \"boolean\", \"description\": \"\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u043c\u043e\u0434\u0443\u043b\u044c (\u0434\u043b\u044f CommonModule)\" },\n                \"global\": { \"type\": \"boolean\", \"description\": \"\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c (\u0434\u043b\u044f CommonModule)\" },\n                \"serverCall\": { \"type\": \"boolean\", \"description\": \"\u0412\u044b\u0437\u043e\u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u0434\u043b\u044f CommonModule)\" },\n                \"registerType\": { \"type\": \"string\", \"description\": \"\u0422\u0438\u043f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430: Balances \u0438\u043b\u0438 Turnovers (\u0434\u043b\u044f AccumulationRegister)\" },\n                \"type\": { \"type\": \"string\", \"description\": \"\u0422\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 (\u0434\u043b\u044f Constant): String, Number, Boolean, Date\" }\n            }\n        }\n    },\n    \"required\": [\"kind\", \"name\", \"synonym\"]\n}\n";
    private final MdoXmlService xmlService = MdoXmlService.getInstance();
    private final MdoTemplates templates = MdoTemplates.getInstance();
    private final ConfigurationMdoService configService = ConfigurationMdoService.getInstance();

    @Override
    public String getName() {
        return "create_metadata";
    }

    @Override
    public String getDescription() {
        return "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421. \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: Tool \u0410\u0412\u0422\u041e\u041c\u0410\u0422\u0418\u0427\u0415\u0421\u041a\u0418 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0412\u0421\u0415 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f: 1) \u0441\u043e\u0437\u0434\u0430\u0451\u0442 \u043f\u0430\u043f\u043a\u0443 \u0438 .mdo \u0444\u0430\u0439\u043b \u043e\u0431\u044a\u0435\u043a\u0442\u0430, 2) \u0420\u0415\u0414\u0410\u041a\u0422\u0418\u0420\u0423\u0415\u0422 Configuration.mdo (\u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u043e\u0431\u044a\u0435\u043a\u0442), 3) \u043e\u043f\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u0442 \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443. \u041d\u0415 \u041d\u0423\u0416\u041d\u041e \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c Configuration.mdo - \u044d\u0442\u043e \u0434\u0435\u043b\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438! \u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0432\u0441\u0435 48 \u0442\u0438\u043f\u043e\u0432: Catalog, Document, Enum, CommonModule, InformationRegister \u0438 \u0434\u0440.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            LOG.info("[CREATE_METADATA] \u25b6 \u041d\u0410\u0427\u0410\u041b\u041e \u0412\u042b\u041f\u041e\u041b\u041d\u0415\u041d\u0418\u042f");
            LOG.info("[CREATE_METADATA] \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: %s", parameters);
            try {
                MetadataKind kind;
                String kindStr = (String)parameters.get("kind");
                String name = (String)parameters.get("name");
                String synonym = (String)parameters.get("synonym");
                String subsystem = (String)parameters.get("subsystem");
                Map options = parameters.getOrDefault("options", new HashMap());
                LOG.debug("[CREATE_METADATA] \u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: kind=%s, name=%s, synonym=%s, subsystem=%s", kindStr, name, synonym, subsystem);
                if (kindStr == null || kindStr.isEmpty()) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (kind)");
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (kind)");
                }
                if (name == null || name.isEmpty()) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (name)");
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (name)");
                }
                if (synonym == null || synonym.isEmpty()) {
                    synonym = name;
                    LOG.debug("[CREATE_METADATA] \u0421\u0438\u043d\u043e\u043d\u0438\u043c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0438\u043c\u044f: %s", name);
                }
                if ((kind = MetadataKind.fromString(kindStr)) == null) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: %s", kindStr);
                    return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: Catalog, Document, Enum, CommonModule, InformationRegister \u0438 \u0434\u0440.");
                }
                LOG.info("[CREATE_METADATA] \u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: %s (%s), configTag=%s", kind.getEnglishName(), kind.getRussianSingular(), kind.getConfigurationTag());
                if (!this.isValidIdentifier(name)) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: %s", name);
                    return ToolResult.failure("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + name + ". \u0418\u043c\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u0431\u0443\u043a\u0432\u044b \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b \u0438 \u0441\u0438\u043c\u0432\u043e\u043b \u043f\u043e\u0434\u0447\u0451\u0440\u043a\u0438\u0432\u0430\u043d\u0438\u044f.");
                }
                LOG.info("[CREATE_METADATA] \u041f\u043e\u0438\u0441\u043a \u043f\u0440\u043e\u0435\u043a\u0442\u0430 1\u0421 \u0432 workspace...");
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                }
                LOG.info("[CREATE_METADATA] \u2713 \u041d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0435\u043a\u0442: %s (\u043f\u0443\u0442\u044c: %s)", project.getName(), project.getLocation());
                LOG.debug("[CREATE_METADATA] \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 %s.%s...", kind.getEnglishName(), name);
                if (this.configService.hasObject(project, kind, name)) {
                    LOG.error("[CREATE_METADATA] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041e\u0431\u044a\u0435\u043a\u0442 %s.%s \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", kind.getEnglishName(), name);
                    return ToolResult.failure("\u041e\u0431\u044a\u0435\u043a\u0442 " + kind.getEnglishName() + "." + name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                }
                LOG.debug("[CREATE_METADATA] \u2713 \u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c");
                LOG.info("[CREATE_METADATA] \u2550\u2550\u2550 \u0428\u0410\u0413 1: \u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 MDO \u0444\u0430\u0439\u043b\u0430 \u2550\u2550\u2550");
                String createdPath = this.createMetadataObject(project, kind, name, synonym, options);
                LOG.info("[CREATE_METADATA] \u2713 MDO \u0444\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d: %s", createdPath);
                LOG.info("[CREATE_METADATA] \u2550\u2550\u2550 \u0428\u0410\u0413 2: \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 Configuration.mdo \u2550\u2550\u2550");
                LOG.info("[CREATE_METADATA] \u0412\u044b\u0437\u043e\u0432 configService.addObject(project=%s, kind=%s, name=%s)", project.getName(), kind.getEnglishName(), name);
                this.configService.addObject(project, kind, name);
                LOG.info("[CREATE_METADATA] \u2713 \u0417\u0430\u043f\u0438\u0441\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 Configuration.mdo: <%s>%s.%s</%s>", kind.getConfigurationTag(), kind.getEnglishName(), name, kind.getConfigurationTag());
                if (subsystem != null && !subsystem.isEmpty()) {
                    LOG.info("[CREATE_METADATA] \u2550\u2550\u2550 \u0428\u0410\u0413 3: \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u2550\u2550\u2550");
                    String fqn = kind.getEnglishName() + "." + name;
                    LOG.info("[CREATE_METADATA] \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 %s \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443 %s", fqn, subsystem);
                    this.configService.addToSubsystem(project, subsystem, fqn);
                    LOG.info("[CREATE_METADATA] \u2713 \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443 %s", subsystem);
                }
                LOG.debug("[CREATE_METADATA] \u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 BM API...");
                boolean validated = this.validateWithBm(project, kind, name);
                LOG.debug("[CREATE_METADATA] BM \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f: %s", validated ? "\u0443\u0441\u043f\u0435\u0448\u043d\u043e" : "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c");
                StringBuilder result = new StringBuilder();
                result.append("\u2705 \u0421\u043e\u0437\u0434\u0430\u043d \u043e\u0431\u044a\u0435\u043a\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445: **").append(kind.getRussianSingular()).append(".").append(name).append("**\n\n");
                result.append("- \u041f\u0443\u0442\u044c: `").append(createdPath).append("`\n");
                result.append("- \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 Configuration.mdo\n");
                if (subsystem != null && !subsystem.isEmpty()) {
                    result.append("- \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443: ").append(subsystem).append("\n");
                }
                if (validated) {
                    result.append("- \u2713 \u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f BM API \u0443\u0441\u043f\u0435\u0448\u043d\u0430\n");
                }
                LOG.info("[CREATE_METADATA] \u25b6 \u0423\u0421\u041f\u0415\u0428\u041d\u041e \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u041e: %s.%s", kind.getEnglishName(), name);
                LOG.info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[CREATE_METADATA] \u2717 \u0418\u0421\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415: %s", e.getMessage());
                LOG.error("[CREATE_METADATA] Stack trace: ", e);
                LOG.info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + e.getMessage());
            }
        });
    }

    private String createMetadataObject(IProject project, MetadataKind kind, String name, String synonym, Map<String, Object> options) throws Exception {
        String template = this.templates.getTemplate(kind);
        HashMap<String, String> params = new HashMap<String, String>(this.templates.generateProducedTypesUuids(kind));
        params.put("NAME", name);
        params.put("SYNONYM", synonym);
        this.addKindSpecificParams(kind, params, options);
        String mdoContent = this.templates.applyParameters(template, params);
        String folderPath = "src/" + kind.getFolderName() + "/" + name;
        this.xmlService.createObjectFolder(project, folderPath);
        String mdoPath = folderPath + "/" + name + ".mdo";
        IFile mdoFile = project.getFile(mdoPath);
        this.xmlService.writeMdo(mdoFile, mdoContent);
        this.createAdditionalFiles(project, kind, name, folderPath);
        return mdoPath;
    }

    private void addKindSpecificParams(MetadataKind kind, Map<String, String> params, Map<String, Object> options) {
        switch (kind) {
            case CATALOG: {
                params.put("HIERARCHICAL", String.valueOf(this.getBoolOption(options, "hierarchical", false)));
                params.put("CODE_LENGTH", String.valueOf(this.getIntOption(options, "codeLength", 9)));
                params.put("DESCRIPTION_LENGTH", String.valueOf(this.getIntOption(options, "descriptionLength", 150)));
                break;
            }
            case DOCUMENT: {
                params.put("NUMBER_LENGTH", String.valueOf(this.getIntOption(options, "numberLength", 11)));
                break;
            }
            case COMMON_MODULE: {
                params.put("SERVER", String.valueOf(this.getBoolOption(options, "server", true)));
                params.put("GLOBAL", String.valueOf(this.getBoolOption(options, "global", false)));
                params.put("CLIENT_MANAGED", String.valueOf(this.getBoolOption(options, "clientManagedApplication", false)));
                params.put("EXTERNAL_CONNECTION", String.valueOf(this.getBoolOption(options, "externalConnection", true)));
                params.put("SERVER_CALL", String.valueOf(this.getBoolOption(options, "serverCall", false)));
                params.put("CLIENT_ORDINARY", String.valueOf(this.getBoolOption(options, "clientOrdinaryApplication", false)));
                break;
            }
            case ACCUMULATION_REGISTER: {
                String registerType = this.getStringOption(options, "registerType", "Turnovers");
                params.put("REGISTER_TYPE", registerType);
                break;
            }
            case CONSTANT: {
                String type = this.getStringOption(options, "type", "String");
                params.put("TYPE", type);
                break;
            }
            case SCHEDULED_JOB: {
                params.put("METHOD_NAME", this.getStringOption(options, "methodName", ""));
                break;
            }
            case EVENT_SUBSCRIPTION: {
                params.put("EVENT", this.getStringOption(options, "event", "BeforeWrite"));
                params.put("HANDLER", this.getStringOption(options, "handler", ""));
                break;
            }
        }
    }

    private void createAdditionalFiles(IProject project, MetadataKind kind, String name, String folderPath) throws Exception {
        switch (kind) {
            case COMMON_MODULE: {
                String modulePath = folderPath + "/Module.bsl";
                IFile moduleFile = project.getFile(modulePath);
                this.xmlService.writeMdo(moduleFile, "\n");
                break;
            }
            case DATA_PROCESSOR: 
            case REPORT: {
                String modulePath = folderPath + "/ObjectModule.bsl";
                IFile moduleFile = project.getFile(modulePath);
                this.xmlService.writeMdo(moduleFile, "\n");
                break;
            }
        }
    }

    private boolean validateWithBm(IProject project, MetadataKind kind, String name) {
        block5: {
            BmMetadataService bmService;
            block4: {
                try {
                    bmService = BmMetadataService.getInstance();
                    if (bmService.isAvailable()) break block4;
                    LOG.debug("BM API \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438");
                    return false;
                }
                catch (Exception e) {
                    LOG.debug("\u041e\u0448\u0438\u0431\u043a\u0430 BM \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438: %s", e.getMessage());
                    return false;
                }
            }
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            Optional<BmMetadataService.ObjectDetails> details = bmService.findByKindAndName(project, kind, name);
            if (!details.isPresent()) break block5;
            LOG.debug("BM \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u0430 \u0434\u043b\u044f %s.%s", kind.getEnglishName(), name);
            return true;
        }
        LOG.debug("BM \u043d\u0435 \u043d\u0430\u0448\u0451\u043b \u043e\u0431\u044a\u0435\u043a\u0442 %s.%s (\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0438\u043d\u0434\u0435\u043a\u0441\u0430\u0446\u0438\u044f)", kind.getEnglishName(), name);
        return false;
    }

    private boolean isValidIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.matches("^[a-zA-Z\u0430-\u044f\u0410-\u042f\u0451\u0401_][a-zA-Z\u0430-\u044f\u0410-\u042f\u0451\u04010-9_]*$");
    }

    private boolean getBoolOption(Map<String, Object> options, String key, boolean defaultValue) {
        Object value = options.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    private int getIntOption(Map<String, Object> options, String key, int defaultValue) {
        Object value = options.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    private String getStringOption(Map<String, Object> options, String key, String defaultValue) {
        Object value = options.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }
}

