/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.BmMetadataService;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class GetMetadataTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(GetMetadataTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"kind\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: Catalog/\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a, Document/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442, AccumulationRegister/\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f \u0438 \u0434\u0440.\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445\"\n        },\n        \"show_details\": {\n            \"type\": \"boolean\",\n            \"description\": \"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438: \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b, \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438, \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f, \u0440\u0435\u0441\u0443\u0440\u0441\u044b (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e true)\"\n        },\n        \"show_mdo\": {\n            \"type\": \"boolean\",\n            \"description\": \"\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 .mdo \u0444\u0430\u0439\u043b\u0430 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e false)\"\n        }\n    },\n    \"required\": [\"kind\", \"name\"]\n}\n";

    @Override
    public String getName() {
        return "get_metadata";
    }

    @Override
    public String getDescription() {
        return "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e\u0431 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 1\u0421. \u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u043e\u0431\u044a\u0435\u043a\u0442\u0430, \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 \u0438 \u0444\u043e\u0440\u043c\u044b.";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] get_metadata called with parameters: %s", parameters);
            String kindStr = (String)parameters.get("kind");
            String name = (String)parameters.get("name");
            boolean showDetails = !Boolean.FALSE.equals(parameters.get("show_details"));
            boolean showMdo = Boolean.TRUE.equals(parameters.get("show_mdo"));
            LOG.info("[TOOL] get_metadata: kind=%s, name=%s, showDetails=%s, showMdo=%s", kindStr, name, showDetails, showMdo);
            if (kindStr == null || kindStr.isEmpty()) {
                LOG.warn("[TOOL] get_metadata: kind is empty");
                return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (kind)");
            }
            if (name == null || name.isEmpty()) {
                return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (name)");
            }
            MetadataKind kind = MetadataKind.fromString(kindStr);
            if (kind == null) {
                return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: Catalog, Document, AccumulationRegister \u0438 \u0434\u0440.");
            }
            try {
                IFile iFile;
                List<String> forms;
                List<String> modules;
                MetadataResolver resolver = MetadataResolver.getInstance();
                MetadataResolver.MetadataObject obj = resolver.getMetadata(kind, name);
                if (obj == null) {
                    return ToolResult.failure(kind.getRussianSingular() + " '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("# ").append(kind.getRussianSingular()).append(".").append(obj.getName()).append("\n\n");
                BmMetadataService.ObjectDetails bmDetails = null;
                if (showDetails) {
                    LOG.info("[TOOL] get_metadata: requesting BM details for %s.%s", kind.getEnglishName(), name);
                    bmDetails = this.getBmDetails(kind, name);
                    if (bmDetails != null) {
                        LOG.info("[TOOL] get_metadata: BM details received - attrs=%d, ts=%d, dims=%d, res=%d", bmDetails.attributes.size(), bmDetails.tabularSections.size(), bmDetails.dimensions.size(), bmDetails.resources.size());
                        if (bmDetails.synonym != null) {
                            sb.append("**\u0421\u0438\u043d\u043e\u043d\u0438\u043c:** ").append(bmDetails.synonym).append("\n");
                        }
                    } else {
                        LOG.info("[TOOL] get_metadata: BM details not available, using file-based only");
                    }
                }
                sb.append("**\u041f\u0443\u0442\u044c:** `").append(obj.getPath()).append("`\n");
                sb.append("**MDO \u0444\u0430\u0439\u043b:** `").append(obj.getMdoPath()).append("`\n\n");
                if (bmDetails != null && !bmDetails.properties.isEmpty()) {
                    sb.append("## \u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430\n\n");
                    for (Map.Entry<String, String> entry : bmDetails.properties.entrySet()) {
                        sb.append("- **").append(this.getPropertyDisplayName(entry.getKey())).append(":** ").append(entry.getValue()).append("\n");
                    }
                    sb.append("\n");
                }
                if (bmDetails != null && !bmDetails.attributes.isEmpty()) {
                    sb.append("## \u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b (").append(bmDetails.attributes.size()).append(")\n\n");
                    for (BmMetadataService.FeatureInfo attr : bmDetails.attributes) {
                        sb.append("- **").append(attr.name).append("**");
                        if (attr.synonym != null) {
                            sb.append(" \u2014 ").append(attr.synonym);
                        }
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                if (bmDetails != null && !bmDetails.tabularSections.isEmpty()) {
                    sb.append("## \u0422\u0430\u0431\u043b\u0438\u0447\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438 (").append(bmDetails.tabularSections.size()).append(")\n\n");
                    for (BmMetadataService.TabularSectionInfo ts : bmDetails.tabularSections) {
                        sb.append("### ").append(ts.name);
                        if (ts.synonym != null) {
                            sb.append(" \u2014 ").append(ts.synonym);
                        }
                        sb.append("\n");
                        for (BmMetadataService.FeatureInfo featureInfo : ts.attributes) {
                            sb.append("  - ").append(featureInfo.name);
                            if (featureInfo.synonym != null) {
                                sb.append(" \u2014 ").append(featureInfo.synonym);
                            }
                            sb.append("\n");
                        }
                    }
                    sb.append("\n");
                }
                if (bmDetails != null && !bmDetails.dimensions.isEmpty()) {
                    sb.append("## \u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f (").append(bmDetails.dimensions.size()).append(")\n\n");
                    for (BmMetadataService.FeatureInfo dim : bmDetails.dimensions) {
                        sb.append("- **").append(dim.name).append("**");
                        if (dim.synonym != null) {
                            sb.append(" \u2014 ").append(dim.synonym);
                        }
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                if (bmDetails != null && !bmDetails.resources.isEmpty()) {
                    sb.append("## \u0420\u0435\u0441\u0443\u0440\u0441\u044b (").append(bmDetails.resources.size()).append(")\n\n");
                    for (BmMetadataService.FeatureInfo res : bmDetails.resources) {
                        sb.append("- **").append(res.name).append("**");
                        if (res.synonym != null) {
                            sb.append(" \u2014 ").append(res.synonym);
                        }
                        sb.append("\n");
                    }
                    sb.append("\n");
                }
                if (!(modules = obj.getAvailableModules()).isEmpty()) {
                    sb.append("## \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438\n\n");
                    for (String module : modules) {
                        if (module.startsWith("Form:")) {
                            String formName = module.substring(5);
                            sb.append("- \u0424\u043e\u0440\u043c\u0430: **").append(formName).append("**\n");
                            continue;
                        }
                        String moduleDisplayName = this.getModuleDisplayName(module);
                        sb.append("- ").append(moduleDisplayName).append("\n");
                    }
                    sb.append("\n");
                }
                if (!(forms = obj.getFormNames()).isEmpty()) {
                    sb.append("## \u0424\u043e\u0440\u043c\u044b\n\n");
                    for (String string : forms) {
                        sb.append("- ").append(string).append("\n");
                    }
                    sb.append("\n");
                }
                if (showMdo && (iFile = obj.getMdoFile()).exists()) {
                    sb.append("## \u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 MDO\n\n");
                    sb.append("```xml\n");
                    sb.append(this.readFileContent(iFile, 100));
                    sb.append("\n```\n");
                }
                sb.append("---\n");
                sb.append("*\u0414\u043b\u044f \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435:* `open_module(kind=\"").append(kind.getEnglishName()).append("\", name=\"").append(obj.getName()).append("\", module=\"ObjectModule\")`\n");
                return ToolResult.success(sb.toString());
            }
            catch (Exception e) {
                LOG.warn("Error getting metadata for %s.%s: %s", kindStr, name, e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }

    private BmMetadataService.ObjectDetails getBmDetails(MetadataKind kind, String name) {
        Optional<IProject> projectOpt;
        BmMetadataService bmService;
        block7: {
            block6: {
                bmService = BmMetadataService.getInstance();
                try {
                    if (bmService.isAvailable()) break block6;
                    LOG.debug("BmMetadataService not available, skipping BM details");
                    return null;
                }
                catch (Exception e) {
                    if (bmService.isAvailable()) {
                        LOG.warn("Unexpected error getting BM details for %s.%s: %s", kind != null ? kind.getEnglishName() : "null", name, e.getMessage());
                    } else {
                        LOG.debug("BM details not available: %s", e.getMessage());
                    }
                    return null;
                }
            }
            projectOpt = bmService.findProject();
            if (!projectOpt.isEmpty()) break block7;
            LOG.debug("No V8 project found");
            return null;
        }
        Optional<BmMetadataService.ObjectDetails> details = bmService.findByKindAndName(projectOpt.get(), kind, name);
        return details.orElse(null);
    }

    private String getPropertyDisplayName(String key) {
        return switch (key) {
            case "codeLength" -> "\u0414\u043b\u0438\u043d\u0430 \u043a\u043e\u0434\u0430";
            case "descriptionLength" -> "\u0414\u043b\u0438\u043d\u0430 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f";
            case "hierarchical" -> "\u0418\u0435\u0440\u0430\u0440\u0445\u0438\u0447\u0435\u0441\u043a\u0438\u0439";
            case "numberLength" -> "\u0414\u043b\u0438\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0430";
            case "periodicity" -> "\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c";
            default -> key;
        };
    }

    private String getModuleDisplayName(String module) {
        return switch (module) {
            case "Module" -> "\u041c\u043e\u0434\u0443\u043b\u044c (Module.bsl)";
            case "ObjectModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (ObjectModule.bsl)";
            case "ManagerModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430 (ManagerModule.bsl)";
            case "RecordSetModule" -> "\u041c\u043e\u0434\u0443\u043b\u044c \u043d\u0430\u0431\u043e\u0440\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 (RecordSetModule.bsl)";
            default -> module;
        };
    }

    private String readFileContent(IFile file, int maxLines) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                int count = 0;
                while ((line = reader.readLine()) != null && count < maxLines) {
                    sb.append(line).append("\n");
                    ++count;
                }
                if (count == maxLines) {
                    sb.append("... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e \u0434\u043e ").append(maxLines).append(" \u0441\u0442\u0440\u043e\u043a)\n");
                }
                return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f: " + e.getMessage();
        }
    }
}

