/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import java.util.HashMap;
import java.util.Map;

public enum MetadataKind {
    CATALOG("Catalog", "Catalogs", "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a", "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438", "catalogs"),
    DOCUMENT("Document", "Documents", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b", "documents"),
    ENUM("Enum", "Enums", "\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435", "\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f", "enums"),
    CHART_OF_CHARACTERISTIC_TYPES("ChartOfCharacteristicTypes", "ChartsOfCharacteristicTypes", "\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a", "\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0425\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a", "chartsOfCharacteristicTypes"),
    CHART_OF_ACCOUNTS("ChartOfAccounts", "ChartsOfAccounts", "\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432", "\u041f\u043b\u0430\u043d\u044b\u0421\u0447\u0435\u0442\u043e\u0432", "chartsOfAccounts"),
    CHART_OF_CALCULATION_TYPES("ChartOfCalculationTypes", "ChartsOfCalculationTypes", "\u041f\u043b\u0430\u043d\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430", "\u041f\u043b\u0430\u043d\u044b\u0412\u0438\u0434\u043e\u0432\u0420\u0430\u0441\u0447\u0435\u0442\u0430", "chartsOfCalculationTypes"),
    INFORMATION_REGISTER("InformationRegister", "InformationRegisters", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u0439", "informationRegisters"),
    ACCUMULATION_REGISTER("AccumulationRegister", "AccumulationRegisters", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u041d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u0438\u044f", "accumulationRegisters"),
    ACCOUNTING_REGISTER("AccountingRegister", "AccountingRegisters", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0411\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438", "accountingRegisters"),
    CALCULATION_REGISTER("CalculationRegister", "CalculationRegisters", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0420\u0430\u0441\u0447\u0435\u0442\u0430", "\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b\u0420\u0430\u0441\u0447\u0435\u0442\u0430", "calculationRegisters"),
    COMMON_MODULE("CommonModule", "CommonModules", "\u041e\u0431\u0449\u0438\u0439\u041c\u043e\u0434\u0443\u043b\u044c", "\u041e\u0431\u0449\u0438\u0435\u041c\u043e\u0434\u0443\u043b\u0438", "commonModules"),
    COMMON_FORM("CommonForm", "CommonForms", "\u041e\u0431\u0449\u0430\u044f\u0424\u043e\u0440\u043c\u0430", "\u041e\u0431\u0449\u0438\u0435\u0424\u043e\u0440\u043c\u044b", "commonForms"),
    COMMON_COMMAND("CommonCommand", "CommonCommands", "\u041e\u0431\u0449\u0430\u044f\u041a\u043e\u043c\u0430\u043d\u0434\u0430", "\u041e\u0431\u0449\u0438\u0435\u041a\u043e\u043c\u0430\u043d\u0434\u044b", "commonCommands"),
    COMMON_TEMPLATE("CommonTemplate", "CommonTemplates", "\u041e\u0431\u0449\u0438\u0439\u041c\u0430\u043a\u0435\u0442", "\u041e\u0431\u0449\u0438\u0435\u041c\u0430\u043a\u0435\u0442\u044b", "commonTemplates"),
    COMMON_PICTURE("CommonPicture", "CommonPictures", "\u041e\u0431\u0449\u0430\u044f\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0430", "\u041e\u0431\u0449\u0438\u0435\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0438", "commonPictures"),
    COMMON_ATTRIBUTE("CommonAttribute", "CommonAttributes", "\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", "\u041e\u0431\u0449\u0438\u0435\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b", "commonAttributes"),
    DATA_PROCESSOR("DataProcessor", "DataProcessors", "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430", "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438", "dataProcessors"),
    REPORT("Report", "Reports", "\u041e\u0442\u0447\u0435\u0442", "\u041e\u0442\u0447\u0451\u0442\u044b", "reports"),
    BUSINESS_PROCESS("BusinessProcess", "BusinessProcesses", "\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441", "\u0411\u0438\u0437\u043d\u0435\u0441\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u044b", "businessProcesses"),
    TASK("Task", "Tasks", "\u0417\u0430\u0434\u0430\u0447\u0430", "\u0417\u0430\u0434\u0430\u0447\u0438", "tasks"),
    EXCHANGE_PLAN("ExchangePlan", "ExchangePlans", "\u041f\u043b\u0430\u043d\u041e\u0431\u043c\u0435\u043d\u0430", "\u041f\u043b\u0430\u043d\u044b\u041e\u0431\u043c\u0435\u043d\u0430", "exchangePlans"),
    WEB_SERVICE("WebService", "WebServices", "Web\u0421\u0435\u0440\u0432\u0438\u0441", "Web\u0421\u0435\u0440\u0432\u0438\u0441\u044b", "webServices"),
    HTTP_SERVICE("HTTPService", "HTTPServices", "HTTP\u0421\u0435\u0440\u0432\u0438\u0441", "HTTP\u0421\u0435\u0440\u0432\u0438\u0441\u044b", "httpServices"),
    WS_REFERENCE("WSReference", "WSReferences", "WS\u0421\u0441\u044b\u043b\u043a\u0430", "WS\u0421\u0441\u044b\u043b\u043a\u0438", "wsReferences"),
    XDTO_PACKAGE("XDTOPackage", "XDTOPackages", "\u041f\u0430\u043a\u0435\u0442XDTO", "\u041f\u0430\u043a\u0435\u0442\u044bXDTO", "xDTOPackages"),
    INTEGRATION_SERVICE("IntegrationService", "IntegrationServices", "\u0421\u0435\u0440\u0432\u0438\u0441\u0418\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u0438", "\u0421\u0435\u0440\u0432\u0438\u0441\u044b\u0418\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u0438", "integrationServices"),
    WEB_SOCKET_CLIENT("WebSocketClient", "WebSocketClients", "WebSocket\u041a\u043b\u0438\u0435\u043d\u0442", "WebSocket\u041a\u043b\u0438\u0435\u043d\u0442\u044b", "webSocketClients"),
    BOT("Bot", "Bots", "\u0411\u043e\u0442", "\u0411\u043e\u0442\u044b", "bots"),
    EXTERNAL_DATA_SOURCE("ExternalDataSource", "ExternalDataSources", "\u0412\u043d\u0435\u0448\u043d\u0438\u0439\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0414\u0430\u043d\u043d\u044b\u0445", "\u0412\u043d\u0435\u0448\u043d\u0438\u0435\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438\u0414\u0430\u043d\u043d\u044b\u0445", "externalDataSources"),
    SCHEDULED_JOB("ScheduledJob", "ScheduledJobs", "\u0420\u0435\u0433\u043b\u0430\u043c\u0435\u043d\u0442\u043d\u043e\u0435\u0417\u0430\u0434\u0430\u043d\u0438\u0435", "\u0420\u0435\u0433\u043b\u0430\u043c\u0435\u043d\u0442\u043d\u044b\u0435\u0417\u0430\u0434\u0430\u043d\u0438\u044f", "scheduledJobs"),
    EVENT_SUBSCRIPTION("EventSubscription", "EventSubscriptions", "\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430\u041d\u0430\u0421\u043e\u0431\u044b\u0442\u0438\u0435", "\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438\u041d\u0430\u0421\u043e\u0431\u044b\u0442\u0438\u044f", "eventSubscriptions"),
    SUBSYSTEM("Subsystem", "Subsystems", "\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430", "\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b", "subsystems"),
    ROLE("Role", "Roles", "\u0420\u043e\u043b\u044c", "\u0420\u043e\u043b\u0438", "roles"),
    SESSION_PARAMETER("SessionParameter", "SessionParameters", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0421\u0435\u0430\u043d\u0441\u0430", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b\u0421\u0435\u0430\u043d\u0441\u0430", "sessionParameters"),
    SETTINGS_STORAGE("SettingsStorage", "SettingsStorages", "\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435\u041d\u0430\u0441\u0442\u0440\u043e\u0435\u043a", "\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430\u041d\u0430\u0441\u0442\u0440\u043e\u0435\u043a", "settingsStorages"),
    CONSTANT("Constant", "Constants", "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430", "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b", "constants"),
    SEQUENCE("Sequence", "Sequences", "\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", "\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438", "sequences"),
    DOCUMENT_JOURNAL("DocumentJournal", "DocumentJournals", "\u0416\u0443\u0440\u043d\u0430\u043b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432", "\u0416\u0443\u0440\u043d\u0430\u043b\u044b\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432", "documentJournals"),
    DOCUMENT_NUMERATOR("DocumentNumerator", "DocumentNumerators", "\u041d\u0443\u043c\u0435\u0440\u0430\u0442\u043e\u0440", "\u041d\u0443\u043c\u0435\u0440\u0430\u0442\u043e\u0440\u044b", "documentNumerators"),
    DEFINED_TYPE("DefinedType", "DefinedTypes", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c\u044b\u0439\u0422\u0438\u043f", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u043c\u044b\u0435\u0422\u0438\u043f\u044b", "definedTypes"),
    FUNCTIONAL_OPTION("FunctionalOption", "FunctionalOptions", "\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f\u041e\u043f\u0446\u0438\u044f", "\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435\u041e\u043f\u0446\u0438\u0438", "functionalOptions"),
    FUNCTIONAL_OPTIONS_PARAMETER("FunctionalOptionsParameter", "FunctionalOptionsParameters", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445\u041e\u043f\u0446\u0438\u0439", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445\u041e\u043f\u0446\u0438\u0439", "functionalOptionsParameters"),
    FILTER_CRITERION("FilterCriterion", "FilterCriteria", "\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439\u041e\u0442\u0431\u043e\u0440\u0430", "\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0438\u041e\u0442\u0431\u043e\u0440\u0430", "filterCriteria"),
    COMMAND_GROUP("CommandGroup", "CommandGroups", "\u0413\u0440\u0443\u043f\u043f\u0430\u041a\u043e\u043c\u0430\u043d\u0434", "\u0413\u0440\u0443\u043f\u043f\u044b\u041a\u043e\u043c\u0430\u043d\u0434", "commandGroups"),
    STYLE("Style", "Styles", "\u0421\u0442\u0438\u043b\u044c", "\u0421\u0442\u0438\u043b\u0438", "styles"),
    STYLE_ITEM("StyleItem", "StyleItems", "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0421\u0442\u0438\u043b\u044f", "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b\u0421\u0442\u0438\u043b\u044f", "styleItems"),
    LANGUAGE("Language", "Languages", "\u042f\u0437\u044b\u043a", "\u042f\u0437\u044b\u043a\u0438", "languages"),
    INTERFACE("Interface", "Interfaces", "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b", "interfaces");

    private final String englishName;
    private final String folderName;
    private final String russianSingular;
    private final String russianPlural;
    private final String configurationTag;
    private static final Map<String, MetadataKind> BY_ANY_NAME;

    static {
        BY_ANY_NAME = new HashMap<String, MetadataKind>();
        MetadataKind[] metadataKindArray = MetadataKind.values();
        int n = metadataKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataKind kind = metadataKindArray[n2];
            BY_ANY_NAME.put(kind.englishName.toLowerCase(), kind);
            BY_ANY_NAME.put(kind.folderName.toLowerCase(), kind);
            BY_ANY_NAME.put(kind.russianSingular.toLowerCase(), kind);
            BY_ANY_NAME.put(kind.russianPlural.toLowerCase(), kind);
            BY_ANY_NAME.put(kind.configurationTag.toLowerCase(), kind);
            ++n2;
        }
    }

    private MetadataKind(String englishName, String folderName, String russianSingular, String russianPlural, String configurationTag) {
        this.englishName = englishName;
        this.folderName = folderName;
        this.russianSingular = russianSingular;
        this.russianPlural = russianPlural;
        this.configurationTag = configurationTag;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getRussianSingular() {
        return this.russianSingular;
    }

    public String getRussianPlural() {
        return this.russianPlural;
    }

    public String getConfigurationTag() {
        return this.configurationTag;
    }

    public static MetadataKind fromString(String name) {
        if (name == null) {
            return null;
        }
        return BY_ANY_NAME.get(name.toLowerCase().trim());
    }

    public String getDisplayName() {
        return this.russianSingular;
    }

    public String getFqnPrefix() {
        return this.englishName;
    }

    public String buildFqn(String objectName) {
        return this.englishName + "." + objectName;
    }

    public static MetadataKind fromFqn(String fqn) {
        if (fqn == null || !fqn.contains(".")) {
            return null;
        }
        String prefix = fqn.substring(0, fqn.indexOf(46));
        return MetadataKind.fromString(prefix);
    }

    public static String extractNameFromFqn(String fqn) {
        if (fqn == null || !fqn.contains(".")) {
            return null;
        }
        return fqn.substring(fqn.indexOf(46) + 1);
    }

    public String buildConfigurationEntry(String objectName) {
        return "  <" + this.configurationTag + ">" + this.englishName + "." + objectName + "</" + this.configurationTag + ">";
    }
}

