/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.BmMetadataService;
import com.example.vibe.core.tools.metadata.MetadataKind;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;

public class MetadataReferencesTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(MetadataReferencesTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"fqn\": {\n            \"type\": \"string\",\n            \"description\": \"\u041f\u043e\u043b\u043d\u043e\u0435 \u043a\u0432\u0430\u043b\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, Catalog.\u041d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0430)\"\n        },\n        \"kind\": {\n            \"type\": \"string\",\n            \"description\": \"\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: Catalog/\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a, Document/\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438 \u0434\u0440. (\u0435\u0441\u043b\u0438 fqn \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d)\"\n        },\n        \"name\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 (\u0435\u0441\u043b\u0438 fqn \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d)\"\n        },\n        \"limit\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e 100)\"\n        }\n    }\n}\n";
    private static final int DEFAULT_LIMIT = 100;

    @Override
    public String getName() {
        return "metadata_find_references";
    }

    @Override
    public String getDescription() {
        return "\u041d\u0430\u0439\u0442\u0438 \u0432\u0441\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b, \u0441\u0441\u044b\u043b\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445. \u0422\u0440\u0435\u0431\u0443\u0435\u0442 BM API (\u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u0432 EDT).";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] metadata_find_references called with parameters: %s", parameters);
            String fqn = (String)parameters.get("fqn");
            String kindStr = (String)parameters.get("kind");
            String name = (String)parameters.get("name");
            int limit = 100;
            Object v = parameters.get("limit");
            if (v instanceof Number) {
                void num;
                Number number = (Number)v;
                Number cfr_ignored_0 = (Number)v;
                limit = num.intValue();
            }
            LOG.info("[TOOL] metadata_find_references: fqn=%s, kind=%s, name=%s, limit=%d", fqn, kindStr, name, limit);
            if (fqn == null || fqn.isEmpty()) {
                if (kindStr == null || kindStr.isEmpty() || name == null || name.isEmpty()) {
                    LOG.warn("[TOOL] metadata_find_references: missing fqn or kind+name");
                    return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 fqn \u0438\u043b\u0438 kind+name");
                }
                MetadataKind kind = MetadataKind.fromString(kindStr);
                if (kind == null) {
                    LOG.warn("[TOOL] metadata_find_references: unknown kind=%s", kindStr);
                    return ToolResult.failure("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430: " + kindStr + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: Catalog, Document, AccumulationRegister \u0438 \u0434\u0440.");
                }
                fqn = kind.buildFqn(name);
                LOG.info("[TOOL] metadata_find_references: built FQN=%s from kind=%s, name=%s", fqn, kind.getEnglishName(), name);
            }
            try {
                LOG.info("[TOOL] metadata_find_references: checking BM service availability");
                BmMetadataService bmService = BmMetadataService.getInstance();
                if (!bmService.isAvailable()) {
                    LOG.warn("[TOOL] metadata_find_references: BM service not available");
                    return ToolResult.failure("BM \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d. \u041f\u043e\u0438\u0441\u043a \u0441\u0441\u044b\u043b\u043e\u043a \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0439 EDT.");
                }
                LOG.info("[TOOL] metadata_find_references: BM service is available");
                Optional<IProject> projectOpt = bmService.findProject();
                if (projectOpt.isEmpty()) {
                    LOG.warn("[TOOL] metadata_find_references: no V8 project found");
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438");
                }
                LOG.info("[TOOL] metadata_find_references: found project=%s", projectOpt.get().getName());
                LOG.info("[TOOL] metadata_find_references: searching references for FQN=%s, limit=%d", fqn, limit);
                List<BmMetadataService.ReferenceInfo> references = bmService.findReferences(projectOpt.get(), fqn, limit);
                LOG.info("[TOOL] metadata_find_references: found %d references", references.size());
                if (references.isEmpty()) {
                    return ToolResult.success("\u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 " + fqn + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("# \u0421\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 ").append(fqn).append("\n\n");
                sb.append("**\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0441\u044b\u043b\u043e\u043a: ").append(references.size()).append("**\n\n");
                sb.append("| \u041e\u0442\u043a\u0443\u0434\u0430 | \u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e |\n");
                sb.append("|--------|----------|\n");
                for (BmMetadataService.ReferenceInfo ref : references) {
                    String source = ref.sourceFqn != null ? ref.sourceFqn : ref.sourceName;
                    String feature = ref.featureName != null ? ref.featureName : "\u2014";
                    sb.append("| ").append(source);
                    sb.append(" | ").append(feature).append(" |\n");
                }
                if (references.size() == limit) {
                    sb.append("\n*\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u044b\u0435 ").append(limit).append(" \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432*\n");
                }
                LOG.info("[TOOL] metadata_find_references: returning success with %d references", references.size());
                return ToolResult.success(sb.toString());
            }
            catch (Exception e) {
                LOG.warn("[TOOL] metadata_find_references: error finding references for %s: %s", fqn, e.getMessage());
                LOG.debug("[TOOL] metadata_find_references: exception details", e);
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }
}

