/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.metadata.MetadataKind;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class MetadataResolver {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(MetadataResolver.class);
    private static MetadataResolver instance;
    private IProject cachedProject;

    private MetadataResolver() {
    }

    public static synchronized MetadataResolver getInstance() {
        if (instance == null) {
            instance = new MetadataResolver();
        }
        return instance;
    }

    public IProject find1CProject() {
        LOG.debug("[META_RESOLVER] find1CProject: \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u043e\u0438\u0441\u043a\u0430");
        if (this.cachedProject != null && this.cachedProject.exists() && this.cachedProject.isOpen()) {
            IFile configMdo = this.cachedProject.getFile("src/Configuration/Configuration.mdo");
            if (configMdo.exists()) {
                LOG.debug("[META_RESOLVER] \u2713 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u043a\u044d\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442: %s", this.cachedProject.getName());
                return this.cachedProject;
            }
            LOG.debug("[META_RESOLVER] \u041a\u044d\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0432\u0430\u043b\u0438\u0434\u0435\u043d");
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LOG.debug("[META_RESOLVER] Workspace root: %s", root.getLocation());
        IProject[] projects = root.getProjects();
        LOG.debug("[META_RESOLVER] \u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432 \u0432 workspace: %d", projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            LOG.debug("[META_RESOLVER] \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u0440\u043e\u0435\u043a\u0442\u0430: %s (open=%b)", project.getName(), project.isOpen());
            if (project.isOpen()) {
                IFile configMdo = project.getFile("src/Configuration/Configuration.mdo");
                LOG.debug("[META_RESOLVER]   Configuration.mdo exists: %b (path=%s)", configMdo.exists(), configMdo.getFullPath());
                if (configMdo.exists()) {
                    this.cachedProject = project;
                    LOG.info("[META_RESOLVER] \u2713 \u041d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0435\u043a\u0442 1\u0421: %s (\u043f\u0443\u0442\u044c: %s)", project.getName(), project.getLocation());
                    return project;
                }
            }
            ++n2;
        }
        LOG.warn("[META_RESOLVER] \u2717 \u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0447\u0442\u043e \u043f\u0440\u043e\u0435\u043a\u0442 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 workspace.");
        return null;
    }

    public IFolder getSrcFolder() {
        IProject project = this.find1CProject();
        if (project == null) {
            return null;
        }
        IFolder src = project.getFolder("src");
        return src.exists() ? src : null;
    }

    /*
     * WARNING - void declaration
     */
    public List<MetadataObject> listMetadata(MetadataKind kind) throws CoreException {
        ArrayList<MetadataObject> result = new ArrayList<MetadataObject>();
        IFolder srcFolder = this.getSrcFolder();
        if (srcFolder == null) {
            return result;
        }
        IFolder kindFolder = srcFolder.getFolder(kind.getFolderName());
        if (!kindFolder.exists()) {
            return result;
        }
        IResource[] iResourceArray = kindFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            IResource iResource = member;
            if (iResource instanceof IFolder) {
                void objectFolder;
                IFolder cfr_ignored_0 = (IFolder)iResource;
                IFolder cfr_ignored_1 = (IFolder)iResource;
                String name = objectFolder.getName();
                IFile mdoFile = objectFolder.getFile(name + ".mdo");
                if (mdoFile.exists()) {
                    result.add(new MetadataObject(kind, name, (IFolder)objectFolder));
                }
            }
            ++n2;
        }
        return result;
    }

    public List<MetadataObject> searchMetadata(String namePattern) throws CoreException {
        ArrayList<MetadataObject> result = new ArrayList<MetadataObject>();
        String lowerPattern = namePattern != null ? namePattern.toLowerCase() : "";
        MetadataKind[] metadataKindArray = MetadataKind.values();
        int n = metadataKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataKind kind = metadataKindArray[n2];
            for (MetadataObject obj : this.listMetadata(kind)) {
                if (namePattern != null && !obj.getName().toLowerCase().contains(lowerPattern)) continue;
                result.add(obj);
            }
            ++n2;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public MetadataObject getMetadata(MetadataKind kind, String name) {
        IFolder srcFolder = this.getSrcFolder();
        if (srcFolder == null) {
            return null;
        }
        IFolder kindFolder = srcFolder.getFolder(kind.getFolderName());
        if (!kindFolder.exists()) {
            return null;
        }
        IFolder objectFolder = kindFolder.getFolder(name);
        if (!objectFolder.exists()) {
            try {
                IResource[] iResourceArray = kindFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    IResource iResource = member;
                    if (iResource instanceof IFolder) {
                        void folder;
                        IFolder cfr_ignored_0 = (IFolder)iResource;
                        IFolder cfr_ignored_1 = (IFolder)iResource;
                        if (folder.getName().equalsIgnoreCase(name)) {
                            objectFolder = folder;
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        if (!objectFolder.exists()) {
            return null;
        }
        IFile mdoFile = objectFolder.getFile(objectFolder.getName() + ".mdo");
        if (!mdoFile.exists()) {
            return null;
        }
        return new MetadataObject(kind, objectFolder.getName(), objectFolder);
    }

    public static class MetadataObject {
        private final MetadataKind kind;
        private final String name;
        private final IFolder folder;

        public MetadataObject(MetadataKind kind, String name, IFolder folder) {
            this.kind = kind;
            this.name = name;
            this.folder = folder;
        }

        public MetadataKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public IFolder getFolder() {
            return this.folder;
        }

        public String getPath() {
            return this.folder.getFullPath().toString();
        }

        public IFile getMdoFile() {
            return this.folder.getFile(this.name + ".mdo");
        }

        public IFile getObjectModule() {
            IFile file = this.folder.getFile("ObjectModule.bsl");
            return file.exists() ? file : null;
        }

        public IFile getManagerModule() {
            IFile file = this.folder.getFile("ManagerModule.bsl");
            return file.exists() ? file : null;
        }

        public IFile getRecordSetModule() {
            IFile file = this.folder.getFile("RecordSetModule.bsl");
            return file.exists() ? file : null;
        }

        public IFile getModule() {
            IFile file = this.folder.getFile("Module.bsl");
            return file.exists() ? file : null;
        }

        /*
         * WARNING - void declaration
         */
        public List<String> getFormNames() throws CoreException {
            ArrayList<String> forms = new ArrayList<String>();
            IFolder formsFolder = this.folder.getFolder("Forms");
            if (formsFolder.exists()) {
                IResource[] iResourceArray = formsFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    IResource iResource = member;
                    if (iResource instanceof IFolder) {
                        void formFolder;
                        IFolder cfr_ignored_0 = (IFolder)iResource;
                        IFolder cfr_ignored_1 = (IFolder)iResource;
                        IFile moduleFile = formFolder.getFile("Module.bsl");
                        if (moduleFile.exists()) {
                            forms.add(formFolder.getName());
                        }
                    }
                    ++n2;
                }
            }
            return forms;
        }

        public IFile getFormModule(String formName) {
            IFolder formsFolder = this.folder.getFolder("Forms");
            if (!formsFolder.exists()) {
                return null;
            }
            IFolder formFolder = formsFolder.getFolder(formName);
            if (!formFolder.exists()) {
                return null;
            }
            IFile file = formFolder.getFile("Module.bsl");
            return file.exists() ? file : null;
        }

        public List<String> getAvailableModules() throws CoreException {
            ArrayList<String> modules = new ArrayList<String>();
            if (this.getModule() != null) {
                modules.add("Module");
            }
            if (this.getObjectModule() != null) {
                modules.add("ObjectModule");
            }
            if (this.getManagerModule() != null) {
                modules.add("ManagerModule");
            }
            if (this.getRecordSetModule() != null) {
                modules.add("RecordSetModule");
            }
            for (String formName : this.getFormNames()) {
                modules.add("Form:" + formName);
            }
            return modules;
        }

        public String getMdoPath() {
            return this.getMdoFile().getFullPath().toString();
        }

        public String toString() {
            return this.kind.getRussianSingular() + "." + this.name;
        }
    }
}

