/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.core.tools.metadata.MetadataResolver;
import com.example.vibe.core.tools.metadata.services.ConfigurationMdoService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;

public class ModifySubsystemTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ModifySubsystemTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"subsystem\": {\n            \"type\": \"string\",\n            \"description\": \"\u0418\u043c\u044f \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b (\u0438\u043b\u0438 \u043f\u0443\u0442\u044c \u0434\u043b\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445: \u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c.\u0414\u043e\u0447\u0435\u0440\u043d\u044f\u044f)\"\n        },\n        \"add\": {\n            \"type\": \"array\",\n            \"items\": { \"type\": \"string\" },\n            \"description\": \"FQN \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440: Catalog.\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u044b)\"\n        },\n        \"remove\": {\n            \"type\": \"array\",\n            \"items\": { \"type\": \"string\" },\n            \"description\": \"FQN \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0438\u0437 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b\"\n        }\n    },\n    \"required\": [\"subsystem\"]\n}\n";
    private final ConfigurationMdoService configService = ConfigurationMdoService.getInstance();

    @Override
    public String getName() {
        return "modify_subsystem";
    }

    @Override
    public String getDescription() {
        return "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043e\u0441\u0442\u0430\u0432\u0430 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b 1\u0421: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432";
    }

    @Override
    public String getParameterSchema() {
        return SCHEMA;
    }

    @Override
    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            LOG.info("[TOOL] modify_subsystem called with parameters: %s", parameters);
            try {
                String subsystemName = (String)parameters.get("subsystem");
                List toAdd = (List)parameters.get("add");
                List toRemove = (List)parameters.get("remove");
                if (subsystemName == null || subsystemName.isEmpty()) {
                    return ToolResult.failure("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b");
                }
                if ((toAdd == null || toAdd.isEmpty()) && (toRemove == null || toRemove.isEmpty())) {
                    return ToolResult.failure("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f (add) \u0438\u043b\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f (remove)");
                }
                MetadataResolver resolver = MetadataResolver.getInstance();
                IProject project = resolver.find1CProject();
                if (project == null) {
                    return ToolResult.failure("\u041f\u0440\u043e\u0435\u043a\u0442 1\u0421 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                StringBuilder result = new StringBuilder();
                result.append("\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430 **").append(subsystemName).append("**\n\n");
                int addedCount = 0;
                if (toAdd != null && !toAdd.isEmpty()) {
                    result.append("**\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e:**\n");
                    for (String fqn : toAdd) {
                        try {
                            this.configService.addToSubsystem(project, subsystemName, fqn);
                            result.append("- \u2705 ").append(fqn).append("\n");
                            ++addedCount;
                        }
                        catch (Exception e) {
                            result.append("- \u274c ").append(fqn).append(" (").append(e.getMessage()).append(")\n");
                        }
                    }
                }
                int removedCount = 0;
                if (toRemove != null && !toRemove.isEmpty()) {
                    result.append("\n**\u0423\u0434\u0430\u043b\u0435\u043d\u043e:**\n");
                    for (String fqn : toRemove) {
                        try {
                            this.configService.removeFromSubsystem(project, subsystemName, fqn);
                            result.append("- \u2705 ").append(fqn).append("\n");
                            ++removedCount;
                        }
                        catch (Exception e) {
                            result.append("- \u274c ").append(fqn).append(" (").append(e.getMessage()).append(")\n");
                        }
                    }
                }
                LOG.info("[TOOL] modify_subsystem: \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e %d, \u0443\u0434\u0430\u043b\u0435\u043d\u043e %d", addedCount, removedCount);
                return ToolResult.success(result.toString());
            }
            catch (Exception e) {
                LOG.error("[TOOL] modify_subsystem error: %s", e.getMessage());
                return ToolResult.failure("\u041e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        });
    }
}

