/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata.services;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.metadata.MetadataKind;
import com.example.vibe.core.tools.metadata.services.MdoXmlService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ConfigurationMdoService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ConfigurationMdoService.class);
    private static final String CONFIGURATION_MDO_PATH = "src/Configuration/Configuration.mdo";
    private static ConfigurationMdoService instance;
    private final MdoXmlService xmlService = MdoXmlService.getInstance();

    private ConfigurationMdoService() {
    }

    public static synchronized ConfigurationMdoService getInstance() {
        if (instance == null) {
            instance = new ConfigurationMdoService();
        }
        return instance;
    }

    public void addObject(IProject project, MetadataKind kind, String name) throws CoreException {
        String newContent;
        LOG.info("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        LOG.info("[CONFIG_MDO] \u25b6 addObject: %s.%s", kind.getEnglishName(), name);
        LOG.debug("[CONFIG_MDO] \u041f\u0440\u043e\u0435\u043a\u0442: %s", project.getName());
        LOG.debug("[CONFIG_MDO] \u0420\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430: %s", project.getLocation());
        IFile configFile = project.getFile(CONFIGURATION_MDO_PATH);
        LOG.info("[CONFIG_MDO] \u041f\u0443\u0442\u044c \u043a Configuration.mdo: %s", configFile.getFullPath());
        LOG.debug("[CONFIG_MDO] \u041f\u043e\u043b\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0430 \u0434\u0438\u0441\u043a\u0435: %s", configFile.getLocation());
        if (!configFile.exists()) {
            String errorMsg = "Configuration.mdo \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + String.valueOf(configFile.getFullPath());
            LOG.error("[CONFIG_MDO] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: %s", errorMsg);
            LOG.error("[CONFIG_MDO] \u041e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0430 \u0434\u0438\u0441\u043a\u0435: %s", configFile.getLocation());
            throw new RuntimeException(errorMsg);
        }
        LOG.debug("[CONFIG_MDO] \u2713 Configuration.mdo \u043d\u0430\u0439\u0434\u0435\u043d");
        LOG.debug("[CONFIG_MDO] \u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e Configuration.mdo...");
        String content = this.xmlService.getMdoContent(configFile);
        LOG.debug("[CONFIG_MDO] \u0420\u0430\u0437\u043c\u0435\u0440 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e: %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", content.length());
        String tagName = this.getTagName(kind);
        String fqn = kind.getEnglishName() + "." + name;
        String newElement = "  <" + tagName + ">" + fqn + "</" + tagName + ">";
        LOG.info("[CONFIG_MDO] \u0422\u0435\u0433 \u0434\u043b\u044f \u0442\u0438\u043f\u0430 %s: <%s>", kind.getEnglishName(), tagName);
        LOG.info("[CONFIG_MDO] FQN \u043e\u0431\u044a\u0435\u043a\u0442\u0430: %s", fqn);
        LOG.debug("[CONFIG_MDO] \u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442: %s", newElement);
        String searchPattern = ">" + fqn + "<";
        if (content.contains(searchPattern)) {
            LOG.info("[CONFIG_MDO] \u26a0 \u041e\u0431\u044a\u0435\u043a\u0442 %s \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0432 Configuration.mdo, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c", fqn);
            LOG.info("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            return;
        }
        LOG.debug("[CONFIG_MDO] \u041e\u0431\u044a\u0435\u043a\u0442 \u0435\u0449\u0451 \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c...");
        String pattern = "(<" + tagName + ">.*?</" + tagName + ">)";
        LOG.debug("[CONFIG_MDO] \u041f\u043e\u0438\u0441\u043a \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u043e \u043f\u0430\u0442\u0442\u0435\u0440\u043d\u0443: %s", pattern);
        Pattern p = Pattern.compile(pattern, 32);
        Matcher m = p.matcher(content);
        int lastEnd = -1;
        int count = 0;
        while (m.find()) {
            lastEnd = m.end();
            ++count;
        }
        LOG.debug("[CONFIG_MDO] \u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 <%s>: %d", tagName, count);
        if (lastEnd > 0) {
            LOG.debug("[CONFIG_MDO] \u0412\u0441\u0442\u0430\u0432\u043a\u0430 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e <%s> \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 %d", tagName, lastEnd);
            newContent = content.substring(0, lastEnd) + "\n" + newElement + content.substring(lastEnd);
        } else {
            LOG.debug("[CONFIG_MDO] \u041d\u0435\u0442 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 <%s>, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u0435\u0440\u0435\u0434 </mdclass:Configuration>", tagName);
            int closeTag = content.lastIndexOf("</mdclass:Configuration>");
            if (closeTag < 0) {
                LOG.error("[CONFIG_MDO] \u2717 \u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0438\u0439 \u0442\u0435\u0433 </mdclass:Configuration>");
                throw new RuntimeException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 Configuration.mdo");
            }
            LOG.debug("[CONFIG_MDO] \u041f\u043e\u0437\u0438\u0446\u0438\u044f </mdclass:Configuration>: %d", closeTag);
            newContent = content.substring(0, closeTag) + newElement + "\n" + content.substring(closeTag);
        }
        LOG.debug("[CONFIG_MDO] \u041d\u043e\u0432\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e: %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 (\u0431\u044b\u043b\u043e %d)", newContent.length(), content.length());
        LOG.info("[CONFIG_MDO] \u0417\u0430\u043f\u0438\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 Configuration.mdo...");
        this.xmlService.writeMdo(configFile, newContent);
        LOG.info("[CONFIG_MDO] \u2713 \u0423\u0421\u041f\u0415\u0428\u041d\u041e: \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d <%s>%s</%s>", tagName, fqn, tagName);
        LOG.info("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
    }

    public void removeObject(IProject project, MetadataKind kind, String name) throws CoreException {
        String fqn;
        String tagName;
        String pattern;
        IFile configFile = project.getFile(CONFIGURATION_MDO_PATH);
        if (!configFile.exists()) {
            throw new RuntimeException("Configuration.mdo \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + String.valueOf(configFile.getFullPath()));
        }
        String content = this.xmlService.getMdoContent(configFile);
        String newContent = content.replaceAll(pattern = "\\s*<" + (tagName = this.getTagName(kind)) + ">" + Pattern.quote(fqn = kind.getEnglishName() + "." + name) + "</" + tagName + ">", "");
        if (!newContent.equals(content)) {
            this.xmlService.writeMdo(configFile, newContent);
            LOG.info("\u0423\u0434\u0430\u043b\u0451\u043d %s \u0438\u0437 Configuration.mdo", fqn);
        } else {
            LOG.debug("\u041e\u0431\u044a\u0435\u043a\u0442 %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 Configuration.mdo", fqn);
        }
    }

    public boolean hasObject(IProject project, MetadataKind kind, String name) {
        IFile configFile;
        block3: {
            LOG.debug("[CONFIG_MDO] hasObject: \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 %s.%s", kind.getEnglishName(), name);
            try {
                configFile = project.getFile(CONFIGURATION_MDO_PATH);
                if (configFile.exists()) break block3;
                LOG.debug("[CONFIG_MDO] hasObject: Configuration.mdo \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                return false;
            }
            catch (Exception e) {
                LOG.warn("[CONFIG_MDO] hasObject: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: %s", e.getMessage());
                return false;
            }
        }
        String content = this.xmlService.getMdoContent(configFile);
        String fqn = kind.getEnglishName() + "." + name;
        String searchPattern = ">" + fqn + "<";
        boolean exists = content.contains(searchPattern);
        LOG.debug("[CONFIG_MDO] hasObject: %s %s \u0432 Configuration.mdo", fqn, exists ? "\u041d\u0410\u0419\u0414\u0415\u041d" : "\u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d");
        return exists;
    }

    private String getTagName(MetadataKind kind) {
        return kind.getConfigurationTag();
    }

    public void addToSubsystem(IProject project, String subsystemName, String objectFqn) throws CoreException {
        String newContent;
        String contentElement;
        Object subsystemPath;
        String[] parts = subsystemName.split("\\.");
        if (parts.length == 1) {
            subsystemPath = "src/Subsystems/" + subsystemName + "/" + subsystemName + ".mdo";
        } else {
            StringBuilder path = new StringBuilder("src/Subsystems");
            int i = 0;
            while (i < parts.length) {
                path.append("/").append(parts[i]);
                if (i < parts.length - 1) {
                    path.append("/Subsystems");
                }
                ++i;
            }
            path.append("/").append(parts[parts.length - 1]).append(".mdo");
            subsystemPath = path.toString();
        }
        IFile subsystemFile = project.getFile((String)subsystemPath);
        if (!subsystemFile.exists()) {
            LOG.warn("\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430: %s", subsystemPath);
            return;
        }
        String content = this.xmlService.getMdoContent(subsystemFile);
        if (content.contains(contentElement = "<content>" + objectFqn + "</content>")) {
            LOG.debug("\u041e\u0431\u044a\u0435\u043a\u0442 %s \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0435 %s", objectFqn, subsystemName);
            return;
        }
        Pattern p = Pattern.compile("(<content>.*?</content>)", 32);
        Matcher m = p.matcher(content);
        int lastEnd = -1;
        while (m.find()) {
            lastEnd = m.end();
        }
        String newElement = "  " + contentElement;
        if (lastEnd > 0) {
            newContent = content.substring(0, lastEnd) + "\n" + newElement + content.substring(lastEnd);
        } else {
            int closeTag = content.lastIndexOf("</mdclass:Subsystem>");
            if (closeTag < 0) {
                throw new RuntimeException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 Subsystem.mdo");
            }
            newContent = content.substring(0, closeTag) + newElement + "\n" + content.substring(closeTag);
        }
        this.xmlService.writeMdo(subsystemFile, newContent);
        LOG.info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d %s \u0432 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0443 %s", objectFqn, subsystemName);
    }

    public void removeFromSubsystem(IProject project, String subsystemName, String objectFqn) throws CoreException {
        String pattern;
        Object subsystemPath;
        String[] parts = subsystemName.split("\\.");
        if (parts.length == 1) {
            subsystemPath = "src/Subsystems/" + subsystemName + "/" + subsystemName + ".mdo";
        } else {
            StringBuilder path = new StringBuilder("src/Subsystems");
            int i = 0;
            while (i < parts.length) {
                path.append("/").append(parts[i]);
                if (i < parts.length - 1) {
                    path.append("/Subsystems");
                }
                ++i;
            }
            path.append("/").append(parts[parts.length - 1]).append(".mdo");
            subsystemPath = path.toString();
        }
        IFile subsystemFile = project.getFile((String)subsystemPath);
        if (!subsystemFile.exists()) {
            LOG.warn("\u041f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430: %s", subsystemPath);
            return;
        }
        String content = this.xmlService.getMdoContent(subsystemFile);
        String newContent = content.replaceAll(pattern = "\\s*<content>" + Pattern.quote(objectFqn) + "</content>", "");
        if (!newContent.equals(content)) {
            this.xmlService.writeMdo(subsystemFile, newContent);
            LOG.info("\u0423\u0434\u0430\u043b\u0451\u043d %s \u0438\u0437 \u043f\u043e\u0434\u0441\u0438\u0441\u0442\u0435\u043c\u044b %s", objectFqn, subsystemName);
        }
    }
}

